/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.process;

import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.InlineSubreportMarker;
import org.pentaho.reporting.engine.classic.core.states.process.AdvanceHandler;
import org.pentaho.reporting.engine.classic.core.states.process.InlineSubreportProcessor;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessState;

public class EndSubReportHandler
implements AdvanceHandler {
    public static final AdvanceHandler HANDLER = new EndSubReportHandler();

    private EndSubReportHandler() {
    }

    public ProcessState advance(ProcessState state) throws ReportProcessingException {
        return state.deriveForAdvance();
    }

    public ProcessState commit(ProcessState state) throws ReportProcessingException {
        InlineSubreportMarker[] subReports = state.getSubReports();
        int currentSubReport = state.getCurrentSubReport();
        int nextIndex = InlineSubreportProcessor.findNextIndex(subReports, state.getSubreportProcessingType(), currentSubReport + 1);
        if (nextIndex != -1) {
            ProcessState parentState = (ProcessState)state.getParentSubReportState();
            ProcessState parentNext = parentState.returnFromSubReport(state.getLayoutProcess().getParent());
            parentNext.setFlowController(state.getFlowController());
            parentNext.setSequenceCounter(state.getSequenceCounter() + 1);
            ProcessState processState = new ProcessState();
            processState.initializeForSubreport(subReports, nextIndex, parentNext);
            return processState;
        }
        ProcessState parentState = (ProcessState)state.getParentSubReportState();
        ProcessState parentNext = parentState.returnFromSubReport(state.getLayoutProcess().getParent());
        parentNext.setFlowController(state.getFlowController());
        parentNext.setSequenceCounter(state.getSequenceCounter() + 1);
        return parentNext;
    }

    public boolean isFinish() {
        return false;
    }

    public int getEventCode() {
        return -2147483136;
    }

    public boolean isRestoreHandler() {
        return false;
    }
}

