/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.process;

import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.layout.InlineSubreportMarker;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessState;
import org.pentaho.reporting.engine.classic.core.states.process.SubReportProcessType;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.LinkedMap;

public class InlineSubreportProcessor {
    private static InstanceID DUMMY_SUBREPORT_MARKER = new InstanceID();
    private static InlineSubreportMarker[] EMPTY_MARKERS = new InlineSubreportMarker[0];

    private InlineSubreportProcessor() {
    }

    private static InlineSubreportMarker[] collectMarkers(ProcessState state, RootLevelBand rootLevelBand) throws ReportProcessingException {
        LinkedMap markers = InlineSubreportProcessor.collectSubReportMarkers(state, rootLevelBand);
        if (markers == null || markers.size() == 0) {
            return EMPTY_MARKERS;
        }
        return (InlineSubreportMarker[])markers.values((Object[])new InlineSubreportMarker[markers.size()]);
    }

    public static ProcessState processInline(ProcessState state, RootLevelBand rootLevelBand) throws ReportProcessingException {
        InlineSubreportMarker[] markers = InlineSubreportProcessor.collectMarkers(state, rootLevelBand);
        if (markers.length == 0) {
            return state;
        }
        state.getLayoutProcess().getOutputFunction().clearInlineSubreports(SubReportProcessType.INLINE);
        int index = InlineSubreportProcessor.findNextIndex(markers, SubReportProcessType.INLINE, 0);
        if (index == -1) {
            return state;
        }
        try {
            state = (ProcessState)state.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
        ReportStateKey processKey = state.getProcessKey();
        ProcessState process = new ProcessState();
        process.initializeForSubreport(markers, index, state);
        while (!processKey.equals(process.getProcessKey())) {
            if (processKey.equals((process = process.advance()).getProcessKey())) {
                throw new IllegalStateException("You cannot switch contexts when not being commited!");
            }
            process = process.commit();
        }
        return process;
    }

    public static boolean hasSubReports(ProcessState state, RootLevelBand rootLevelBand) throws ReportProcessingException {
        LinkedMap markers = InlineSubreportProcessor.collectSubReportMarkers(state, rootLevelBand);
        return markers != null && markers.size() != 0;
    }

    public static ProcessState process(ProcessState state, RootLevelBand rootLevelBand) throws ReportProcessingException {
        InlineSubreportMarker[] markers = InlineSubreportProcessor.collectMarkers(state, rootLevelBand);
        if (markers.length == 0) {
            return state;
        }
        state.getLayoutProcess().getOutputFunction().clearInlineSubreports(SubReportProcessType.BANDED);
        int index = InlineSubreportProcessor.findNextIndex(markers, SubReportProcessType.BANDED, 0);
        if (index == -1) {
            return state;
        }
        ProcessState pstate = new ProcessState();
        pstate.initializeForSubreport(markers, index, state);
        return pstate;
    }

    private static LinkedMap collectSubReportMarkers(ProcessState state, RootLevelBand rootLevelBand) throws ReportProcessingException {
        LinkedMap list = InlineSubreportProcessor.collectSubReportMarkers((Section)((Object)rootLevelBand), null);
        if (list == null) {
            InlineSubreportMarker[] subreports = state.getLayoutProcess().getOutputFunction().getInlineSubreports();
            if (subreports.length == 0) {
                return null;
            }
            LinkedMap map = new LinkedMap();
            for (int i = 0; i < subreports.length; ++i) {
                InlineSubreportMarker subreport = subreports[i];
                map.put((Object)subreport.getSubreport().getObjectID(), (Object)subreport);
            }
            return map;
        }
        InlineSubreportMarker[] markers = state.getLayoutProcess().getOutputFunction().getInlineSubreports();
        for (int i = 0; i < markers.length; ++i) {
            InlineSubreportMarker marker = markers[i];
            list.put((Object)marker.getSubreport().getObjectID(), (Object)marker);
        }
        return list;
    }

    private static LinkedMap collectBandedSubReportMarkers(RootLevelBand rootLevelBand, LinkedMap list) throws ReportProcessingException {
        int count = rootLevelBand.getSubReportCount();
        for (int i = 0; i < count; ++i) {
            SubReport element = rootLevelBand.getSubReport(i);
            if (list == null) {
                list = new LinkedMap();
            }
            list.put((Object)element.getObjectID(), (Object)new InlineSubreportMarker(element, null, SubReportProcessType.BANDED));
        }
        return list;
    }

    private static LinkedMap collectSubReportMarkers(Section rootLevelBand, LinkedMap list) throws ReportProcessingException {
        if (rootLevelBand instanceof RootLevelBand) {
            list = InlineSubreportProcessor.collectBandedSubReportMarkers((RootLevelBand)((Object)rootLevelBand), list);
        }
        int count = rootLevelBand.getElementCount();
        for (int i = 0; i < count; ++i) {
            ReportElement element = rootLevelBand.getElement(i);
            if (element instanceof SubReport) {
                if (list == null) {
                    list = new LinkedMap();
                }
                list.put((Object)element.getObjectID(), (Object)new InlineSubreportMarker((SubReport)element, DUMMY_SUBREPORT_MARKER, SubReportProcessType.INLINE));
                continue;
            }
            if (!(element instanceof Section)) continue;
            list = InlineSubreportProcessor.collectSubReportMarkers((Section)element, list);
        }
        return list;
    }

    public static int findNextIndex(InlineSubreportMarker[] markers, SubReportProcessType type, int startIndex) {
        for (int i = startIndex; i < markers.length; ++i) {
            InlineSubreportMarker marker = markers[i];
            if (marker.getProcessType() != type) continue;
            return i;
        }
        return -1;
    }
}

