/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.process;

import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroup;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.states.datarow.DefaultFlowController;
import org.pentaho.reporting.engine.classic.core.states.process.AdvanceHandler;
import org.pentaho.reporting.engine.classic.core.states.process.BeginCrosstabOtherAxisHandler;
import org.pentaho.reporting.engine.classic.core.states.process.EndCrosstabHandler;
import org.pentaho.reporting.engine.classic.core.states.process.EndCrosstabOtherAxisHandler;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessState;

public class JoinEndCrosstabOtherAxisHandler
implements AdvanceHandler {
    public static final AdvanceHandler HANDLER = new JoinEndCrosstabOtherAxisHandler();

    public ProcessState advance(ProcessState state) throws ReportProcessingException {
        return state.deriveForAdvance();
    }

    private boolean isRootGroup(ProcessState state) {
        return state.getCurrentGroupIndex() == -1;
    }

    public ProcessState commit(ProcessState next) throws ReportProcessingException {
        next.leaveGroup();
        DefaultFlowController fc = next.getFlowController();
        boolean advanceRequested = fc.isAdvanceRequested();
        boolean advanceable = fc.getMasterRow().isAdvanceable();
        if (this.isRootGroup(next)) {
            throw new ReportProcessingException("This report is invalid. A CR-Other-Group cannot be a root group.");
        }
        Group parentGroup = next.getReport().getGroup(next.getCurrentGroupIndex());
        if (!advanceRequested || !advanceable) {
            if (parentGroup instanceof CrosstabGroup) {
                next.setAdvanceHandler(EndCrosstabHandler.HANDLER);
            } else if (parentGroup instanceof CrosstabOtherGroup) {
                next.setAdvanceHandler(EndCrosstabOtherAxisHandler.HANDLER);
            } else {
                throw new ReportProcessingException("This report is invalid.");
            }
            return next;
        }
        DefaultFlowController cfc = fc.performCommit();
        if (ProcessState.isLastItemInGroup(parentGroup, fc.getMasterRow(), cfc.getMasterRow())) {
            if (parentGroup instanceof CrosstabGroup) {
                next.setAdvanceHandler(EndCrosstabHandler.HANDLER);
            } else if (parentGroup instanceof CrosstabOtherGroup) {
                next.setAdvanceHandler(EndCrosstabOtherAxisHandler.HANDLER);
            } else {
                throw new ReportProcessingException("This report is invalid.");
            }
            return next;
        }
        DefaultFlowController rfc = cfc.resetRowCursor();
        next.setFlowController(rfc);
        next.setAdvanceHandler(BeginCrosstabOtherAxisHandler.HANDLER);
        return next;
    }

    public boolean isFinish() {
        return false;
    }

    public int getEventCode() {
        return -2147417984;
    }

    public boolean isRestoreHandler() {
        return false;
    }
}

