/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.process;

import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.states.datarow.DefaultFlowController;
import org.pentaho.reporting.engine.classic.core.states.process.AdvanceHandler;
import org.pentaho.reporting.engine.classic.core.states.process.BeginGroupHandler;
import org.pentaho.reporting.engine.classic.core.states.process.EndGroupHandler;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessState;
import org.pentaho.reporting.engine.classic.core.states.process.ReportFooterHandler;

public class JoinEndGroupHandler
implements AdvanceHandler {
    public static final AdvanceHandler HANDLER = new JoinEndGroupHandler();

    private JoinEndGroupHandler() {
    }

    public int getEventCode() {
        return -2147483520;
    }

    public ProcessState advance(ProcessState state) throws ReportProcessingException {
        return state.deriveForAdvance();
    }

    public ProcessState commit(ProcessState next) throws ReportProcessingException {
        next.leaveGroup();
        DefaultFlowController fc = next.getFlowController();
        boolean advanceRequested = fc.isAdvanceRequested();
        boolean advanceable = fc.getMasterRow().isAdvanceable();
        if (this.isRootGroup(next)) {
            if (advanceRequested && advanceable) {
                DefaultFlowController cfc = fc.performCommit();
                next.setFlowController(cfc);
                next.setAdvanceHandler(BeginGroupHandler.HANDLER);
                return next;
            }
            next.setAdvanceHandler(ReportFooterHandler.HANDLER);
            return next;
        }
        if (!advanceRequested || !advanceable) {
            next.setAdvanceHandler(EndGroupHandler.HANDLER);
            return next;
        }
        Group group = next.getReport().getGroup(next.getCurrentGroupIndex());
        DefaultFlowController cfc = fc.performCommit();
        if (ProcessState.isLastItemInGroup(group, fc.getMasterRow(), cfc.getMasterRow())) {
            next.setAdvanceHandler(EndGroupHandler.HANDLER);
            return next;
        }
        next.setFlowController(cfc);
        next.setAdvanceHandler(BeginGroupHandler.HANDLER);
        return next;
    }

    public boolean isFinish() {
        return false;
    }

    private boolean isRootGroup(ProcessState state) {
        return state.getCurrentGroupIndex() == -1;
    }

    public boolean isRestoreHandler() {
        return false;
    }
}

