/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.process;

import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.states.process.AdvanceHandler;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessState;

public class PendingPagesHandler
implements AdvanceHandler {
    private AdvanceHandler handler;

    public PendingPagesHandler(AdvanceHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handler = handler;
    }

    public ProcessState advance(ProcessState state) throws ReportProcessingException {
        ProcessState newState = state.deriveForAdvance();
        newState.getFlowController().getMasterRow().refresh();
        newState.getLayoutProcess().restart(newState);
        return newState;
    }

    public ProcessState commit(ProcessState state) throws ReportProcessingException {
        ProcessState nstate = state.deriveForAdvance();
        nstate.setAdvanceHandler(this.handler);
        return this.handler.commit(nstate);
    }

    public boolean isFinish() {
        return this.handler.isFinish();
    }

    public int getEventCode() {
        return this.handler.getEventCode();
    }

    public static ProcessState create(ProcessState state) {
        if (state.getAdvanceHandler() instanceof PendingPagesHandler) {
            return state.deriveForAdvance();
        }
        ProcessState newstate = state.deriveForAdvance();
        newstate.setAdvanceHandler(new PendingPagesHandler(newstate.getAdvanceHandler()));
        return newstate;
    }

    public boolean isRestoreHandler() {
        return true;
    }
}

