/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ReportParameterValidationException;
import org.pentaho.reporting.engine.classic.core.ReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.cache.CachingDataFactory;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.filter.types.ExternalElementType;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.function.sys.AttributeExpressionsEvaluator;
import org.pentaho.reporting.engine.classic.core.function.sys.CellFormatFunction;
import org.pentaho.reporting.engine.classic.core.function.sys.MetaDataStyleEvaluator;
import org.pentaho.reporting.engine.classic.core.function.sys.SheetNameFunction;
import org.pentaho.reporting.engine.classic.core.function.sys.StyleExpressionsEvaluator;
import org.pentaho.reporting.engine.classic.core.function.sys.WizardItemHideFunction;
import org.pentaho.reporting.engine.classic.core.layout.InlineSubreportMarker;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterValidator;
import org.pentaho.reporting.engine.classic.core.parameters.ValidationResult;
import org.pentaho.reporting.engine.classic.core.states.DataFactoryManager;
import org.pentaho.reporting.engine.classic.core.states.DefaultGroupingState;
import org.pentaho.reporting.engine.classic.core.states.FunctionStorage;
import org.pentaho.reporting.engine.classic.core.states.FunctionStorageKey;
import org.pentaho.reporting.engine.classic.core.states.GroupStartRecord;
import org.pentaho.reporting.engine.classic.core.states.GroupingState;
import org.pentaho.reporting.engine.classic.core.states.IgnoreEverythingReportErrorHandler;
import org.pentaho.reporting.engine.classic.core.states.InitialLayoutProcess;
import org.pentaho.reporting.engine.classic.core.states.LayoutProcess;
import org.pentaho.reporting.engine.classic.core.states.ProcessStateHandle;
import org.pentaho.reporting.engine.classic.core.states.ReportDefinitionImpl;
import org.pentaho.reporting.engine.classic.core.states.ReportProcessingErrorHandler;
import org.pentaho.reporting.engine.classic.core.states.ReportState;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.states.StateUtilities;
import org.pentaho.reporting.engine.classic.core.states.StructureFunctionComparator;
import org.pentaho.reporting.engine.classic.core.states.SubLayoutProcess;
import org.pentaho.reporting.engine.classic.core.states.SubReportStorage;
import org.pentaho.reporting.engine.classic.core.states.crosstab.CrosstabProcessorFunction;
import org.pentaho.reporting.engine.classic.core.states.datarow.DefaultFlowController;
import org.pentaho.reporting.engine.classic.core.states.datarow.InlineDataRowRuntime;
import org.pentaho.reporting.engine.classic.core.states.datarow.MasterDataRow;
import org.pentaho.reporting.engine.classic.core.states.datarow.ReportDataRow;
import org.pentaho.reporting.engine.classic.core.states.process.AdvanceHandler;
import org.pentaho.reporting.engine.classic.core.states.process.BeginReportHandler;
import org.pentaho.reporting.engine.classic.core.states.process.EndSubReportHandler;
import org.pentaho.reporting.engine.classic.core.states.process.SubReportProcessType;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaDefinition;
import org.pentaho.reporting.engine.classic.core.wizard.ProxyDataSchemaDefinition;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.FastStack;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ProcessState
implements ReportState {
    public static final int ARTIFICIAL_EVENT_CODE = Integer.MIN_VALUE;
    private static final Log logger = LogFactory.getLog(ProcessState.class);
    private int currentGroupIndex;
    private int currentPresentationGroupIndex;
    private ReportDefinitionImpl report;
    private int currentSubReport;
    private InlineSubreportMarker[] subReports;
    private ProcessState parentState;
    private ProcessState parentSubReportState;
    private FunctionStorage functionStorage;
    private FunctionStorage structureFunctionStorage;
    private DataFactoryManager dataFactoryManager;
    private InternalProcessHandle processHandle;
    private DefaultFlowController flowController;
    private LayoutProcess layoutProcess;
    private ReportStateKey processKey;
    private AdvanceHandler advanceHandler;
    private ReportProcessingErrorHandler errorHandler;
    private int sequenceCounter;
    private boolean inItemGroup;
    private InlineSubreportMarker currentSubReportMarker;
    private boolean inlineProcess;
    private FastStack groupStarts;
    private boolean structuralPreprocessingNeeded;
    private HashSet processLevels;
    private SubReportStorage subReportStorage;
    private String query;
    private Integer queryLimit;
    private Integer queryTimeout;
    private boolean reportInstancesShareConnection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeForMasterReport(MasterReport report, ProcessingContext processingContext, InitialLayoutProcess layoutProcess) throws ReportProcessingException {
        ReportParameterValues parameterValues;
        if (layoutProcess == null) {
            throw new NullPointerException("LayoutProcess must not be null.");
        }
        if (report == null) {
            throw new NullPointerException("Report must not be null");
        }
        if (processingContext == null) {
            throw new NullPointerException("ProcessingContext must not be null.");
        }
        ReportParameterDefinition parameters = report.getParameterDefinition();
        DefaultParameterContext parameterContext = new DefaultParameterContext(report);
        parameterContext.open();
        try {
            ReportParameterValidator reportParameterValidator = parameters.getValidator();
            ValidationResult validationResult = reportParameterValidator.validate(new ValidationResult(), parameters, parameterContext);
            if (!validationResult.isEmpty()) {
                throw new ReportParameterValidationException("The parameters provided for this report are not valid.", validationResult);
            }
            parameterValues = validationResult.getParameterValues();
        }
        finally {
            parameterContext.close();
        }
        this.reportInstancesShareConnection = "true".equals(processingContext.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.ReportInstancesShareConnections"));
        this.processLevels = new HashSet();
        this.groupStarts = new FastStack();
        this.errorHandler = IgnoreEverythingReportErrorHandler.INSTANCE;
        this.advanceHandler = BeginReportHandler.HANDLER;
        this.parentState = null;
        this.currentSubReport = -1;
        this.currentGroupIndex = -1;
        this.currentPresentationGroupIndex = -1;
        this.functionStorage = new FunctionStorage();
        this.structureFunctionStorage = new FunctionStorage();
        this.sequenceCounter = 0;
        this.processKey = new ReportStateKey(null, -1, 0, 0, -1, -1, this.sequenceCounter, false);
        this.dataFactoryManager = new DataFactoryManager();
        this.subReportStorage = new SubReportStorage();
        this.processHandle = new InternalProcessHandle(this.dataFactoryManager);
        this.structuralPreprocessingNeeded = this.isStructureRunNeeded(report);
        DataSchemaDefinition definition = report.getDataSchemaDefinition();
        DefaultFlowController flowController = new DefaultFlowController(processingContext, definition, StateUtilities.computeParameterValueSet(report, parameterValues), report.getParameterDefinition().getParameterDefinitions(), this.structuralPreprocessingNeeded);
        Object dataCacheEnabledRaw = report.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "data-cache");
        boolean dataCacheEnabled = !Boolean.FALSE.equals(dataCacheEnabledRaw);
        CachingDataFactory dataFactory = new CachingDataFactory(report.getDataFactory(), dataCacheEnabled);
        dataFactory.initialize(processingContext.getConfiguration(), processingContext.getResourceManager(), processingContext.getContentBase(), processingContext.getResourceBundleFactory());
        dataFactory.open();
        FunctionStorageKey functionStorageKey = FunctionStorageKey.createKey(null, report);
        this.dataFactoryManager.store(functionStorageKey, dataFactory, true);
        this.flowController = flowController;
        Integer queryLimitDefault = IntegerCache.getInteger(report.getQueryLimit());
        Integer queryTimeoutDefault = IntegerCache.getInteger(report.getQueryTimeout());
        Object queryRaw = this.evaluateExpression(report.getAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query"), report.getQuery());
        Object queryLimitRaw = this.evaluateExpression(report.getAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query-limit"), queryLimitDefault);
        Object queryTimeoutRaw = this.evaluateExpression(report.getAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query-timeout"), queryTimeoutDefault);
        this.query = (String)ConverterRegistry.convert(queryRaw, String.class, report.getQuery());
        this.queryLimit = (Integer)ConverterRegistry.convert(queryLimitRaw, Integer.class, queryLimitDefault);
        this.queryTimeout = (Integer)ConverterRegistry.convert(queryTimeoutRaw, Integer.class, queryTimeoutDefault);
        DefaultFlowController postQueryFlowController = flowController.performQuery(dataFactory, this.query, this.queryLimit, this.queryTimeout, processingContext.getResourceBundleFactory());
        ReportPreProcessor[] processors = this.getAllPreProcessors(report);
        MasterReport fullReport = report;
        DataSchemaDefinition fullDefinition = definition;
        for (int i = 0; i < processors.length; ++i) {
            ReportPreProcessor processor = processors[i];
            if ((fullReport = processor.performPreProcessing(fullReport, postQueryFlowController)).getDataSchemaDefinition() == fullDefinition) continue;
            fullDefinition = fullReport.getDataSchemaDefinition();
            postQueryFlowController = postQueryFlowController.updateDataSchema(fullDefinition);
        }
        this.flowController = postQueryFlowController.activateExpressions(fullReport.getExpressions().getExpressions(), false);
        this.report = new ReportDefinitionImpl(fullReport, fullReport.getPageDefinition());
        this.layoutProcess = new SubLayoutProcess(layoutProcess, this.computeStructureFunctions(fullReport.getStructureFunctions(), this.getFlowController().getReportContext().getOutputProcessorMetaData()));
        StateUtilities.computeLevels(this.flowController, this.layoutProcess, this.processLevels);
        this.processKey = this.createKey();
    }

    private boolean isReportsShareConnections(ReportDefinition report) {
        Object attribute = report.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "shared-connections");
        if (Boolean.TRUE.equals(attribute)) {
            return true;
        }
        if (Boolean.FALSE.equals(attribute)) {
            return false;
        }
        return this.reportInstancesShareConnection;
    }

    public void initializeForSubreport(InlineSubreportMarker[] subReports, int subReportIndex, ProcessState parentState) throws ReportProcessingException {
        boolean needPreProcessing;
        SubReport report;
        if (parentState == null) {
            throw new NullPointerException();
        }
        this.reportInstancesShareConnection = parentState.reportInstancesShareConnection;
        this.groupStarts = new FastStack();
        this.parentState = parentState;
        this.parentSubReportState = parentState;
        this.advanceHandler = BeginReportHandler.HANDLER;
        this.errorHandler = parentState.errorHandler;
        this.functionStorage = parentState.functionStorage;
        this.structureFunctionStorage = parentState.structureFunctionStorage;
        this.currentGroupIndex = -1;
        this.currentPresentationGroupIndex = -1;
        this.currentSubReport = subReportIndex;
        this.flowController = parentState.flowController;
        this.subReports = (InlineSubreportMarker[])subReports.clone();
        this.dataFactoryManager = parentState.dataFactoryManager;
        this.subReportStorage = parentState.subReportStorage;
        this.structuralPreprocessingNeeded = parentState.structuralPreprocessingNeeded;
        this.processLevels = parentState.processLevels;
        this.sequenceCounter = parentState.getSequenceCounter() + 1;
        this.currentSubReportMarker = subReports[subReportIndex];
        this.inlineProcess = parentState.isInlineProcess() || this.currentSubReportMarker.getProcessType() == SubReportProcessType.INLINE;
        SubReport subreportFromMarker = this.currentSubReportMarker.getSubreport();
        FunctionStorageKey functionStorageKey = FunctionStorageKey.createKey(this.parentSubReportState.getProcessKey(), subreportFromMarker);
        if (this.subReportStorage.contains(functionStorageKey)) {
            report = this.subReportStorage.restore(functionStorageKey);
            ElementStyleSheet subreportStyle = subreportFromMarker.getStyle();
            Map styleExpressions = subreportFromMarker.getStyleExpressions();
            StyleKey[] definedStyle = styleExpressions.keySet().toArray(new StyleKey[styleExpressions.size()]);
            for (int i = 0; i < definedStyle.length; ++i) {
                StyleKey styleKey = definedStyle[i];
                report.getStyle().setStyleProperty(styleKey, subreportStyle.getStyleProperty(styleKey));
            }
            needPreProcessing = false;
        } else {
            report = subreportFromMarker;
            needPreProcessing = true;
        }
        ResourceBundleFactory resourceBundleFactory = report.getResourceBundleFactory() != null ? MasterReport.computeAndInitResourceBundleFactory(report.getResourceBundleFactory(), parentState.getFlowController().getReportContext().getEnvironment()) : parentState.getResourceBundleFactory();
        int processingLevel = this.flowController.getReportContext().getProcessingLevel();
        if (processingLevel == -2 && !report.isVisible()) {
            ReportDefinition parentReport = parentState.getReport();
            SubReport dummyReport = new SubReport(functionStorageKey.getReportId());
            this.report = new ReportDefinitionImpl(dummyReport, parentReport.getPageDefinition());
            this.flowController = parentState.flowController.derive();
            this.advanceHandler = EndSubReportHandler.HANDLER;
            this.layoutProcess = new SubLayoutProcess(parentState.layoutProcess, this.computeStructureFunctions(report.getStructureFunctions(), this.flowController.getReportContext().getOutputProcessorMetaData()));
        } else {
            StructureFunction[] functions;
            CachingDataFactory dataFactory = this.dataFactoryManager.restore(functionStorageKey, this.isReportsShareConnections(report));
            if (dataFactory == null) {
                boolean dataCacheEnabled;
                DataFactory subreportDf = report.getDataFactory();
                Object dataCacheEnabledRaw = report.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "data-cache");
                boolean bl = dataCacheEnabled = !Boolean.FALSE.equals(dataCacheEnabledRaw);
                if (subreportDf == null) {
                    dataFactory = new CachingDataFactory(parentState.getFlowController().getDataFactory(), true, dataCacheEnabled);
                } else {
                    dataFactory = new CachingDataFactory(subreportDf, dataCacheEnabled);
                    ProcessingContext context = parentState.getFlowController().getReportContext();
                    dataFactory.initialize(context.getConfiguration(), context.getResourceManager(), context.getContentBase(), resourceBundleFactory);
                    dataFactory.open();
                    this.dataFactoryManager.store(functionStorageKey, dataFactory, this.isReportsShareConnections(report));
                }
            }
            ParameterMapping[] inputMappings = report.getInputMappings();
            ParameterMapping[] exportMappings = report.getExportMappings();
            this.flowController = parentState.flowController.performInitSubreport(dataFactory, inputMappings, resourceBundleFactory);
            Integer queryLimitDefault = IntegerCache.getInteger(report.getQueryLimit());
            Integer queryTimeoutDefault = IntegerCache.getInteger(report.getQueryTimeout());
            Object queryRaw = this.evaluateExpression(report.getAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query"), report.getQuery());
            Object queryLimitRaw = this.evaluateExpression(report.getAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query-limit"), queryLimitDefault);
            Object queryTimeoutRaw = this.evaluateExpression(report.getAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query-timeout"), queryTimeoutDefault);
            this.query = (String)ConverterRegistry.convert(queryRaw, String.class, report.getQuery());
            this.queryLimit = (Integer)ConverterRegistry.convert(queryLimitRaw, Integer.class, queryLimitDefault);
            this.queryTimeout = (Integer)ConverterRegistry.convert(queryTimeoutRaw, Integer.class, queryTimeoutDefault);
            DefaultFlowController postQueryFlowController = this.flowController.performSubReportQuery(this.query, this.queryLimit, this.queryTimeout, exportMappings);
            ProxyDataSchemaDefinition schemaDefinition = new ProxyDataSchemaDefinition(report.getDataSchemaDefinition(), postQueryFlowController.getMasterRow().getDataSchemaDefinition());
            postQueryFlowController = postQueryFlowController.updateDataSchema(schemaDefinition);
            SubReport fullReport = report;
            DataSchemaDefinition fullDefinition = schemaDefinition;
            if (needPreProcessing) {
                ReportPreProcessor[] processors = this.getAllPreProcessors(report);
                for (int i = 0; i < processors.length; ++i) {
                    ReportPreProcessor processor = processors[i];
                    if ((fullReport = processor.performPreProcessing(fullReport, postQueryFlowController)).getDataSchemaDefinition() == fullDefinition) continue;
                    fullDefinition = fullReport.getDataSchemaDefinition();
                    postQueryFlowController = postQueryFlowController.updateDataSchema(fullDefinition);
                }
                this.subReportStorage.store(functionStorageKey, fullReport);
            }
            this.report = new ReportDefinitionImpl(fullReport, fullReport.getPageDefinition());
            Expression[] structureFunctions = this.getStructureFunctionStorage().restore(functionStorageKey);
            if (structureFunctions != null) {
                functions = new StructureFunction[structureFunctions.length];
                System.arraycopy(structureFunctions, 0, functions, 0, structureFunctions.length);
                this.layoutProcess = new SubLayoutProcess(parentState.layoutProcess, functions);
            } else {
                functions = this.computeStructureFunctions(fullReport.getStructureFunctions(), postQueryFlowController.getReportContext().getOutputProcessorMetaData());
                this.layoutProcess = new SubLayoutProcess(parentState.layoutProcess, functions);
            }
            boolean preserve = true;
            Expression[] expressions = this.getFunctionStorage().restore(functionStorageKey);
            if (expressions == null) {
                expressions = fullReport.getExpressions().getExpressions();
                preserve = false;
            }
            this.flowController = postQueryFlowController.activateExpressions(expressions, preserve);
        }
        StateUtilities.computeLevels(this.flowController, this.layoutProcess, this.processLevels);
        this.processKey = this.createKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object evaluateExpression(Expression expression, Object defaultValue) {
        if (expression == null) {
            return defaultValue;
        }
        Expression evalExpression = expression.getInstance();
        InlineDataRowRuntime runtime = new InlineDataRowRuntime();
        runtime.setState(this);
        ExpressionRuntime oldRuntime = evalExpression.getRuntime();
        try {
            evalExpression.setRuntime(runtime);
            Object object = evalExpression.getValue();
            return object;
        }
        catch (Exception e) {
            logger.debug((Object)("Failed to evaluate expression " + expression));
            Object object = defaultValue;
            return object;
        }
        finally {
            evalExpression.setRuntime(oldRuntime);
        }
    }

    public int[] getRequiredRuntimeLevels() {
        this.processLevels.add(IntegerCache.getInteger(-2));
        int[] retval = new int[this.processLevels.size()];
        Integer[] levels = this.processLevels.toArray(new Integer[this.processLevels.size()]);
        Arrays.sort(levels, new StateUtilities.DescendingComparator());
        for (int i = 0; i < levels.length; ++i) {
            Integer level = levels[i];
            retval[i] = level;
        }
        return retval;
    }

    private StructureFunction[] computeStructureFunctions(StructureFunction[] fromReport, OutputProcessorMetaData metaData) {
        if (metaData.isFeatureSupported(OutputProcessorFeature.DESIGNTIME)) {
            return new StructureFunction[]{new CrosstabProcessorFunction()};
        }
        ArrayList<StructureFunction> e = new ArrayList<StructureFunction>(Arrays.asList(fromReport));
        if (this.structuralPreprocessingNeeded) {
            e.add(new CrosstabProcessorFunction());
        }
        e.add(new AttributeExpressionsEvaluator());
        e.add(new SheetNameFunction());
        e.add(new MetaDataStyleEvaluator());
        e.add(new StyleExpressionsEvaluator());
        e.add(new CellFormatFunction());
        e.add(new WizardItemHideFunction());
        Collections.sort(e, new StructureFunctionComparator());
        return e.toArray(new StructureFunction[e.size()]);
    }

    private ReportPreProcessor[] getAllPreProcessors(AbstractReportDefinition reportDefinition) {
        ReportPreProcessor[] processors = reportDefinition.getPreProcessors();
        Configuration configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
        ArrayList<Object> preProcessors = new ArrayList<Object>();
        for (int i = 0; i < processors.length; ++i) {
            ReportPreProcessor o = processors[i];
            if (o == null) continue;
            preProcessors.add(o);
        }
        Iterator keys = configuration.findPropertyKeys("org.pentaho.reporting.engine.classic.core.auto-report-preprocessors.");
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = configuration.getConfigProperty(key);
            Object o = ObjectUtilities.loadAndInstantiate((String)value, ProcessState.class, ReportPreProcessor.class);
            if (o == null) continue;
            preProcessors.add(o);
        }
        return preProcessors.toArray(new ReportPreProcessor[preProcessors.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubReportExecutable() {
        Expression expression = this.getReport().getAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/core", "subreport-active");
        if (expression != null) {
            InlineDataRowRuntime dataRowRuntime = new InlineDataRowRuntime();
            dataRowRuntime.setState(this);
            expression.setRuntime(dataRowRuntime);
            try {
                Object value = expression.getValue();
                if (Boolean.FALSE.equals(value)) {
                    boolean bl = false;
                    return bl;
                }
                if ("false".equals(String.valueOf(value))) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                expression.setRuntime(null);
            }
        }
        return true;
    }

    public ProcessState returnFromSubReport(LayoutProcess layoutProcess) throws ReportProcessingException {
        ProcessState state = this.deriveForAdvance();
        try {
            state.layoutProcess = (LayoutProcess)layoutProcess.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ReportProcessingException("Clone must not fail here", e);
        }
        return state;
    }

    public ProcessState restart() throws ReportProcessingException {
        ProcessState state = this.deriveForStorage();
        state.currentSubReport = -1;
        state.currentGroupIndex = -1;
        state.currentPresentationGroupIndex = -1;
        if (!state.groupStarts.isEmpty()) {
            throw new IllegalStateException();
        }
        state.setAdvanceHandler(BeginReportHandler.HANDLER);
        ReportState parentState = this.getParentSubReportState();
        ReportStateKey parentStateKey = parentState == null ? null : parentState.getProcessKey();
        CachingDataFactory dataFactory = state.dataFactoryManager.restore(FunctionStorageKey.createKey(parentStateKey, state.getReport()), this.isReportsShareConnections(this.report));
        if (dataFactory == null) {
            throw new ReportProcessingException("No data factory on restart()? Somewhere we went wrong.");
        }
        DefaultFlowController fc = state.getFlowController();
        DefaultFlowController cfc = fc.restart();
        DefaultFlowController qfc = cfc.performQuery(dataFactory, this.query, this.queryLimit, this.queryTimeout, fc.getMasterRow().getResourceBundleFactory());
        Expression[] expressions = this.getFunctionStorage().restore(FunctionStorageKey.createKey(null, state.getReport()));
        DefaultFlowController efc = qfc.activateExpressions(expressions, true);
        state.setFlowController(efc);
        ++state.sequenceCounter;
        state.processKey = this.createKey();
        return state;
    }

    public ReportProcessingErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ReportProcessingErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setSequenceCounter(int sequenceCounter) {
        this.sequenceCounter = sequenceCounter;
        this.processKey = this.createKey();
    }

    public int getSequenceCounter() {
        return this.sequenceCounter;
    }

    public InlineSubreportMarker getCurrentSubReportMarker() {
        return this.currentSubReportMarker;
    }

    public boolean isInlineProcess() {
        return this.inlineProcess;
    }

    public SubReportProcessType getSubreportProcessingType() {
        if (this.inlineProcess) {
            return SubReportProcessType.INLINE;
        }
        return SubReportProcessType.BANDED;
    }

    public ProcessState deriveForPagebreak() {
        try {
            ProcessState processState = (ProcessState)this.clone();
            ++processState.sequenceCounter;
            processState.flowController = this.flowController.derive();
            processState.report = (ReportDefinitionImpl)this.report.clone();
            processState.layoutProcess = this.layoutProcess.deriveForPagebreak();
            processState.processKey = processState.createKey();
            return processState;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone failed but I dont know why ..");
        }
    }

    public ProcessState deriveForAdvance() {
        try {
            ProcessState processState = (ProcessState)this.clone();
            ++processState.sequenceCounter;
            processState.processKey = processState.createKey();
            return processState;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone failed but I dont know why ..");
        }
    }

    public ProcessState deriveForStorage() {
        try {
            ProcessState result = (ProcessState)this.clone();
            result.flowController = this.flowController.derive();
            result.report = (ReportDefinitionImpl)this.report.clone();
            result.layoutProcess = this.layoutProcess.deriveForStorage();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone failed but I dont know why ..");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ProcessState result = (ProcessState)super.clone();
        result.groupStarts = (FastStack)this.groupStarts.clone();
        result.processKey = this.createKey();
        return result;
    }

    public AdvanceHandler getAdvanceHandler() {
        return this.advanceHandler;
    }

    private ReportStateKey createKey() {
        if (this.parentState != null) {
            return new ReportStateKey(this.parentState.createKey(), this.getCurrentDataItem(), this.getCurrentCrosstabPaddingItem(), this.getEventCode(), this.getCurrentGroupIndex(), this.getCurrentSubReport(), this.sequenceCounter, this.advanceHandler.isRestoreHandler());
        }
        return new ReportStateKey(null, this.getCurrentDataItem(), this.getCurrentCrosstabPaddingItem(), this.getEventCode(), this.getCurrentGroupIndex(), this.getCurrentSubReport(), this.sequenceCounter, this.advanceHandler.isRestoreHandler());
    }

    public void setAdvanceHandler(AdvanceHandler advanceHandler) {
        if (advanceHandler == null) {
            throw new NullPointerException();
        }
        this.advanceHandler = advanceHandler;
        this.processKey = null;
    }

    public final ProcessState advance() throws ReportProcessingException {
        return this.advanceHandler.advance(this);
    }

    public final ProcessState commit() throws ReportProcessingException {
        return this.advanceHandler.commit(this);
    }

    public int getCurrentDataItem() {
        return this.flowController.getCursor();
    }

    public int getCurrentCrosstabPaddingItem() {
        return this.flowController.getCurrentCrosstabPaddingItem();
    }

    public int getProgressLevel() {
        return this.flowController.getReportContext().getProgressLevel();
    }

    public int getProgressLevelCount() {
        return this.flowController.getReportContext().getProgressLevelCount();
    }

    public boolean isPrepareRun() {
        return this.flowController.getReportContext().isPrepareRun();
    }

    public int getLevel() {
        return this.flowController.getReportContext().getProcessingLevel();
    }

    public boolean isFinish() {
        return this.advanceHandler.isFinish();
    }

    public int getEventCode() {
        return this.advanceHandler.getEventCode();
    }

    public int getCurrentGroupIndex() {
        return this.currentGroupIndex;
    }

    public void enterGroup() {
        ++this.currentGroupIndex;
        Group group = this.report.getGroup(this.currentGroupIndex);
        this.groupStarts.push((Object)new GroupStartRecord(this.getCurrentDataItem(), group.getName()));
        if (this.groupStarts.size() != this.currentGroupIndex + 1) {
            throw new IllegalStateException();
        }
    }

    public void leaveGroup() {
        if (this.groupStarts.size() != this.currentGroupIndex + 1) {
            throw new IllegalStateException();
        }
        --this.currentGroupIndex;
        this.groupStarts.pop();
    }

    public int getPresentationGroupIndex() {
        return this.currentPresentationGroupIndex;
    }

    public void enterPresentationGroup() {
        ++this.currentPresentationGroupIndex;
    }

    public void leavePresentationGroup() {
        --this.currentPresentationGroupIndex;
    }

    public ReportDefinition getReport() {
        return this.report;
    }

    public int getCurrentSubReport() {
        return this.currentSubReport;
    }

    public void setCurrentSubReport(int currentSubReport) {
        this.currentSubReport = currentSubReport;
    }

    public ReportState getParentState() {
        return this.parentState;
    }

    public ReportState getParentSubReportState() {
        return this.parentSubReportState;
    }

    public FunctionStorage getStructureFunctionStorage() {
        return this.structureFunctionStorage;
    }

    public FunctionStorage getFunctionStorage() {
        return this.functionStorage;
    }

    public DefaultFlowController getFlowController() {
        return this.flowController;
    }

    public void setFlowController(DefaultFlowController flowController) {
        if (flowController == null) {
            throw new NullPointerException();
        }
        this.flowController = flowController;
        this.processKey = null;
    }

    public LayoutProcess getLayoutProcess() {
        return this.layoutProcess;
    }

    public ReportStateKey getProcessKey() {
        if (this.processKey == null) {
            this.processKey = this.createKey();
        }
        return this.processKey;
    }

    public DataRow getDataRow() {
        return this.flowController.getMasterRow().getGlobalView();
    }

    public int getNumberOfRows() {
        MasterDataRow masterRow = this.flowController.getMasterRow();
        ReportDataRow reportDataRow = masterRow.getReportDataRow();
        if (reportDataRow != null) {
            return reportDataRow.getReportData().getRowCount();
        }
        return 0;
    }

    public void firePageStartedEvent(int baseEvent) {
        ReportEvent event = new ReportEvent(this, 2 | baseEvent);
        this.flowController = this.flowController.fireReportEvent(event);
        this.layoutProcess.fireReportEvent(event);
    }

    public void firePageFinishedEvent(boolean noParentPassing) {
        int eventCode = 0x400 | (noParentPassing ? 0x8000000 : 0);
        ReportEvent event = new ReportEvent(this, eventCode);
        this.flowController = this.flowController.fireReportEvent(event);
        this.layoutProcess.fireReportEvent(event);
    }

    protected void fireReportEvent() {
        if ((this.advanceHandler.getEventCode() & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            throw new IllegalStateException("Cannot fire artificial events.");
        }
        ReportEvent event = new ReportEvent(this, this.advanceHandler.getEventCode());
        this.flowController = this.flowController.fireReportEvent(event);
        this.layoutProcess.fireReportEvent(event);
    }

    public static boolean isLastItemInGroup(Group rootGroup, MasterDataRow currentDataRow, MasterDataRow nextDataRow) {
        if (!currentDataRow.isAdvanceable() || nextDataRow == null) {
            return true;
        }
        DataRow nextView = nextDataRow.getGlobalView();
        Group g = rootGroup;
        while (g != null) {
            if (g.isGroupChange(nextView)) {
                return true;
            }
            Section parentSection = g.getParentSection();
            if (parentSection == null) {
                return false;
            }
            Section maybeGroup = parentSection.getParentSection();
            if (maybeGroup instanceof Group) {
                g = (Group)maybeGroup;
                continue;
            }
            g = null;
        }
        return false;
    }

    public boolean isSubReportEvent() {
        return this.getParentSubReportState() != null;
    }

    public InlineSubreportMarker[] getSubReports() {
        return (InlineSubreportMarker[])this.subReports.clone();
    }

    public ProcessStateHandle getProcessHandle() {
        return this.processHandle;
    }

    public void setInItemGroup(boolean inItemGroup) {
        this.inItemGroup = inItemGroup;
    }

    public boolean isInItemGroup() {
        return this.inItemGroup;
    }

    public ResourceBundleFactory getResourceBundleFactory() {
        return this.flowController.getMasterRow().getResourceBundleFactory();
    }

    public boolean isArtifcialState() {
        return (this.advanceHandler.getEventCode() & Integer.MIN_VALUE) != 0;
    }

    public GroupingState createGroupingState() {
        return new DefaultGroupingState(this.currentGroupIndex, (FastStack)this.groupStarts.clone());
    }

    private boolean isStructureRunNeeded(Section section) {
        int count = section.getElementCount();
        for (int i = 0; i < count; ++i) {
            ReportElement element = section.getElement(i);
            Object type = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "element-type");
            if (type instanceof ExternalElementType) {
                return true;
            }
            if (element instanceof CrosstabGroup) {
                return true;
            }
            if (element instanceof SubReport) {
                return true;
            }
            if (element instanceof RootLevelBand) {
                RootLevelBand band = (RootLevelBand)element;
                if (band.getSubReportCount() > 0) {
                    return true;
                }
                if (!this.isStructureRunNeeded((Section)element)) continue;
                return true;
            }
            if (!(element instanceof Section) || !this.isStructureRunNeeded((Section)element)) continue;
            return true;
        }
        return false;
    }

    public boolean isStructuralPreprocessingNeeded() {
        return this.structuralPreprocessingNeeded;
    }

    private static class InternalProcessHandle
    implements ProcessStateHandle {
        private DataFactoryManager manager;

        private InternalProcessHandle(DataFactoryManager manager) {
            this.manager = manager;
        }

        public void close() {
            this.manager.close();
        }
    }
}

