/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.process;

import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.ReportHeader;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.states.process.AdvanceHandler;
import org.pentaho.reporting.engine.classic.core.states.process.BeginCrosstabHandler;
import org.pentaho.reporting.engine.classic.core.states.process.BeginGroupHandler;
import org.pentaho.reporting.engine.classic.core.states.process.InlineSubreportProcessor;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessState;

public class ReportHeaderHandler
implements AdvanceHandler {
    public static final AdvanceHandler HANDLER = new ReportHeaderHandler();

    private ReportHeaderHandler() {
    }

    public int getEventCode() {
        return 4;
    }

    public ProcessState advance(ProcessState state) throws ReportProcessingException {
        ProcessState next = state.deriveForAdvance();
        next.fireReportEvent();
        return InlineSubreportProcessor.processInline(next, next.getReport().getReportHeader());
    }

    public ProcessState commit(ProcessState next) throws ReportProcessingException {
        Group rootGroup = next.getReport().getGroup(0);
        if (rootGroup instanceof CrosstabGroup) {
            next.setAdvanceHandler(BeginCrosstabHandler.HANDLER);
        } else {
            next.setAdvanceHandler(BeginGroupHandler.HANDLER);
        }
        ReportHeader rootLevelBand = next.getReport().getReportHeader();
        return InlineSubreportProcessor.process(next, rootLevelBand);
    }

    public boolean isFinish() {
        return false;
    }

    public boolean isRestoreHandler() {
        return false;
    }
}

