/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.process;

import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.states.process.AdvanceHandler;
import org.pentaho.reporting.engine.classic.core.states.process.PendingPagesHandler;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessState;
import org.pentaho.reporting.engine.classic.core.states.process.ReportDoneHandler;

public class RestartOnNewPageHandler
implements AdvanceHandler {
    private AdvanceHandler handler;

    public RestartOnNewPageHandler(AdvanceHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handler = handler;
    }

    public ProcessState advance(ProcessState state) throws ReportProcessingException {
        ProcessState newState = state.deriveForAdvance();
        newState.getFlowController().getMasterRow().refresh();
        newState.getLayoutProcess().restart(newState);
        return newState;
    }

    public ProcessState commit(ProcessState state) throws ReportProcessingException {
        state.setAdvanceHandler(this.handler);
        return state;
    }

    public boolean isFinish() {
        return this.handler.isFinish();
    }

    public int getEventCode() {
        return this.handler.getEventCode();
    }

    public static ProcessState create(ProcessState state) throws ReportProcessingException {
        if (state.isArtifcialState()) {
            return state;
        }
        if (state.getAdvanceHandler() instanceof PendingPagesHandler) {
            return state.deriveForAdvance();
        }
        if (state.getAdvanceHandler() instanceof RestartOnNewPageHandler) {
            return state.deriveForAdvance();
        }
        if (state.getAdvanceHandler() instanceof ReportDoneHandler) {
            return state;
        }
        ProcessState newstate = state.deriveForAdvance();
        newstate.setAdvanceHandler(new RestartOnNewPageHandler(newstate.getAdvanceHandler()));
        return newstate;
    }

    public boolean isRestoreHandler() {
        return true;
    }
}

