/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.style;

import org.pentaho.reporting.engine.classic.core.style.FontDefinition;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public abstract class AbstractStyleSheet
implements StyleSheet {
    private InstanceID id = new InstanceID();

    protected AbstractStyleSheet() {
    }

    public Object getStyleProperty(StyleKey key) {
        return this.getStyleProperty(key, null);
    }

    public boolean getBooleanStyleProperty(StyleKey key) {
        Boolean b = (Boolean)this.getStyleProperty(key, null);
        if (b == null) {
            return false;
        }
        return b;
    }

    public boolean getBooleanStyleProperty(StyleKey key, boolean defaultValue) {
        Boolean b = (Boolean)this.getStyleProperty(key, null);
        if (b == null) {
            return defaultValue;
        }
        return b;
    }

    public int getIntStyleProperty(StyleKey key, int def) {
        Number i = (Number)this.getStyleProperty(key, null);
        if (i == null) {
            return def;
        }
        return i.intValue();
    }

    public double getDoubleStyleProperty(StyleKey key, double def) {
        Number i = (Number)this.getStyleProperty(key, null);
        if (i == null) {
            return def;
        }
        return i.doubleValue();
    }

    public FontDefinition getFontDefinitionProperty() {
        String name = (String)this.getStyleProperty(TextStyleKeys.FONT);
        int size = this.getIntStyleProperty(TextStyleKeys.FONTSIZE, -1);
        boolean bold = this.getBooleanStyleProperty(TextStyleKeys.BOLD);
        boolean italic = this.getBooleanStyleProperty(TextStyleKeys.ITALIC);
        boolean underlined = this.getBooleanStyleProperty(TextStyleKeys.UNDERLINED);
        boolean strike = this.getBooleanStyleProperty(TextStyleKeys.STRIKETHROUGH);
        boolean embed = this.getBooleanStyleProperty(TextStyleKeys.EMBEDDED_FONT);
        String encoding = (String)this.getStyleProperty(TextStyleKeys.FONTENCODING);
        return new FontDefinition(name, size, bold, italic, underlined, strike, encoding, embed);
    }

    public InstanceID getId() {
        return this.id;
    }

    public long getChangeTracker() {
        return 0L;
    }

    public StyleSheet derive() throws CloneNotSupportedException {
        AbstractStyleSheet s = (AbstractStyleSheet)super.clone();
        s.id = new InstanceID();
        return s;
    }
}

