/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.style;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.pentaho.reporting.engine.classic.core.style.AbstractStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.ElementDefaultStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.FontDefinition;
import org.pentaho.reporting.engine.classic.core.style.StyleChangeListener;
import org.pentaho.reporting.engine.classic.core.style.StyleChangeSupport;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleSheetCarrier;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.libraries.base.util.FloatDimension;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.serializer.SerializerHelper;

public abstract class ElementStyleSheet
extends AbstractStyleSheet
implements Serializable,
StyleChangeListener,
Cloneable {
    public static final StyleKey MINIMUMSIZE = ElementStyleKeys.MINIMUMSIZE;
    public static final StyleKey MAXIMUMSIZE = ElementStyleKeys.MAXIMUMSIZE;
    public static final StyleKey PREFERREDSIZE = ElementStyleKeys.PREFERREDSIZE;
    public static final StyleKey VISIBLE = ElementStyleKeys.VISIBLE;
    public static final StyleKey PAINT = ElementStyleKeys.PAINT;
    public static final StyleKey STROKE = ElementStyleKeys.STROKE;
    public static final StyleKey ALIGNMENT = ElementStyleKeys.ALIGNMENT;
    public static final StyleKey VALIGNMENT = ElementStyleKeys.VALIGNMENT;
    public static final StyleKey SCALE = ElementStyleKeys.SCALE;
    public static final StyleKey KEEP_ASPECT_RATIO = ElementStyleKeys.KEEP_ASPECT_RATIO;
    public static final StyleKey DYNAMIC_HEIGHT = ElementStyleKeys.DYNAMIC_HEIGHT;
    public static final StyleKey HREF_TARGET = ElementStyleKeys.HREF_TARGET;
    public static final StyleKey HREF_WINDOW = ElementStyleKeys.HREF_WINDOW;
    public static final StyleKey EXCEL_WRAP_TEXT = ElementStyleKeys.EXCEL_WRAP_TEXT;
    public static final StyleKey EXCEL_DATA_FORMAT_STRING = ElementStyleKeys.EXCEL_DATA_FORMAT_STRING;
    public static final StyleKey FONT = TextStyleKeys.FONT;
    public static final StyleKey FONTSIZE = TextStyleKeys.FONTSIZE;
    public static final StyleKey LINEHEIGHT = TextStyleKeys.LINEHEIGHT;
    public static final StyleKey BOLD = TextStyleKeys.BOLD;
    public static final StyleKey ITALIC = TextStyleKeys.ITALIC;
    public static final StyleKey UNDERLINED = TextStyleKeys.UNDERLINED;
    public static final StyleKey STRIKETHROUGH = TextStyleKeys.STRIKETHROUGH;
    public static final StyleKey EMBEDDED_FONT = TextStyleKeys.EMBEDDED_FONT;
    public static final StyleKey FONTENCODING = TextStyleKeys.FONTENCODING;
    public static final StyleKey RESERVED_LITERAL = TextStyleKeys.RESERVED_LITERAL;
    public static final StyleKey TRIM_TEXT_CONTENT = TextStyleKeys.TRIM_TEXT_CONTENT;
    private static final Object UNDEFINED_VALUE = new Object();
    private String name;
    private ArrayList<StyleSheetCarrier> parents;
    private ElementDefaultStyleSheet globalDefaultStyleSheet;
    private ElementStyleSheet cascadeStyleSheet;
    private transient StyleSheetCarrier[] parentsCached;
    private StyleKey[] propertyKeys;
    private transient Object[] properties;
    private byte[] source;
    private static final byte SOURCE_UNDEFINED = 0;
    private static final byte SOURCE_FROM_PARENT = 1;
    private static final byte SOURCE_DIRECT = 2;
    private transient StyleChangeSupport styleChangeSupport;
    private long changeTracker;
    private static final StyleKey[] EMPTY_KEYS = new StyleKey[0];
    private static final StyleSheetCarrier[] EMPTY_PARENTS = new StyleSheetCarrier[0];

    protected ElementStyleSheet(String name) {
        if (name == null) {
            throw new NullPointerException("ElementStyleSheet constructor: name is null.");
        }
        this.name = name;
        this.styleChangeSupport = new StyleChangeSupport(this);
        this.propertyKeys = StyleKey.getDefinedStyleKeys();
        if (this.propertyKeys[0] == null) {
            throw new IllegalStateException();
        }
    }

    protected ElementStyleSheet(String name, ElementStyleSheet deriveParent) {
        if (name == null) {
            throw new NullPointerException("ElementStyleSheet constructor: name is null.");
        }
        if (deriveParent == null) {
            throw new NullPointerException("ElementStyleSheet constructor: parent cannot be null.");
        }
        this.name = name;
        this.styleChangeSupport = new StyleChangeSupport(this);
        this.propertyKeys = deriveParent.propertyKeys;
        if (this.propertyKeys[0] == null) {
            throw new IllegalStateException();
        }
        this.properties = new Object[this.propertyKeys.length];
        this.source = new byte[this.propertyKeys.length];
        this.changeTracker = deriveParent.changeTracker;
    }

    public final boolean isAllowCaching() {
        return true;
    }

    public long getChangeTracker() {
        return this.changeTracker;
    }

    public boolean isLocalKey(StyleKey key) {
        if (this.source == null) {
            return false;
        }
        int identifier = key.identifier;
        if (this.source.length <= identifier) {
            return false;
        }
        return this.source[identifier] == 2;
    }

    public void setAllowCaching(boolean allowCaching) {
    }

    public String getName() {
        return this.name;
    }

    public void addParent(ElementStyleSheet parent) {
        this.addParent(0, parent);
    }

    public void addParent(int position, ElementStyleSheet parent) {
        if (parent == null) {
            throw new NullPointerException("ElementStyleSheet.addParent(...): parent is null.");
        }
        if (!parent.isSubStyleSheet(this)) {
            StyleSheetCarrier carrier = this.createCarrier(parent);
            if (carrier == null) {
                throw new IllegalArgumentException("The given StyleSheet cannot be added to this stylesheet.");
            }
            if (this.parents == null) {
                this.parents = new ArrayList();
            }
            this.parents.add(position, carrier);
            this.parentsCached = null;
            ++this.changeTracker;
        } else {
            throw new IllegalArgumentException("Cannot add parent as child.");
        }
    }

    protected abstract StyleSheetCarrier createCarrier(ElementStyleSheet var1);

    protected boolean isSubStyleSheet(ElementStyleSheet parent) {
        if (this.parents == null) {
            return false;
        }
        int size = this.parents.size();
        for (int i = 0; i < size; ++i) {
            StyleSheetCarrier ca = this.parents.get(i);
            ElementStyleSheet es = ca.getStyleSheet();
            if (es == parent) {
                return true;
            }
            if (!es.isSubStyleSheet(parent)) continue;
            return true;
        }
        return false;
    }

    public void removeParent(ElementStyleSheet parent) {
        if (parent == null) {
            throw new NullPointerException("ElementStyleSheet.removeParent(...): parent is null.");
        }
        if (this.parents == null) {
            return;
        }
        Iterator<StyleSheetCarrier> it = this.parents.iterator();
        while (it.hasNext()) {
            StyleSheetCarrier carrier = it.next();
            if (!carrier.isSame(parent)) continue;
            it.remove();
            carrier.invalidate();
            this.parentsCached = null;
            ++this.changeTracker;
        }
    }

    public ElementStyleSheet[] getParents() {
        if (this.parentsCached == null) {
            this.parentsToCache();
        }
        ElementStyleSheet[] styleSheets = new ElementStyleSheet[this.parentsCached.length];
        for (int i = 0; i < styleSheets.length; ++i) {
            styleSheets[i] = this.parentsCached[i].getStyleSheet();
        }
        return styleSheets;
    }

    public ElementDefaultStyleSheet getGlobalDefaultStyleSheet() {
        return this.globalDefaultStyleSheet;
    }

    public void setGlobalDefaultStyleSheet(ElementDefaultStyleSheet defaultStyleSheet) {
        if (this.globalDefaultStyleSheet == defaultStyleSheet) {
            return;
        }
        this.globalDefaultStyleSheet = defaultStyleSheet;
        this.pruneCachedEntries();
    }

    public ElementStyleSheet getCascadeStyleSheet() {
        return this.cascadeStyleSheet;
    }

    public void setCascadeStyleSheet(ElementStyleSheet cascadeStyleSheet) {
        if (this.cascadeStyleSheet == cascadeStyleSheet) {
            return;
        }
        if (this.cascadeStyleSheet != null) {
            this.cascadeStyleSheet.removeListener(this);
        }
        this.cascadeStyleSheet = cascadeStyleSheet;
        this.pruneCachedEntries();
        if (this.cascadeStyleSheet != null) {
            this.cascadeStyleSheet.addListener(this);
        }
    }

    private void pruneCachedEntries() {
        if (this.source != null && this.properties != null) {
            for (int i = 0; i < this.source.length; ++i) {
                if (this.source[i] != 1) continue;
                this.source[i] = 0;
                this.properties[i] = null;
            }
        }
    }

    public final Object[] toArray() {
        StyleKey[] keys = this.propertyKeys;
        Object[] data = new Object[keys.length];
        if (this.source == null) {
            this.source = new byte[keys.length];
            this.properties = new Object[keys.length];
        }
        for (int i = 0; i < keys.length; ++i) {
            StyleKey key = keys[i];
            if (key == null) {
                throw new NullPointerException();
            }
            int identifier = key.identifier;
            byte sourceHint = this.source[identifier];
            data[identifier] = sourceHint == 0 ? this.getStyleProperty(key) : this.properties[identifier];
        }
        return data;
    }

    public Object getStyleProperty(StyleKey key, Object defaultValue) {
        Object value;
        Object legacyVal = this.handleGetLegacyKeys(key);
        if (legacyVal == UNDEFINED_VALUE) {
            return defaultValue;
        }
        if (legacyVal != null) {
            return legacyVal;
        }
        int identifier = key.identifier;
        if (this.properties != null) {
            if (this.properties.length <= identifier) {
                throw new IllegalStateException();
            }
            byte source = this.source[identifier];
            if (source != 0) {
                Object value2 = this.properties[identifier];
                if (value2 == null) {
                    return defaultValue;
                }
                return value2;
            }
        }
        this.parentsToCache();
        for (int i = 0; i < this.parentsCached.length; ++i) {
            ElementStyleSheet st = this.parentsCached[i].getStyleSheet();
            Object value3 = st.getStyleProperty(key, null);
            if (value3 == null) continue;
            this.putInCache(key, value3, (byte)1);
            return value3;
        }
        if (key.isInheritable() && this.cascadeStyleSheet != null && (value = this.cascadeStyleSheet.getStyleProperty(key, null)) != null) {
            this.putInCache(key, value, (byte)1);
            return value;
        }
        if (this.globalDefaultStyleSheet != null && (value = this.globalDefaultStyleSheet.getStyleProperty(key, null)) != null) {
            this.putInCache(key, value, (byte)1);
            return value;
        }
        this.putInCache(key, null, (byte)1);
        return defaultValue;
    }

    private void putInCache(StyleKey key, Object value, byte sourceHint) {
        if (this.properties == null) {
            int definedStyleKeyCount = this.propertyKeys.length;
            this.properties = new Object[definedStyleKeyCount];
            this.source = new byte[definedStyleKeyCount];
        }
        int identifier = key.identifier;
        this.properties[identifier] = value;
        this.source[identifier] = sourceHint;
    }

    public void setBooleanStyleProperty(StyleKey key, boolean value) {
        if (value) {
            this.setStyleProperty(key, Boolean.TRUE);
        } else {
            this.setStyleProperty(key, Boolean.FALSE);
        }
    }

    public void setStyleProperty(StyleKey key, Object value) {
        if (key == null) {
            throw new NullPointerException("ElementStyleSheet.setStyleProperty: key is null.");
        }
        if (this.handleSetLegacyKeys(key, value)) {
            return;
        }
        int identifier = key.identifier;
        if (value == null) {
            if (this.properties != null) {
                if (this.properties[identifier] == null) {
                    return;
                }
                this.putInCache(key, null, (byte)0);
                ++this.changeTracker;
                this.properties[identifier] = null;
                this.styleChangeSupport.fireStyleRemoved(key);
            }
            return;
        }
        if (!key.getValueType().isAssignableFrom(value.getClass())) {
            throw new ClassCastException("Value for key " + key.getName() + " is not assignable: " + value.getClass() + " is not assignable from " + key.getValueType());
        }
        if (this.properties == null) {
            int definedStyleKeyCount = this.propertyKeys.length;
            this.properties = new Object[definedStyleKeyCount];
            this.source = new byte[definedStyleKeyCount];
        }
        if (ObjectUtilities.equal((Object)this.properties[identifier], (Object)value)) {
            return;
        }
        this.putInCache(key, value, (byte)2);
        ++this.changeTracker;
        this.styleChangeSupport.fireStyleChanged(key, value);
    }

    private boolean handleSetLegacyKeys(StyleKey key, Object value) {
        if (value == null) {
            return false;
        }
        if (key == ElementStyleKeys.ABSOLUTE_POS) {
            Point2D point = (Point2D)value;
            this.setStyleProperty(ElementStyleKeys.POS_X, new Float(point.getX()));
            this.setStyleProperty(ElementStyleKeys.POS_Y, new Float(point.getY()));
            return true;
        }
        if (key == ElementStyleKeys.MINIMUMSIZE) {
            Dimension2D dim = (Dimension2D)value;
            this.setStyleProperty(ElementStyleKeys.MIN_WIDTH, new Float(dim.getWidth()));
            this.setStyleProperty(ElementStyleKeys.MIN_HEIGHT, new Float(dim.getHeight()));
            return true;
        }
        if (key == ElementStyleKeys.MAXIMUMSIZE) {
            Dimension2D dim = (Dimension2D)value;
            this.setStyleProperty(ElementStyleKeys.MAX_WIDTH, new Float(dim.getWidth()));
            this.setStyleProperty(ElementStyleKeys.MAX_HEIGHT, new Float(dim.getHeight()));
            return true;
        }
        if (key == ElementStyleKeys.PREFERREDSIZE) {
            Dimension2D dim = (Dimension2D)value;
            this.setStyleProperty(ElementStyleKeys.WIDTH, new Float(dim.getWidth()));
            this.setStyleProperty(ElementStyleKeys.HEIGHT, new Float(dim.getHeight()));
            return true;
        }
        if (key == ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS) {
            Dimension2D dim = (Dimension2D)value;
            this.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_WIDTH, new Float(dim.getWidth()));
            this.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_HEIGHT, new Float(dim.getHeight()));
            return true;
        }
        if (key == ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS) {
            Dimension2D dim = (Dimension2D)value;
            this.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_WIDTH, new Float(dim.getWidth()));
            this.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_HEIGHT, new Float(dim.getHeight()));
            return true;
        }
        if (key == ElementStyleKeys.BORDER_TOP_LEFT_RADIUS) {
            Dimension2D dim = (Dimension2D)value;
            this.setStyleProperty(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_WIDTH, new Float(dim.getWidth()));
            this.setStyleProperty(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_HEIGHT, new Float(dim.getHeight()));
            return true;
        }
        if (key == ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS) {
            Dimension2D dim = (Dimension2D)value;
            this.setStyleProperty(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_WIDTH, new Float(dim.getWidth()));
            this.setStyleProperty(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_HEIGHT, new Float(dim.getHeight()));
            return true;
        }
        return false;
    }

    private Object handleGetLegacyKeys(StyleKey key) {
        if (key == ElementStyleKeys.ABSOLUTE_POS) {
            Float x = (Float)this.getStyleProperty(ElementStyleKeys.POS_X);
            Float y = (Float)this.getStyleProperty(ElementStyleKeys.POS_Y);
            if (x == null || y == null) {
                return UNDEFINED_VALUE;
            }
            return new Point2D.Double(x.doubleValue(), y.doubleValue());
        }
        if (key == ElementStyleKeys.MINIMUMSIZE) {
            Float w = (Float)this.getStyleProperty(ElementStyleKeys.MIN_WIDTH);
            Float h = (Float)this.getStyleProperty(ElementStyleKeys.MIN_HEIGHT);
            if (w == null || h == null) {
                return UNDEFINED_VALUE;
            }
            return new FloatDimension(w.floatValue(), h.floatValue());
        }
        if (key == ElementStyleKeys.MAXIMUMSIZE) {
            Float w = (Float)this.getStyleProperty(ElementStyleKeys.MAX_WIDTH);
            Float h = (Float)this.getStyleProperty(ElementStyleKeys.MAX_HEIGHT);
            if (w == null || h == null) {
                return UNDEFINED_VALUE;
            }
            return new FloatDimension(w.floatValue(), h.floatValue());
        }
        if (key == ElementStyleKeys.PREFERREDSIZE) {
            Float w = (Float)this.getStyleProperty(ElementStyleKeys.WIDTH);
            Float h = (Float)this.getStyleProperty(ElementStyleKeys.HEIGHT);
            if (w == null || h == null) {
                return UNDEFINED_VALUE;
            }
            return new FloatDimension(w.floatValue(), h.floatValue());
        }
        if (key == ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS) {
            Float w = (Float)this.getStyleProperty(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_WIDTH);
            Float h = (Float)this.getStyleProperty(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_HEIGHT);
            if (w == null || h == null) {
                return UNDEFINED_VALUE;
            }
            return new FloatDimension(w.floatValue(), h.floatValue());
        }
        if (key == ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS) {
            Float w = (Float)this.getStyleProperty(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_WIDTH);
            Float h = (Float)this.getStyleProperty(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_HEIGHT);
            if (w == null || h == null) {
                return UNDEFINED_VALUE;
            }
            return new FloatDimension(w.floatValue(), h.floatValue());
        }
        if (key == ElementStyleKeys.BORDER_TOP_LEFT_RADIUS) {
            Float w = (Float)this.getStyleProperty(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_WIDTH);
            Float h = (Float)this.getStyleProperty(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_HEIGHT);
            if (w == null || h == null) {
                return UNDEFINED_VALUE;
            }
            return new FloatDimension(w.floatValue(), h.floatValue());
        }
        if (key == ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS) {
            Float w = (Float)this.getStyleProperty(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_WIDTH);
            Float h = (Float)this.getStyleProperty(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_HEIGHT);
            if (w == null || h == null) {
                return UNDEFINED_VALUE;
            }
            return new FloatDimension(w.floatValue(), h.floatValue());
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            ElementStyleSheet sc = (ElementStyleSheet)super.clone();
            if (this.properties != null) {
                sc.properties = (Object[])this.properties.clone();
            }
            if (this.source != null) {
                sc.source = (byte[])this.source.clone();
            }
            sc.styleChangeSupport = new StyleChangeSupport(sc);
            if (sc.parents != null) {
                this.parentsToCache();
                sc.parents = (ArrayList)this.parents.clone();
                sc.parents.clear();
                sc.parentsCached = new StyleSheetCarrier[this.parentsCached.length];
                for (int i = 0; i < this.parentsCached.length; ++i) {
                    StyleSheetCarrier carrier;
                    sc.parentsCached[i] = carrier = (StyleSheetCarrier)this.parentsCached[i].clone();
                    sc.parents.add(carrier);
                }
            }
            sc.cascadeStyleSheet = null;
            sc.globalDefaultStyleSheet = this.globalDefaultStyleSheet;
            sc.pruneCachedEntries();
            return sc;
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException("Clone failed.");
        }
    }

    public StyleSheet derive() throws CloneNotSupportedException {
        try {
            ElementStyleSheet sc = (ElementStyleSheet)super.derive();
            if (this.properties != null) {
                sc.properties = (Object[])this.properties.clone();
            }
            if (this.source != null) {
                sc.source = (byte[])this.source.clone();
            }
            sc.styleChangeSupport = new StyleChangeSupport(sc);
            if (sc.parents != null) {
                this.parentsToCache();
                sc.parents = (ArrayList)this.parents.clone();
                sc.parents.clear();
                sc.parentsCached = new StyleSheetCarrier[this.parentsCached.length];
                for (int i = 0; i < this.parentsCached.length; ++i) {
                    StyleSheetCarrier carrier;
                    sc.parentsCached[i] = carrier = (StyleSheetCarrier)this.parentsCached[i].clone();
                    sc.parents.add(carrier);
                }
            }
            sc.cascadeStyleSheet = null;
            sc.globalDefaultStyleSheet = this.globalDefaultStyleSheet;
            sc.pruneCachedEntries();
            return sc;
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException("Clone failed.");
        }
    }

    protected StyleSheetCarrier[] getParentReferences() {
        this.parentsToCache();
        return this.parentsCached;
    }

    public ElementStyleSheet getCopy() throws CloneNotSupportedException {
        return (ElementStyleSheet)this.clone();
    }

    private void parentsToCache() {
        if (this.parents == null) {
            this.parentsCached = EMPTY_PARENTS;
            return;
        }
        if (this.parentsCached == null) {
            this.parentsCached = this.parents.toArray(new StyleSheetCarrier[this.parents.size()]);
        }
    }

    public FontDefinition getFontDefinitionProperty() {
        String name = (String)this.getStyleProperty(TextStyleKeys.FONT);
        int size = this.getIntStyleProperty(TextStyleKeys.FONTSIZE, -1);
        boolean bold = this.getBooleanStyleProperty(TextStyleKeys.BOLD);
        boolean italic = this.getBooleanStyleProperty(TextStyleKeys.ITALIC);
        boolean underlined = this.getBooleanStyleProperty(TextStyleKeys.UNDERLINED);
        boolean strike = this.getBooleanStyleProperty(TextStyleKeys.STRIKETHROUGH);
        boolean embed = this.getBooleanStyleProperty(TextStyleKeys.EMBEDDED_FONT);
        String encoding = (String)this.getStyleProperty(TextStyleKeys.FONTENCODING);
        return new FontDefinition(name, size, bold, italic, underlined, strike, encoding, embed);
    }

    public void setFontDefinitionProperty(FontDefinition font) {
        if (font == null) {
            throw new NullPointerException("ElementStyleSheet.setFontStyleProperty: font is null.");
        }
        this.setStyleProperty(TextStyleKeys.FONT, font.getFontName());
        this.setStyleProperty(TextStyleKeys.FONTSIZE, new Integer(font.getFontSize()));
        this.setBooleanStyleProperty(TextStyleKeys.BOLD, font.isBold());
        this.setBooleanStyleProperty(TextStyleKeys.ITALIC, font.isItalic());
        this.setBooleanStyleProperty(TextStyleKeys.UNDERLINED, font.isUnderline());
        this.setBooleanStyleProperty(TextStyleKeys.STRIKETHROUGH, font.isStrikeThrough());
        this.setBooleanStyleProperty(TextStyleKeys.EMBEDDED_FONT, font.isEmbeddedFont());
        this.setStyleProperty(TextStyleKeys.FONTENCODING, font.getFontEncoding(null));
    }

    public Iterator getDefinedPropertyNames() {
        ArrayList<StyleKey> al = new ArrayList<StyleKey>();
        if (this.source != null) {
            for (int i = 0; i < this.source.length; ++i) {
                if (this.source[i] != 2) continue;
                al.add(this.propertyKeys[i]);
            }
        }
        return Collections.unmodifiableList(al).iterator();
    }

    public StyleKey[] getDefinedPropertyNamesArray() {
        if (this.source == null) {
            return EMPTY_KEYS;
        }
        StyleKey[] retval = (StyleKey[])this.propertyKeys.clone();
        for (int i = 0; i < this.source.length; ++i) {
            if (this.source[i] == 2) continue;
            retval[i] = null;
        }
        return retval;
    }

    public void addListener(StyleChangeListener l) {
        this.styleChangeSupport.addListener(l);
    }

    public void removeListener(StyleChangeListener l) {
        this.styleChangeSupport.removeListener(l);
    }

    public void styleChanged(ElementStyleSheet source, StyleKey key, Object value) {
        if (source == this) {
            return;
        }
        if (!key.isInheritable()) {
            return;
        }
        if (source != null && this.source != null && this.source[key.identifier] == 2) {
            return;
        }
        ++this.changeTracker;
        this.putInCache(key, value, (byte)1);
        this.styleChangeSupport.fireStyleChanged(key, value);
    }

    public void styleRemoved(ElementStyleSheet source, StyleKey key) {
        if (source == this) {
            return;
        }
        if (!key.isInheritable()) {
            return;
        }
        if (source != null && this.source != null && this.source[key.identifier] == 2) {
            return;
        }
        ++this.changeTracker;
        this.putInCache(key, null, (byte)0);
        this.styleChangeSupport.fireStyleRemoved(key);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.properties == null) {
            out.writeInt(0);
        } else {
            int size = this.properties.length;
            out.writeInt(size);
            for (int i = 0; i < size; ++i) {
                Object value = this.properties[i];
                SerializerHelper.getInstance().writeObject(value, out);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int i;
        in.defaultReadObject();
        int size = in.readInt();
        this.propertyKeys = StyleKey.getDefinedStyleKeys();
        this.styleChangeSupport = new StyleChangeSupport(this);
        this.parentsCached = null;
        if (size == 0) {
            this.properties = null;
            return;
        }
        if (size != this.propertyKeys.length) {
            throw new IOException("Encountered a different style-system configuration. This report cannot be deserialized.");
        }
        if (this.propertyKeys[0] == null) {
            throw new IllegalStateException();
        }
        this.properties = new Object[size];
        if (size == 0) {
            return;
        }
        Object[] values = new Object[size];
        SerializerHelper serHelper = SerializerHelper.getInstance();
        for (i = 0; i < size; ++i) {
            values[i] = serHelper.readObject(in);
        }
        for (i = 0; i < size; ++i) {
            StyleKey key = this.propertyKeys[i];
            if (key == null) continue;
            int identifier = key.identifier;
            this.properties[identifier] = values[i];
        }
    }

    public boolean isGlobalDefault() {
        return false;
    }

    public StyleKey[] getPropertyKeys() {
        return (StyleKey[])this.propertyKeys.clone();
    }
}

