/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.style;

import java.io.Serializable;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleSheetCarrier;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class StyleSheetCollection
implements Cloneable,
Serializable {
    private HashMap<String, ManagedStyleSheet> styleSheets;
    private HashMap<InstanceID, ManagedStyleSheet> styleSheetsByID;
    private static final String[] EMPTY_STYLENAMES = new String[0];

    public ElementStyleSheet createStyleSheet(String name) {
        if (this.styleSheets == null) {
            this.styleSheets = new HashMap();
            this.styleSheetsByID = new HashMap();
        }
        if (this.styleSheets.containsKey(name)) {
            return this.styleSheets.get(name);
        }
        ManagedStyleSheet value = new ManagedStyleSheet(name, this);
        this.styleSheets.put(name, value);
        this.styleSheetsByID.put(value.getId(), value);
        return value;
    }

    public ElementStyleSheet getStyleSheet(String name) {
        if (this.styleSheets == null) {
            return null;
        }
        return this.styleSheets.get(name);
    }

    public ElementStyleSheet getStyleSheetByID(InstanceID name) {
        if (this.styleSheets == null) {
            return null;
        }
        return this.styleSheetsByID.get(name);
    }

    public String[] getStyleNames() {
        if (this.styleSheets == null) {
            return EMPTY_STYLENAMES;
        }
        return this.styleSheets.keySet().toArray(new String[this.styleSheets.size()]);
    }

    public Object clone() throws CloneNotSupportedException {
        StyleSheetCollection sc = (StyleSheetCollection)super.clone();
        if (this.styleSheets == null) {
            return sc;
        }
        sc.styleSheets = (HashMap)this.styleSheets.clone();
        sc.styleSheetsByID = (HashMap)this.styleSheetsByID.clone();
        ManagedStyleSheet[] styles = this.styleSheets.values().toArray(new ManagedStyleSheet[this.styleSheets.size()]);
        ManagedStyleSheet[] styleClones = (ManagedStyleSheet[])styles.clone();
        for (int i = 0; i < styles.length; ++i) {
            ManagedStyleSheet clone = styles[i].createManagedCopy(sc);
            sc.styleSheets.put(clone.getName(), clone);
            sc.styleSheetsByID.put(clone.getId(), clone);
            styleClones[i] = clone;
        }
        return sc;
    }

    protected static class ManagedStyleSheet
    extends ElementStyleSheet {
        private StyleSheetCollection styleSheetCollection;

        protected ManagedStyleSheet(String name, StyleSheetCollection collection) {
            super(name);
            if (collection == null) {
                throw new NullPointerException();
            }
            this.styleSheetCollection = collection;
        }

        public void addParent(ManagedStyleSheet parent) {
            super.addParent(0, parent);
        }

        public void addParent(int position, ManagedStyleSheet parent) {
            super.addParent(position, parent);
        }

        public Object clone() throws CloneNotSupportedException {
            ManagedStyleSheet ms = (ManagedStyleSheet)super.clone();
            ms.styleSheetCollection = null;
            StyleSheetCarrier[] sheets = ms.getParentReferences();
            for (int i = 0; i < sheets.length; ++i) {
                ManagedStyleSheetCarrier msc = (ManagedStyleSheetCarrier)sheets[i];
                msc.updateParentReference(ms);
            }
            return ms;
        }

        protected StyleSheetCarrier createCarrier(ElementStyleSheet styleSheet) {
            if (!(styleSheet instanceof ManagedStyleSheet)) {
                throw new IllegalArgumentException("Only stylesheets that are managed by this stylesheet collection can be added");
            }
            ManagedStyleSheet ms = (ManagedStyleSheet)styleSheet;
            if (ms.getStyleSheetCollection() != this.getStyleSheetCollection()) {
                throw new IllegalArgumentException("Only stylesheets that are managed by this stylesheet collection can be added");
            }
            return new ManagedStyleSheetCarrier(ms, this);
        }

        public ManagedStyleSheet createManagedCopy(StyleSheetCollection collection) throws CloneNotSupportedException {
            ManagedStyleSheet es = (ManagedStyleSheet)this.getCopy();
            es.setStyleSheetCollection(collection);
            return es;
        }

        public StyleSheetCollection getStyleSheetCollection() {
            return this.styleSheetCollection;
        }

        protected void setStyleSheetCollection(StyleSheetCollection styleSheetCollection) {
            this.styleSheetCollection = styleSheetCollection;
        }
    }

    protected static class ManagedStyleSheetCarrier
    implements StyleSheetCarrier {
        private InstanceID styleSheetID;
        private ManagedStyleSheet styleSheet;
        private ManagedStyleSheet self;

        protected ManagedStyleSheetCarrier(ManagedStyleSheet parent, ManagedStyleSheet self) {
            this.styleSheetID = parent.getId();
            this.styleSheet = parent;
            this.self = self;
            self.addListener(this.styleSheet);
        }

        public ElementStyleSheet getStyleSheet() {
            if (this.styleSheet != null) {
                return this.styleSheet;
            }
            StyleSheetCollection col = this.self.getStyleSheetCollection();
            this.styleSheet = (ManagedStyleSheet)col.getStyleSheetByID(this.styleSheetID);
            if (this.styleSheet == null) {
                throw new IllegalStateException("Stylesheet was not valid after restore operation.");
            }
            return this.styleSheet;
        }

        protected void updateParentReference(ManagedStyleSheet self) {
            this.self = self;
        }

        public void invalidate() {
            this.self.removeListener(this.getStyleSheet());
        }

        public boolean isSame(ElementStyleSheet style) {
            return style.getId().equals(this.styleSheetID);
        }

        public Object clone() throws CloneNotSupportedException {
            ManagedStyleSheetCarrier o = (ManagedStyleSheetCarrier)super.clone();
            o.styleSheet = null;
            return o;
        }
    }
}

