/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ComponentDrawable {
    private static final Log logger = LogFactory.getLog(ComponentDrawable.class);
    private boolean preserveAspectRatio;
    private Component component;
    private JFrame peerSupply;
    private JPanel contentPane;
    private PainterRunnable runnable;
    private PreferredSizeRunnable preferredSizeRunnable;
    private DefinedSizeRunnable sizeRunnable;
    private boolean paintSynchronized;
    private boolean allowOwnPeer;

    public ComponentDrawable() {
        this(new JFrame());
    }

    public ComponentDrawable(JFrame peerSupply) {
        if (peerSupply == null) {
            throw new NullPointerException();
        }
        this.peerSupply = peerSupply;
        this.contentPane = new JPanel();
        this.contentPane.setLayout(null);
        peerSupply.setContentPane(this.contentPane);
        this.runnable = new PainterRunnable();
        this.preferredSizeRunnable = new PreferredSizeRunnable();
        this.sizeRunnable = new DefinedSizeRunnable();
    }

    public boolean isAllowOwnPeer() {
        return this.allowOwnPeer;
    }

    public void setAllowOwnPeer(boolean allowOwnPeer) {
        this.allowOwnPeer = allowOwnPeer;
    }

    public boolean isPaintSynchronized() {
        return this.paintSynchronized;
    }

    public void setPaintSynchronized(boolean paintSynchronized) {
        this.paintSynchronized = paintSynchronized;
    }

    protected final void cleanUp() {
        if (this.component instanceof JComponent && !this.isOwnPeerConnected()) {
            JComponent jc = (JComponent)this.component;
            RepaintManager.currentManager(jc).removeInvalidComponent(jc);
            RepaintManager.currentManager(jc).markCompletelyClean(jc);
        }
        this.contentPane.removeAll();
        RepaintManager.currentManager(this.contentPane).removeInvalidComponent(this.contentPane);
        RepaintManager.currentManager(this.contentPane).markCompletelyClean(this.contentPane);
        this.peerSupply.dispose();
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
        this.prepareComponent(component);
    }

    public Dimension getPreferredSize() {
        if (this.component == null) {
            return new Dimension(0, 0);
        }
        if (SwingUtilities.isEventDispatchThread() || !this.paintSynchronized) {
            this.preferredSizeRunnable.run();
            return this.preferredSizeRunnable.getRetval();
        }
        try {
            SwingUtilities.invokeAndWait(this.preferredSizeRunnable);
            return this.preferredSizeRunnable.getRetval();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to compute the preferred size.");
            return new Dimension(0, 0);
        }
    }

    public Dimension getSize() {
        if (this.component == null) {
            return new Dimension(0, 0);
        }
        if (SwingUtilities.isEventDispatchThread() || !this.paintSynchronized) {
            this.sizeRunnable.run();
            return this.sizeRunnable.getRetval();
        }
        try {
            SwingUtilities.invokeAndWait(this.sizeRunnable);
            return this.sizeRunnable.getRetval();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to compute the defined size.");
            return new Dimension(0, 0);
        }
    }

    protected final boolean isOwnPeerConnected() {
        if (!this.allowOwnPeer) {
            return false;
        }
        Window windowAncestor = ComponentDrawable.getWindowAncestor(this.component);
        return windowAncestor != null && windowAncestor != this.peerSupply;
    }

    protected static Window getWindowAncestor(Component component) {
        for (Container parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Window)) continue;
            return (Window)parent;
        }
        return null;
    }

    public void setPreserveAspectRatio(boolean preserveAspectRatio) {
        this.preserveAspectRatio = preserveAspectRatio;
    }

    public boolean isPreserveAspectRatio() {
        return this.preserveAspectRatio;
    }

    public void draw(Graphics2D g2, Rectangle2D area) {
        if (this.component == null) {
            return;
        }
        this.runnable.setArea(area);
        this.runnable.setGraphics(g2);
        if (SwingUtilities.isEventDispatchThread() || !this.paintSynchronized) {
            this.runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(this.runnable);
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to redraw the component.");
            }
        }
    }

    private void prepareComponent(Component c) {
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            jc.setDoubleBuffered(false);
            Component[] childs = jc.getComponents();
            for (int i = 0; i < childs.length; ++i) {
                Component child = childs[i];
                this.prepareComponent(child);
            }
        }
    }

    private class DefinedSizeRunnable
    implements Runnable {
        private Dimension retval;

        protected DefinedSizeRunnable() {
        }

        public Dimension getRetval() {
            return this.retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.retval = null;
            try {
                Component component = ComponentDrawable.this.getComponent();
                if (!(component instanceof Window) && !ComponentDrawable.this.isOwnPeerConnected()) {
                    ComponentDrawable.this.peerSupply.pack();
                    ComponentDrawable.this.contentPane.add(component);
                }
                this.retval = component.getSize();
            }
            finally {
                ComponentDrawable.this.cleanUp();
            }
        }
    }

    private class PreferredSizeRunnable
    implements Runnable {
        private Dimension retval;

        protected PreferredSizeRunnable() {
        }

        public Dimension getRetval() {
            return this.retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.retval = null;
            try {
                Component component = ComponentDrawable.this.getComponent();
                if (!(component instanceof Window) && !ComponentDrawable.this.isOwnPeerConnected()) {
                    ComponentDrawable.this.peerSupply.pack();
                    ComponentDrawable.this.contentPane.add(component);
                    ComponentDrawable.this.contentPane.validate();
                    component.validate();
                } else {
                    if (ComponentDrawable.this.isOwnPeerConnected()) {
                        this.retval = component.getSize();
                        return;
                    }
                    component.validate();
                }
                this.retval = component.getPreferredSize();
            }
            finally {
                ComponentDrawable.this.cleanUp();
            }
        }
    }

    private class PainterRunnable
    implements Runnable {
        private Rectangle2D area;
        private Graphics2D graphics;

        protected PainterRunnable() {
        }

        public Graphics2D getGraphics() {
            return this.graphics;
        }

        public void setGraphics(Graphics2D graphics) {
            this.graphics = graphics;
        }

        public Rectangle2D getArea() {
            return this.area;
        }

        public void setArea(Rectangle2D area) {
            this.area = area;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Component component = ComponentDrawable.this.getComponent();
                if (component instanceof Window) {
                    Window w = (Window)component;
                    w.validate();
                } else if (ComponentDrawable.this.isOwnPeerConnected()) {
                    Window w = ComponentDrawable.getWindowAncestor(component);
                    if (w != null) {
                        w.validate();
                    }
                } else {
                    ComponentDrawable.this.peerSupply.pack();
                    ComponentDrawable.this.contentPane.add(component);
                }
                component.setBounds((int)this.area.getX(), (int)this.area.getY(), (int)this.area.getWidth(), (int)this.area.getHeight());
                component.validate();
                component.paint(this.graphics);
            }
            finally {
                ComponentDrawable.this.cleanUp();
            }
        }
    }
}

