/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util;

public class IntList {
    private static final int[] EMPTY_ARRAY = new int[0];
    private int[] data;
    private int size;
    private int increment;

    public IntList(int capacity) {
        this.data = new int[capacity];
        this.increment = capacity;
    }

    private void ensureCapacity(int c) {
        if (this.data.length <= c) {
            int[] newData = new int[Math.max(this.data.length + this.increment, c + 1)];
            System.arraycopy(this.data, 0, newData, 0, this.size);
            this.data = newData;
        }
    }

    public void add(int value) {
        this.ensureCapacity(this.size);
        this.data[this.size] = value;
        ++this.size;
    }

    public int get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.data[index];
    }

    public void clear() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public int[] toArray() {
        if (this.size == 0) {
            return EMPTY_ARRAY;
        }
        int[] retval = new int[this.size];
        System.arraycopy(this.data, 0, retval, 0, this.size);
        return retval;
    }
}

