/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util;

import java.io.IOException;
import java.io.Writer;
import org.pentaho.reporting.engine.classic.core.util.MemoryStringReader;

public class MemoryStringWriter
extends Writer {
    private int cursor;
    private char[] buffer;
    private int maximumBufferIncrement;
    private boolean closed;

    public MemoryStringWriter() {
        this(4096);
    }

    public MemoryStringWriter(int bufferSize) {
        this(bufferSize, bufferSize * 4);
    }

    public MemoryStringWriter(int bufferSize, int maximumBufferIncrement) {
        this.maximumBufferIncrement = maximumBufferIncrement;
        this.buffer = new char[bufferSize];
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (len < 0) {
            throw new IllegalArgumentException();
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (cbuf == null) {
            throw new NullPointerException();
        }
        if (len + off > cbuf.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.closed) {
            throw new IOException("Stream already closed.");
        }
        this.ensureSize(this.cursor + len);
        System.arraycopy(cbuf, off, this.buffer, this.cursor, len);
        this.cursor += len;
    }

    private void ensureSize(int size) {
        if (this.buffer.length >= size) {
            return;
        }
        int computedSize = (int)Math.min((double)(this.buffer.length + 1) * 1.5, (double)(this.buffer.length + this.maximumBufferIncrement));
        int newSize = Math.max(size, computedSize);
        char[] newBuffer = new char[newSize];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.cursor);
        this.buffer = newBuffer;
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream already closed.");
        }
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public int getCursor() {
        return this.cursor;
    }

    public MemoryStringReader createReader() {
        return new MemoryStringReader(this.buffer, 0, this.cursor);
    }

    public String toString() {
        return new String(this.buffer, 0, this.cursor);
    }
}

