/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util;

import java.awt.Insets;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.util.PageSize;

public final class PageFormatFactory {
    private static final Log logger = LogFactory.getLog(PageFormatFactory.class);
    private static PageFormatFactory singleton;
    private static final String[] EMPTY_PAGEFORMATS;

    private PageFormatFactory() {
    }

    public static synchronized PageFormatFactory getInstance() {
        if (singleton == null) {
            singleton = new PageFormatFactory();
        }
        return singleton;
    }

    public Paper createPaper(int[] papersize) {
        if (papersize.length != 2) {
            throw new IllegalArgumentException("Paper must have a width and a height");
        }
        return this.createPaper(papersize[0], papersize[1]);
    }

    public Paper createPaper(PageSize papersize) {
        return this.createPaper(papersize.getWidth(), papersize.getHeight());
    }

    public Paper createPaper(double width, double height) {
        Paper p = new Paper();
        p.setSize(width, height);
        this.setBorders(p, 0.0, 0.0, 0.0, 0.0);
        return p;
    }

    public void setBorders(Paper paper, double top, double left, double bottom, double right) {
        double w = paper.getWidth() - (right + left);
        double h = paper.getHeight() - (bottom + top);
        paper.setImageableArea(left, top, w, h);
    }

    public void setBordersInch(Paper paper, double top, double left, double bottom, double right) {
        this.setBorders(paper, this.convertInchToPoints(top), this.convertInchToPoints(left), this.convertInchToPoints(bottom), this.convertInchToPoints(right));
    }

    public void setBordersMm(Paper paper, double top, double left, double bottom, double right) {
        this.setBorders(paper, this.convertMmToPoints(top), this.convertMmToPoints(left), this.convertMmToPoints(bottom), this.convertMmToPoints(right));
    }

    public double convertInchToPoints(double inches) {
        return inches * 72.0;
    }

    public double convertMmToPoints(double mm) {
        return mm * 0.28346456692913385 * 10.0;
    }

    public PageFormat createPageFormat(Paper paper, int orientation) {
        if (paper == null) {
            throw new NullPointerException("Paper given must not be null");
        }
        PageFormat pf = new PageFormat();
        pf.setPaper(paper);
        pf.setOrientation(orientation);
        return pf;
    }

    public Paper createPaper(String name) {
        try {
            Field f = PageSize.class.getDeclaredField(name);
            Object o = f.get(null);
            if (!(o instanceof PageSize)) {
                return null;
            }
            PageSize pageformat = (PageSize)o;
            return this.createPaper(pageformat);
        }
        catch (NoSuchFieldException nfe) {
            return null;
        }
        catch (IllegalAccessException aie) {
            return null;
        }
    }

    public static void logPageFormat(PageFormat pf) {
        logger.debug((Object)("PageFormat: Width: " + pf.getWidth() + " Height: " + pf.getHeight()));
        logger.debug((Object)("PageFormat: Image: X " + pf.getImageableX() + " Y " + pf.getImageableY() + " W: " + pf.getImageableWidth() + " H: " + pf.getImageableHeight()));
        logger.debug((Object)("PageFormat: Margins: X " + pf.getImageableX() + " Y " + pf.getImageableY() + " X2: " + (pf.getImageableWidth() + pf.getImageableX()) + " Y2: " + (pf.getImageableHeight() + pf.getImageableY())));
    }

    public static void logPaper(Paper pf) {
        logger.debug((Object)("Paper: Width: " + pf.getWidth() + " Height: " + pf.getHeight()));
        logger.debug((Object)("Paper: Image: X " + pf.getImageableX() + " Y " + pf.getImageableY() + " H: " + pf.getImageableHeight() + " W: " + pf.getImageableWidth()));
    }

    public static boolean isEqual(PageFormat pf1, PageFormat pf2) {
        if (pf1 == pf2) {
            return true;
        }
        if (pf1 == null || pf2 == null) {
            return false;
        }
        if (pf1.getOrientation() != pf2.getOrientation()) {
            return false;
        }
        Paper p1 = pf1.getPaper();
        Paper p2 = pf2.getPaper();
        if (p1.getWidth() != p2.getWidth()) {
            return false;
        }
        if (p1.getHeight() != p2.getHeight()) {
            return false;
        }
        if (p1.getImageableX() != p2.getImageableX()) {
            return false;
        }
        if (p1.getImageableY() != p2.getImageableY()) {
            return false;
        }
        if (p1.getImageableWidth() != p2.getImageableWidth()) {
            return false;
        }
        return p1.getImageableHeight() == p2.getImageableHeight();
    }

    public double getLeftBorder(Paper p) {
        return p.getImageableX();
    }

    public double getRightBorder(Paper p) {
        return p.getWidth() - (p.getImageableX() + p.getImageableWidth());
    }

    public double getTopBorder(Paper p) {
        return p.getImageableY();
    }

    public double getBottomBorder(Paper p) {
        return p.getHeight() - (p.getImageableY() + p.getImageableHeight());
    }

    public Insets getPageMargins(PageFormat format) {
        int marginLeft = (int)format.getImageableX();
        int marginRight = (int)(format.getWidth() - format.getImageableWidth() - format.getImageableX());
        int marginTop = (int)format.getImageableY();
        int marginBottom = (int)(format.getHeight() - format.getImageableHeight() - format.getImageableY());
        return new Insets(marginTop, marginLeft, marginBottom, marginRight);
    }

    public String getPageFormatName(double width, double height) {
        try {
            Field[] fields = PageSize.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                PageSize pageDef;
                Object o;
                Field f = fields[i];
                if (!Modifier.isPublic(f.getModifiers()) || !Modifier.isStatic(f.getModifiers()) || !((o = f.get(PageFormatFactory.getInstance())) instanceof PageSize) || (pageDef = (PageSize)o).getWidth() != width || pageDef.getHeight() != height) continue;
                return f.getName();
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to lookup the page name", (Throwable)e);
        }
        return null;
    }

    public String[] getPageFormats() {
        try {
            ArrayList<String> a = new ArrayList<String>();
            Field[] fields = PageSize.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Object o;
                Field f = fields[i];
                if (!Modifier.isPublic(f.getModifiers()) || !Modifier.isStatic(f.getModifiers()) || !((o = f.get(PageFormatFactory.getInstance())) instanceof PageSize)) continue;
                a.add(f.getName());
            }
            return a.toArray(new String[a.size()]);
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to lookup the page name", (Throwable)e);
            return EMPTY_PAGEFORMATS;
        }
    }

    public void setPageMargins(PageFormat pageFormat, Insets pageMargins) {
        Paper paper = pageFormat.getPaper();
        this.setBorders(paper, pageMargins.top, pageMargins.left, pageMargins.bottom, pageMargins.right);
        pageFormat.setPaper(paper);
    }

    static {
        EMPTY_PAGEFORMATS = new String[0];
    }
}

