/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import org.pentaho.reporting.libraries.base.util.LinkedMap;

public class ReportProperties
implements Serializable,
Cloneable {
    private LinkedMap properties;
    private ReportProperties masterProperties;

    public ReportProperties(ReportProperties props) {
        try {
            this.properties = (LinkedMap)props.properties.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Should not happen");
        }
    }

    public ReportProperties() {
        this.properties = new LinkedMap();
    }

    public void put(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("ReportProperties.put (..): Parameter 'key' must not be null");
        }
        if (value == null) {
            this.properties.remove((Object)key);
        } else {
            this.properties.put((Object)key, value);
        }
    }

    public Object get(String key) {
        if (key == null) {
            throw new NullPointerException("ReportProperties.get (..): Parameter 'key' must not be null");
        }
        return this.get(key, null);
    }

    public Object get(String key, Object defaultValue) {
        if (key == null) {
            throw new NullPointerException("ReportProperties.get (..): Parameter 'key' must not be null");
        }
        Object o = this.properties.get((Object)key);
        if (o == null) {
            if (this.masterProperties != null) {
                return this.masterProperties.get(key, defaultValue);
            }
            return defaultValue;
        }
        return o;
    }

    public Iterator keys() {
        return Arrays.asList(this.properties.keys()).iterator();
    }

    public void clear() {
        this.properties.clear();
    }

    public boolean containsKey(String key) {
        if (key == null) {
            throw new NullPointerException("ReportProperties.containsKey (..): Parameter key must not be null");
        }
        return this.properties.containsKey((Object)key);
    }

    public Object clone() throws CloneNotSupportedException {
        ReportProperties p = (ReportProperties)super.clone();
        p.properties = (LinkedMap)this.properties.clone();
        p.masterProperties = null;
        return p;
    }

    public boolean containsMarkedProperties() {
        return true;
    }

    public ReportProperties getMasterProperties() {
        return this.masterProperties;
    }

    public void setMasterProperties(ReportProperties masterProperties) {
        this.masterProperties = masterProperties;
    }

    public String[] keyArray() {
        return (String[])this.properties.keys((Object[])new String[this.properties.size()]);
    }

    public int size() {
        return this.properties.size();
    }
}

