/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMap;
import org.pentaho.reporting.engine.classic.core.layout.LayoutSupport;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.ReportDrawable;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public class ScalingDrawable
extends DrawableWrapper
implements ReportDrawable {
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private ResourceBundleFactory resourceBundleFactory;
    private LayoutSupport layoutSupport;
    private Configuration configuration;
    private StyleSheet styleSheet;

    public ScalingDrawable(Object drawable) {
        super(drawable);
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
    }

    public void draw(Graphics2D g2, Rectangle2D area) {
        Object drawable = this.getBackend();
        if (drawable == null) {
            return;
        }
        if (drawable instanceof ReportDrawable) {
            ReportDrawable reportDrawable = (ReportDrawable)drawable;
            reportDrawable.setConfiguration(this.getConfiguration());
            reportDrawable.setResourceBundleFactory(this.getResourceBundleFactory());
            reportDrawable.setStyleSheet(this.getStyleSheet());
        }
        Graphics2D derived = (Graphics2D)g2.create();
        derived.scale(this.scaleX, this.scaleY);
        Rectangle2D scaledArea = (Rectangle2D)area.clone();
        scaledArea.setRect(scaledArea.getX() * (double)this.scaleX, scaledArea.getY() * (double)this.scaleY, scaledArea.getWidth() * (double)this.scaleX, scaledArea.getHeight() * (double)this.scaleY);
        super.draw(derived, scaledArea);
        derived.dispose();
    }

    public ImageMap getImageMap(Rectangle2D bounds) {
        Object drawable = this.getBackend();
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof ReportDrawable) {
            ReportDrawable reportDrawable = (ReportDrawable)drawable;
            Rectangle2D scaledArea = (Rectangle2D)bounds.clone();
            scaledArea.setRect(scaledArea.getX() * (double)this.scaleX, scaledArea.getY() * (double)this.scaleY, scaledArea.getWidth() * (double)this.scaleX, scaledArea.getHeight() * (double)this.scaleY);
            reportDrawable.getImageMap(scaledArea);
        }
        return null;
    }

    public StyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    public void setStyleSheet(StyleSheet styleSheet) {
        this.styleSheet = styleSheet;
    }

    public ResourceBundleFactory getResourceBundleFactory() {
        return this.resourceBundleFactory;
    }

    public void setResourceBundleFactory(ResourceBundleFactory resourceBundleFactory) {
        this.resourceBundleFactory = resourceBundleFactory;
    }

    public LayoutSupport getLayoutSupport() {
        return this.layoutSupport;
    }

    public void setLayoutSupport(LayoutSupport layoutSupport) {
        this.layoutSupport = layoutSupport;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

