/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMap;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.internal.LogicalPageDrawable;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.ReportDrawable;
import org.pentaho.reporting.engine.classic.core.util.ShapeTransform;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class ShapeDrawable
implements ReportDrawable {
    private StyleSheet layoutContext;
    private Shape shape;
    private boolean preserveAspectRatio;

    public ShapeDrawable(Shape shape, boolean isPreserveAspectRatio) {
        if (shape == null) {
            throw new NullPointerException();
        }
        this.preserveAspectRatio = isPreserveAspectRatio;
        this.shape = shape;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void draw(Graphics2D g2, Rectangle2D bounds) {
        double extraPadding;
        boolean shouldDraw = this.layoutContext.getBooleanStyleProperty(ElementStyleKeys.DRAW_SHAPE);
        boolean shouldFill = this.layoutContext.getBooleanStyleProperty(ElementStyleKeys.FILL_SHAPE);
        if (!shouldFill && !shouldDraw) {
            return;
        }
        boolean scale = this.layoutContext.getBooleanStyleProperty(ElementStyleKeys.SCALE);
        boolean keepAspectRatio = this.layoutContext.getBooleanStyleProperty(ElementStyleKeys.KEEP_ASPECT_RATIO);
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        Shape scaledShape = ShapeTransform.transformShape(this.shape, scale, keepAspectRatio, width, height);
        Graphics2D clone = (Graphics2D)g2.create();
        if (this.layoutContext != null) {
            Object o = this.layoutContext.getStyleProperty(ElementStyleKeys.STROKE);
            if (o instanceof BasicStroke) {
                BasicStroke stroke = (BasicStroke)o;
                extraPadding = (double)stroke.getLineWidth() / 2.0;
            } else {
                extraPadding = 0.5;
            }
        } else {
            extraPadding = 0.5;
        }
        Rectangle2D.Double drawAreaBounds = new Rectangle2D.Double(x - extraPadding, y - extraPadding, width + 2.0 * extraPadding, height + 2.0 * extraPadding);
        clone.clip(drawAreaBounds);
        clone.translate(x, y);
        if (shouldFill) {
            this.configureFillColor(this.layoutContext, clone);
            clone.fill(scaledShape);
        }
        if (shouldDraw) {
            this.configureGraphics(this.layoutContext, clone);
            clone.draw(scaledShape);
        }
        clone.dispose();
    }

    protected void configureGraphics(StyleSheet layoutContext, Graphics2D g2) {
        if (layoutContext == null) {
            return;
        }
        Color cssColor = (Color)layoutContext.getStyleProperty(ElementStyleKeys.PAINT);
        g2.setColor(cssColor);
        Stroke styleProperty = (Stroke)layoutContext.getStyleProperty(ElementStyleKeys.STROKE);
        if (styleProperty != null) {
            g2.setStroke(styleProperty);
        } else {
            g2.setStroke(LogicalPageDrawable.DEFAULT_STROKE);
        }
    }

    private void configureFillColor(StyleSheet layoutContext, Graphics2D graphics2D) {
        if (layoutContext == null) {
            return;
        }
        Color cssColor = (Color)layoutContext.getStyleProperty(ElementStyleKeys.FILL_COLOR);
        if (cssColor != null) {
            graphics2D.setColor(cssColor);
        } else {
            Color paint = (Color)layoutContext.getStyleProperty(ElementStyleKeys.PAINT);
            if (paint != null) {
                graphics2D.setPaint(paint);
            }
        }
    }

    public void setConfiguration(Configuration config) {
    }

    public void setStyleSheet(StyleSheet style) {
        this.layoutContext = style;
    }

    public void setResourceBundleFactory(ResourceBundleFactory bundleFactory) {
    }

    public ImageMap getImageMap(Rectangle2D bounds) {
        return null;
    }

    public boolean isKeepAspectRatio() {
        return this.preserveAspectRatio;
    }

    public Dimension getPreferredSize() {
        Rectangle bounds = this.shape.getBounds();
        return new Dimension((int)bounds.getMaxX(), (int)bounds.getMaxY());
    }
}

