/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WeakReferenceList<T>
implements Serializable,
Cloneable {
    private static final Log logger = LogFactory.getLog(WeakReferenceList.class);
    private T master;
    private transient Reference<T>[] childs;
    private int size;
    private final int maxChilds;

    protected WeakReferenceList(int maxChildCount) {
        this.maxChilds = maxChildCount;
        this.childs = new Reference[maxChildCount - 1];
    }

    protected final int getMaxChildCount() {
        return this.maxChilds;
    }

    protected Object getMaster() {
        return this.master;
    }

    protected void setMaster(T master) {
        this.master = master;
    }

    protected abstract T restoreChild(int var1);

    public Object get(int index) {
        if (this.isMaster(index)) {
            return this.master;
        }
        Reference<T> ref = this.childs[this.getChildPos(index)];
        if (ref == null) {
            throw new IllegalStateException("State: " + index);
        }
        T ob = ref.get();
        if (ob == null) {
            ob = this.restoreChild(index);
            this.childs[this.getChildPos((int)index)] = this.createReference(ob);
        }
        return ob;
    }

    public T getRaw(int index) {
        if (this.isMaster(index)) {
            return this.master;
        }
        Reference<T> ref = this.childs[this.getChildPos(index)];
        if (ref == null) {
            throw new IllegalStateException("State: " + index);
        }
        return ref.get();
    }

    public void set(T report, int index) {
        if (this.isMaster(index)) {
            this.master = report;
        } else {
            this.childs[this.getChildPos((int)index)] = this.createReference(report);
        }
    }

    private Reference<T> createReference(T o) {
        return new WeakReference<T>(o);
    }

    public boolean add(T rs) {
        if (this.size == 0) {
            this.master = rs;
            this.size = 1;
            return true;
        }
        if (this.size < this.getMaxChildCount()) {
            this.childs[this.size - 1] = this.createReference(rs);
            ++this.size;
            return true;
        }
        return false;
    }

    protected boolean isMaster(int index) {
        return index % this.getMaxChildCount() == 0;
    }

    protected int getChildPos(int index) {
        return index % this.getMaxChildCount() - 1;
    }

    public int getSize() {
        return this.size;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.childs = new Reference[this.getMaxChildCount() - 1];
        for (int i = 0; i < this.childs.length; ++i) {
            this.childs[i] = this.createReference(null);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        WeakReferenceList list = (WeakReferenceList)super.clone();
        list.childs = (Reference[])this.childs.clone();
        return list;
    }
}

