/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Worker
extends Thread {
    private static final Log logger = LogFactory.getLog(Worker.class);
    private static final int STATE_IDLE = 0;
    private static final int STATE_WORKING = 1;
    private static final int STATE_DEAD = 2;
    private final Object lock = new Object();
    private Runnable workload;
    private int state;
    private final int sleeptime;

    public Worker(int sleeptime) {
        this.sleeptime = sleeptime;
        this.setDaemon(true);
        this.start();
    }

    public Worker() {
        this(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorkload(Runnable r) {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 2) {
                throw new IllegalStateException("Thread is dead already.");
            }
            if (this.workload != null) {
                throw new IllegalStateException("This worker is not idle.");
            }
            this.workload = r;
            this.lock.notifyAll();
        }
    }

    public synchronized Runnable getWorkload() {
        return this.workload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 2) {
                return;
            }
            this.state = 2;
            try {
                this.interrupt();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable() {
        Object object = this.lock;
        synchronized (object) {
            return this.state == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Runnable nextWorkLoad;
            Object object = this.lock;
            synchronized (object) {
                if (this.workload != null) {
                    this.state = 1;
                    nextWorkLoad = this.workload;
                    this.workload = null;
                } else {
                    nextWorkLoad = null;
                }
            }
            try {
                if (nextWorkLoad != null) {
                    nextWorkLoad.run();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Worker caught exception on run: ", (Throwable)e);
            }
            object = this.lock;
            synchronized (object) {
                if (this.state == 2) {
                    Worker worker = this;
                    synchronized (worker) {
                        this.notifyAll();
                    }
                    return;
                }
                this.state = 0;
                try {
                    this.lock.wait(this.sleeptime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinish() {
        Object object = this.lock;
        synchronized (object) {
            return this.state == 2;
        }
    }
}

