/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util.beans;

import java.math.BigInteger;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ValueConverter;

public class BigIntegerValueConverter
implements ValueConverter {
    public String toAttributeValue(Object o) throws BeanException {
        if (o == null) {
            throw new NullPointerException();
        }
        if (o instanceof BigInteger) {
            return o.toString();
        }
        throw new BeanException("Failed to convert object of type " + o.getClass() + ": Not a big-integer.");
    }

    public Object toPropertyValue(String s) throws BeanException {
        if (s == null) {
            throw new NullPointerException();
        }
        String val = s.trim();
        if (val.length() == 0) {
            throw BeanException.getInstance("Failed to convert empty string to number", null);
        }
        try {
            return new BigInteger(val);
        }
        catch (NumberFormatException be) {
            throw BeanException.getInstance("Failed to parse string as number", be);
        }
    }
}

