/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util.beans;

import org.pentaho.reporting.engine.classic.core.modules.parser.base.compat.CompatibilityMapperUtil;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ValueConverter;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ClassValueConverter
implements ValueConverter {
    public String toAttributeValue(Object o) throws BeanException {
        if (o == null) {
            throw new NullPointerException();
        }
        if (o instanceof Class) {
            Class c = (Class)o;
            return c.getName();
        }
        throw new BeanException("Failed to convert object of type " + o.getClass() + ": Not a Class.");
    }

    public Object toPropertyValue(String s) throws BeanException {
        if (s == null) {
            throw new NullPointerException();
        }
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(ClassValueConverter.class);
            return Class.forName(CompatibilityMapperUtil.mapClassName(s), false, loader);
        }
        catch (Throwable e) {
            throw new BeanException("Specified class does not exist or cannot be loaded.", e);
        }
    }
}

