/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util.beans;

import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ValueConverter;

public class ColorValueConverter
implements ValueConverter {
    private static final HashMap knownColorNamesByColor = new HashMap();
    private static final HashMap knownColorsByName = new HashMap();

    public String toAttributeValue(Object o) throws BeanException {
        if (o == null) {
            return null;
        }
        if (!(o instanceof Color)) {
            throw new BeanException("Failed to convert object of type " + o.getClass() + ": Not a Color.");
        }
        Color c = (Color)o;
        return ColorValueConverter.colorToString(c);
    }

    public Object toPropertyValue(String value) throws BeanException {
        if (value == null) {
            throw new NullPointerException();
        }
        Object o = knownColorsByName.get(value.toLowerCase());
        if (o != null) {
            return o;
        }
        try {
            return Color.decode(value.trim());
        }
        catch (NumberFormatException nfe) {
            throw new BeanException("Failed to parse color text as RGB-number.", nfe);
        }
    }

    public static String colorToString(Color c) {
        if (c == null) {
            return null;
        }
        String name = (String)knownColorNamesByColor.get(c);
        if (name != null) {
            return name;
        }
        String color = Integer.toHexString(c.getRGB() & 0xFFFFFF);
        StringBuilder retval = new StringBuilder(7);
        retval.append('#');
        int fillUp = 6 - color.length();
        for (int i = 0; i < fillUp; ++i) {
            retval.append('0');
        }
        retval.append(color);
        return retval.toString();
    }

    static {
        try {
            Field[] fields = Color.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                if (!Modifier.isPublic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers()) || !Modifier.isStatic(f.getModifiers())) continue;
                String name = f.getName();
                Object oColor = f.get(null);
                if (!(oColor instanceof Color)) continue;
                knownColorNamesByColor.put(oColor, name.toLowerCase());
                knownColorsByName.put(name.toLowerCase(), oColor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

