/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util.beans;

import java.awt.Font;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ValueConverter;

public class FontValueConverter
implements ValueConverter {
    public String toAttributeValue(Object o) throws BeanException {
        if (o == null) {
            throw new NullPointerException();
        }
        if (!(o instanceof Font)) {
            throw new BeanException("Failed to convert object of type " + o.getClass() + ": Not a Font.");
        }
        Font font = (Font)o;
        int fontSize = font.getSize();
        String fontName = font.getName();
        int fontStyle = font.getStyle();
        return fontName + '-' + FontValueConverter.styleToString(fontStyle) + '-' + fontSize;
    }

    private static String styleToString(int style) {
        if (style == 0) {
            return "plain";
        }
        if (style == 1) {
            return "bold";
        }
        if (style == 2) {
            return "italic";
        }
        if (style == 3) {
            return "bolditalic";
        }
        return "plain";
    }

    public Object toPropertyValue(String s) throws BeanException {
        if (s == null) {
            throw new NullPointerException();
        }
        return Font.decode(s);
    }
}

