/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util.beans;

import java.util.Locale;
import java.util.StringTokenizer;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ValueConverter;

public class LocaleValueConverter
implements ValueConverter {
    public String toAttributeValue(Object o) throws BeanException {
        if (o == null) {
            throw new NullPointerException();
        }
        if (!(o instanceof Locale)) {
            throw new BeanException("Failed to convert object of type " + o.getClass() + ": Not a Locale.");
        }
        Locale l = (Locale)o;
        if ("".equals(l.getCountry())) {
            return l.getLanguage();
        }
        if ("".equals(l.getVariant())) {
            return l.getLanguage() + '_' + l.getCountry();
        }
        return l.getLanguage() + '_' + l.getCountry() + '_' + l.getVariant();
    }

    public Object toPropertyValue(String s) throws BeanException {
        if (s == null) {
            throw new NullPointerException();
        }
        StringTokenizer strtok = new StringTokenizer(s.trim(), "_");
        if (!strtok.hasMoreElements()) {
            throw new BeanException("This is no valid locale specification.");
        }
        String language = strtok.nextToken();
        String country = "";
        if (strtok.hasMoreTokens()) {
            country = strtok.nextToken();
        }
        String variant = "";
        if (strtok.hasMoreTokens()) {
            variant = strtok.nextToken();
        }
        return new Locale(language, country, variant);
    }
}

