/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.wizard;

import java.util.HashSet;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.function.AggregationFunction;
import org.pentaho.reporting.engine.classic.core.function.FieldAggregationFunction;
import org.pentaho.reporting.engine.classic.core.states.datarow.DefaultFlowController;
import org.pentaho.reporting.engine.classic.core.wizard.AutoGeneratorUtility;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;

public class AggregateFieldPreProcessor
implements ReportPreProcessor {
    private HashSet generatedExpressionNames;

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MasterReport performPreProcessing(MasterReport definition, DefaultFlowController flowController) throws ReportProcessingException {
        try {
            this.generatedExpressionNames = new HashSet();
            DataSchema schema = flowController.getDataSchema();
            this.processSection(schema, definition, definition);
            MasterReport masterReport = definition;
            return masterReport;
        }
        finally {
            this.generatedExpressionNames = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubReport performPreProcessing(SubReport definition, DefaultFlowController flowController) throws ReportProcessingException {
        try {
            this.generatedExpressionNames = new HashSet();
            DataSchema schema = flowController.getDataSchema();
            this.processSection(schema, definition, definition);
            SubReport subReport = definition;
            return subReport;
        }
        finally {
            this.generatedExpressionNames = null;
        }
    }

    private void processSection(DataSchema schema, AbstractReportDefinition definition, Section section) throws ReportProcessingException {
        int count = section.getElementCount();
        for (int i = 0; i < count; ++i) {
            Class aggType;
            ReportElement element = section.getElement(i);
            if (element instanceof SubReport) continue;
            if (element instanceof Section) {
                this.processSection(schema, definition, (Section)element);
                continue;
            }
            Object attribute = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "aggregation-type");
            if (!(attribute instanceof Class) || !AggregationFunction.class.isAssignableFrom(aggType = (Class)attribute)) continue;
            try {
                Object labelFor;
                AggregationFunction o = (AggregationFunction)aggType.newInstance();
                String group = (String)element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "aggregation-group");
                if (group != null) {
                    o.setGroup(group);
                } else {
                    Group g = this.findGroup(element);
                    if (g != null) {
                        if (g.getName() == null) {
                            g.setName("::wizard:group:" + g.getClass().getName() + ':' + System.identityHashCode(g));
                        }
                        o.setGroup(g.getName());
                    }
                }
                String fieldName = (String)element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field");
                if (o instanceof FieldAggregationFunction) {
                    FieldAggregationFunction fo = (FieldAggregationFunction)o;
                    fo.setField(fieldName);
                }
                if ((labelFor = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "label-for")) == null) {
                    element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "label-for", fieldName);
                }
                String name = AutoGeneratorUtility.generateUniqueExpressionName(schema, "::wizard:aggregation:{0}", this.generatedExpressionNames.toArray(new String[this.generatedExpressionNames.size()]));
                o.setName(name);
                this.generatedExpressionNames.add(name);
                element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field", name);
                element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "aggregation-type", null);
                definition.addExpression(o);
                continue;
            }
            catch (Exception e) {
                throw new ReportProcessingException("Failed to pre-process the report", e);
            }
        }
    }

    private Group findGroup(ReportElement element) {
        for (Section parentSection = element.getParentSection(); parentSection != null; parentSection = parentSection.getParentSection()) {
            if (!(parentSection instanceof Group)) continue;
            return (Group)parentSection;
        }
        return null;
    }
}

