/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.wizard;

import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeReference;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeReferences;
import org.pentaho.reporting.libraries.xmlns.common.AttributeMap;

public class DefaultDataAttributeReferences
implements DataAttributeReferences {
    private AttributeMap backend = new AttributeMap();

    public void setReference(String domain, String name, DataAttributeReference value) {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        this.backend.setAttribute(domain, name, (Object)value);
    }

    public String[] getMetaAttributeDomains() {
        return this.backend.getNameSpaces();
    }

    public String[] getMetaAttributeNames(String domainName) {
        if (domainName == null) {
            throw new NullPointerException();
        }
        return this.backend.getNames(domainName);
    }

    public DataAttributeReference getReference(String domain, String name) {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        return (DataAttributeReference)this.backend.getAttribute(domain, name);
    }

    public void merge(DataAttributeReferences attributes) {
        if (attributes == null) {
            throw new NullPointerException();
        }
        String[] domains = attributes.getMetaAttributeDomains();
        for (int i = 0; i < domains.length; ++i) {
            String domain = domains[i];
            String[] names = attributes.getMetaAttributeNames(domain);
            for (int j = 0; j < names.length; ++j) {
                String name = names[j];
                DataAttributeReference value = attributes.getReference(domain, name);
                if (value == null) continue;
                this.backend.setAttribute(domain, name, (Object)value);
            }
        }
    }
}

