/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.wizard;

import org.pentaho.reporting.engine.classic.core.wizard.ConceptQueryMapper;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeReference;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeReferences;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultConceptQueryMapper;
import org.pentaho.reporting.libraries.xmlns.common.AttributeMap;

public class DefaultDataAttributes
implements DataAttributes {
    private AttributeMap valueBackend = new AttributeMap();
    private AttributeMap mapperBackend = new AttributeMap();

    public void setMetaAttribute(String domain, String name, ConceptQueryMapper conceptMapper, Object value) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (domain == null) {
            throw new NullPointerException();
        }
        this.valueBackend.setAttribute(domain, name, value);
        this.mapperBackend.setAttribute(domain, name, (Object)conceptMapper);
    }

    public String[] getMetaAttributeDomains() {
        return this.valueBackend.getNameSpaces();
    }

    public String[] getMetaAttributeNames(String domainName) {
        if (domainName == null) {
            throw new NullPointerException();
        }
        return this.valueBackend.getNames(domainName);
    }

    public Object getMetaAttribute(String domain, String name, Class type, DataAttributeContext context) {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        return this.getMetaAttribute(domain, name, type, context, null);
    }

    public Object getMetaAttribute(String domain, String name, Class type, DataAttributeContext context, Object defaultValue) {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        Object attribute = this.valueBackend.getAttribute(domain, name);
        if (attribute == null) {
            return defaultValue;
        }
        ConceptQueryMapper mapper = this.getMetaAttributeMapper(domain, name);
        return mapper.getValue(attribute, type, context);
    }

    public ConceptQueryMapper getMetaAttributeMapper(String domain, String name) {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        ConceptQueryMapper attribute = (ConceptQueryMapper)this.mapperBackend.getAttribute(domain, name);
        if (attribute == null) {
            return DefaultConceptQueryMapper.INSTANCE;
        }
        return attribute;
    }

    public void merge(DataAttributes attributes, DataAttributeContext context) {
        if (attributes == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        String[] domains = attributes.getMetaAttributeDomains();
        for (int i = 0; i < domains.length; ++i) {
            String domain = domains[i];
            String[] names = attributes.getMetaAttributeNames(domain);
            for (int j = 0; j < names.length; ++j) {
                String name = names[j];
                Object value = attributes.getMetaAttribute(domain, name, null, context);
                if (value == null) continue;
                this.valueBackend.setAttribute(domain, name, value);
                this.mapperBackend.setAttribute(domain, name, (Object)attributes.getMetaAttributeMapper(domain, name));
            }
        }
    }

    public void mergeReferences(DataAttributeReferences references, DataAttributeContext context) {
        if (references == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        String[] domains = references.getMetaAttributeDomains();
        for (int i = 0; i < domains.length; ++i) {
            String domain = domains[i];
            String[] names = references.getMetaAttributeNames(domain);
            for (int j = 0; j < names.length; ++j) {
                String name = names[j];
                DataAttributeReference ref = references.getReference(domain, name);
                Object value = ref.resolve(this, context);
                if (value == null) continue;
                this.valueBackend.setAttribute(domain, name, value);
                this.mapperBackend.setAttribute(domain, name, (Object)ref.resolveMapper(this));
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultDataAttributes o = (DefaultDataAttributes)super.clone();
        o.valueBackend = (AttributeMap)this.valueBackend.clone();
        o.mapperBackend = (AttributeMap)this.mapperBackend.clone();
        return o;
    }

    public boolean isEmpty() {
        return this.valueBackend.getNameSpaces().length == 0;
    }
}

