/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaDefinition;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaRule;
import org.pentaho.reporting.engine.classic.core.wizard.DirectFieldSelectorRule;
import org.pentaho.reporting.engine.classic.core.wizard.GlobalRule;
import org.pentaho.reporting.engine.classic.core.wizard.MetaSelectorRule;

public class DefaultDataSchemaDefinition
implements DataSchemaDefinition {
    private ArrayList backend = new ArrayList();

    public void addRule(DataSchemaRule rule) {
        if (rule == null) {
            throw new NullPointerException();
        }
        this.backend.add(rule);
    }

    public DataSchemaRule getRule(int index) {
        return (DataSchemaRule)this.backend.get(index);
    }

    public int getRuleCount() {
        return this.backend.size();
    }

    public GlobalRule[] getGlobalRules() {
        ArrayList<DataSchemaRule> retval = new ArrayList<DataSchemaRule>();
        for (int i = 0; i < this.backend.size(); ++i) {
            DataSchemaRule rule = (DataSchemaRule)this.backend.get(i);
            if (!(rule instanceof GlobalRule)) continue;
            retval.add(rule);
        }
        return retval.toArray(new GlobalRule[retval.size()]);
    }

    public MetaSelectorRule[] getIndirectRules() {
        ArrayList<DataSchemaRule> retval = new ArrayList<DataSchemaRule>();
        for (int i = 0; i < this.backend.size(); ++i) {
            DataSchemaRule rule = (DataSchemaRule)this.backend.get(i);
            if (!(rule instanceof MetaSelectorRule)) continue;
            retval.add(rule);
        }
        return retval.toArray(new MetaSelectorRule[retval.size()]);
    }

    public DirectFieldSelectorRule[] getDirectRules() {
        ArrayList<DataSchemaRule> retval = new ArrayList<DataSchemaRule>();
        for (int i = 0; i < this.backend.size(); ++i) {
            DataSchemaRule rule = (DataSchemaRule)this.backend.get(i);
            if (!(rule instanceof DirectFieldSelectorRule)) continue;
            retval.add(rule);
        }
        return retval.toArray(new DirectFieldSelectorRule[retval.size()]);
    }

    public DataSchemaRule[] getRules() {
        return this.backend.toArray(new DataSchemaRule[this.backend.size()]);
    }

    public void merge(DataSchemaDefinition schemaDefinition) {
        if (schemaDefinition == null) {
            throw new NullPointerException();
        }
        GlobalRule[] globalRules = schemaDefinition.getGlobalRules();
        MetaSelectorRule[] indirectRules = schemaDefinition.getIndirectRules();
        DirectFieldSelectorRule[] directRules = schemaDefinition.getDirectRules();
        this.backend.ensureCapacity(this.backend.size() + globalRules.length + indirectRules.length + directRules.length);
        this.backend.addAll(Arrays.asList(globalRules));
        this.backend.addAll(Arrays.asList(indirectRules));
        this.backend.addAll(Arrays.asList(directRules));
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultDataSchemaDefinition def = (DefaultDataSchemaDefinition)super.clone();
        def.backend = (ArrayList)this.backend.clone();
        return def;
    }
}

