/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.wizard;

import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeReferences;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaRule;
import org.pentaho.reporting.engine.classic.core.wizard.MetaSelector;

public class MetaSelectorRule
implements DataSchemaRule {
    private MetaSelector[] selectors;
    private DataAttributes attributes;
    private DataAttributeReferences references;

    public MetaSelectorRule(MetaSelector[] selectors, DataAttributes attributes, DataAttributeReferences references) {
        if (selectors == null) {
            throw new NullPointerException();
        }
        if (attributes == null) {
            throw new NullPointerException();
        }
        if (references == null) {
            throw new NullPointerException();
        }
        this.attributes = attributes;
        this.references = references;
        this.selectors = (MetaSelector[])selectors.clone();
    }

    public DataAttributes getStaticAttributes() {
        return this.attributes;
    }

    public MetaSelector[] getSelectors() {
        return (MetaSelector[])this.selectors.clone();
    }

    public DataAttributeReferences getMappedAttributes() {
        return this.references;
    }

    public boolean isMatch(DataAttributes dataAttributes, DataAttributeContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (dataAttributes == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.selectors.length; ++i) {
            Object attrValue;
            MetaSelector selector = this.selectors[i];
            String domain = selector.getDomain();
            String name = selector.getName();
            Object value = selector.getValue();
            if (!(value == null ? dataAttributes.getMetaAttribute(domain, name, null, context) == null : !value.equals(attrValue = dataAttributes.getMetaAttribute(domain, name, null, context)))) continue;
            return false;
        }
        return true;
    }
}

