/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.wizard;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.states.datarow.DefaultFlowController;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.wizard.AutoGeneratorUtility;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeContext;

public class RelationalAutoGeneratorPreProcessor
implements ReportPreProcessor {
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public MasterReport performPreProcessing(MasterReport definition, DefaultFlowController flowController) throws ReportProcessingException {
        if (definition == null) {
            throw new NullPointerException();
        }
        if (flowController == null) {
            throw new NullPointerException();
        }
        try {
            MasterReport report = (MasterReport)definition.clone();
            this.generate(report, flowController);
            return report;
        }
        catch (CloneNotSupportedException e) {
            throw new ReportProcessingException("Unable to derive a working copy", e);
        }
    }

    protected void generate(AbstractReportDefinition definition, DefaultFlowController flowController) throws ReportProcessingException {
        DataSchema dataSchema;
        Band details = AutoGeneratorUtility.findGeneratedContent(definition.getItemBand());
        Band header = AutoGeneratorUtility.findGeneratedContent(definition.getDetailsHeader());
        Band footer = AutoGeneratorUtility.findGeneratedContent(definition.getDetailsFooter());
        ProcessingContext reportContext = flowController.getReportContext();
        DefaultDataAttributeContext dac = new DefaultDataAttributeContext(reportContext.getOutputProcessorMetaData(), reportContext.getResourceBundleFactory().getLocale());
        DataRow dataRow = flowController.getMasterRow().getGlobalView();
        AutoGeneratorFieldDescription[] fieldDescriptions = this.computeFields(dataRow, dataSchema = flowController.getMasterRow().getDataSchema(), dac);
        if (fieldDescriptions == null || fieldDescriptions.length == 0) {
            return;
        }
        if (details != null) {
            details.clear();
            details.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, "row");
        }
        if (header != null) {
            header.clear();
            header.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, "row");
        }
        if (footer != null) {
            footer.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, "row");
            footer.clear();
        }
        float[] widths = this.computeFieldWidths(fieldDescriptions, definition.getPageDefinition().getWidth());
        for (int i = 0; i < fieldDescriptions.length; ++i) {
            AutoGeneratorFieldDescription fieldDescription = fieldDescriptions[i];
            if (header != null) {
                Element headerElement = AutoGeneratorUtility.generateHeaderElement(fieldDescription.getFieldName());
                ElementStyleSheet headerStyle = headerElement.getStyle();
                headerStyle.setStyleProperty(ElementStyleKeys.MIN_WIDTH, new Float(widths[i]));
                header.addElement(headerElement);
            }
            if (details == null) continue;
            Element detailsElement = AutoGeneratorUtility.generateDetailsElement(fieldDescription.getFieldName(), fieldDescription.getTargetType());
            if (Boolean.TRUE.equals(fieldDescription.getHideDuplicateValues())) {
                detailsElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "only-show-changing-values", Boolean.TRUE);
            }
            ElementStyleSheet detailsStyle = detailsElement.getStyle();
            detailsStyle.setStyleProperty(ElementStyleKeys.MIN_WIDTH, new Float(widths[i]));
            details.addElement(detailsElement);
        }
    }

    private float[] computeFieldWidths(AutoGeneratorFieldDescription[] fieldDescriptions, float pageWidth) {
        Float[] widths = new Float[fieldDescriptions.length];
        for (int i = 0; i < fieldDescriptions.length; ++i) {
            float value;
            AutoGeneratorFieldDescription description = fieldDescriptions[i];
            Number number = description.getWidthHint();
            if (number == null || !((value = number.floatValue()) > 0.0f)) continue;
            widths[i] = new Float(value);
        }
        float[] fieldWidths = AutoGeneratorUtility.computeFieldWidths(widths, pageWidth);
        float total = 0.0f;
        for (int i = 0; i < fieldWidths.length; ++i) {
            total += fieldWidths[i];
        }
        float scale = (float)(fieldWidths[0] < 0.0f ? -100.0 : 100.0);
        for (int i = 0; i < fieldWidths.length; ++i) {
            fieldWidths[i] = scale * (fieldWidths[i] / total);
        }
        return fieldWidths;
    }

    private AutoGeneratorFieldDescription[] computeFields(DataRow dataRow, DataSchema dataSchema, DataAttributeContext context) {
        ArrayList<AutoGeneratorFieldDescription> fields = new ArrayList<AutoGeneratorFieldDescription>();
        String[] columnNames = dataRow.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            String name = columnNames[i];
            DataAttributes attributes = dataSchema.getAttributes(name);
            if (attributes == null || AutoGeneratorUtility.isIgnorable(attributes, context)) continue;
            Number width = AutoGeneratorUtility.createFieldWidth(attributes, context);
            String fieldName = AutoGeneratorUtility.createFieldName(attributes, context);
            ElementType targetType = AutoGeneratorUtility.createFieldType(attributes, context);
            Boolean hideDuplicateItems = (Boolean)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/formatting", "hide-duplicate-items", Number.class, context);
            fields.add(new AutoGeneratorFieldDescription(fieldName, targetType, width, hideDuplicateItems));
        }
        return fields.toArray(new AutoGeneratorFieldDescription[fields.size()]);
    }

    public SubReport performPreProcessing(SubReport definition, DefaultFlowController flowController) throws ReportProcessingException {
        if (definition == null) {
            throw new NullPointerException();
        }
        if (flowController == null) {
            throw new NullPointerException();
        }
        try {
            SubReport report = (SubReport)definition.clone();
            this.generate(report, flowController);
            return report;
        }
        catch (CloneNotSupportedException e) {
            throw new ReportProcessingException("Unable to derive a working copy", e);
        }
    }

    private static class AutoGeneratorFieldDescription {
        private String fieldName;
        private ElementType targetType;
        private Number widthHint;
        private Boolean hideDuplicateValues;

        public AutoGeneratorFieldDescription(String fieldName, ElementType targetType, Number widthHint, Boolean hideDuplicateValues) {
            this.fieldName = fieldName;
            this.targetType = targetType;
            this.widthHint = widthHint;
            this.hideDuplicateValues = hideDuplicateValues;
        }

        public Boolean getHideDuplicateValues() {
            return this.hideDuplicateValues;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public ElementType getTargetType() {
            return this.targetType;
        }

        public Number getWidthHint() {
            return this.widthHint;
        }
    }
}

