/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.wizard.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.layout.output.GenericOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaDefinition;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaRule;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DirectFieldSelectorRule;
import org.pentaho.reporting.engine.classic.core.wizard.GlobalRule;
import org.pentaho.reporting.engine.classic.core.wizard.MetaSelector;
import org.pentaho.reporting.engine.classic.core.wizard.MetaSelectorRule;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class StandaloneDataSchemaWriter {
    private static final Log logger = LogFactory.getLog(StandaloneDataSchemaWriter.class);
    private DataAttributeContext context = new DefaultDataAttributeContext(new GenericOutputProcessorMetaData(), Locale.US);

    public void write(DataSchemaDefinition definition, OutputStream outputStream, String encoding) throws IOException {
        if (definition == null) {
            throw new NullPointerException();
        }
        if (outputStream == null) {
            throw new NullPointerException();
        }
        if (encoding == null) {
            throw new NullPointerException();
        }
        XmlWriter writer = new XmlWriter((Writer)new OutputStreamWriter(outputStream, encoding), (TagDescription)new DefaultTagDescription(ClassicEngineBoot.getInstance().getGlobalConfig(), "org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer."));
        writer.writeXmlDeclaration(encoding);
        AttributeList rootAttributes = new AttributeList();
        rootAttributes.addNamespaceDeclaration("", "http://reporting.pentaho.org/namespaces/engine/classic/dataschema/1.0");
        rootAttributes.addNamespaceDeclaration("core", "http://reporting.pentaho.org/namespaces/engine/meta-attributes/core");
        rootAttributes.addNamespaceDeclaration("database", "http://reporting.pentaho.org/namespaces/engine/meta-attributes/database");
        rootAttributes.addNamespaceDeclaration("expressions", "http://reporting.pentaho.org/namespaces/engine/meta-attributes/expressions");
        rootAttributes.addNamespaceDeclaration("formatting", "http://reporting.pentaho.org/namespaces/engine/meta-attributes/formatting");
        rootAttributes.addNamespaceDeclaration("numeric", "http://reporting.pentaho.org/namespaces/engine/meta-attributes/numeric");
        rootAttributes.addNamespaceDeclaration("style", "http://reporting.pentaho.org/namespaces/engine/meta-attributes/style");
        writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/dataschema/1.0", "data-schema", rootAttributes, false);
        GlobalRule[] globalRules = definition.getGlobalRules();
        MetaSelectorRule[] indirectRules = definition.getIndirectRules();
        DirectFieldSelectorRule[] directRules = definition.getDirectRules();
        try {
            DataSchemaRule rule;
            int i;
            for (i = 0; i < globalRules.length; ++i) {
                rule = globalRules[i];
                if (!(rule instanceof GlobalRule)) continue;
                writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/dataschema/1.0", "global-mapping", false);
                this.writeAttributes(writer, rule.getStaticAttributes());
                writer.writeCloseTag();
            }
            for (i = 0; i < indirectRules.length; ++i) {
                rule = indirectRules[i];
                if (!(rule instanceof MetaSelectorRule)) continue;
                MetaSelectorRule selectorRule = (MetaSelectorRule)rule;
                writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/dataschema/1.0", "indirect-mapping", false);
                MetaSelector[] selectors = selectorRule.getSelectors();
                for (int j = 0; j < selectors.length; ++j) {
                    MetaSelector selector = selectors[j];
                    AttributeList selectorAttributeList = new AttributeList();
                    selectorAttributeList.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/dataschema/1.0", "domain", selector.getDomain());
                    selectorAttributeList.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/dataschema/1.0", "name", selector.getName());
                    String stringValue = ConverterRegistry.toAttributeValue(selector.getValue());
                    selectorAttributeList.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/dataschema/1.0", "value", stringValue);
                    writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/dataschema/1.0", "match", selectorAttributeList, true);
                }
                this.writeAttributes(writer, rule.getStaticAttributes());
                writer.writeCloseTag();
            }
            for (i = 0; i < directRules.length; ++i) {
                rule = directRules[i];
                if (!(rule instanceof DirectFieldSelectorRule)) continue;
                DirectFieldSelectorRule fieldSelectorRule = (DirectFieldSelectorRule)rule;
                writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/dataschema/1.0", "direct-mapping", "fieldame", fieldSelectorRule.getFieldName(), false);
                this.writeAttributes(writer, rule.getStaticAttributes());
                writer.writeCloseTag();
            }
        }
        catch (BeanException e) {
            logger.warn((Object)"Failed to write data-schema: Reason: ", (Throwable)((Object)e));
            throw new IOException("Failed to write declared data-schema attribute");
        }
        writer.writeCloseTag();
        writer.flush();
    }

    private void writeAttributes(XmlWriter writer, DataAttributes attributes) throws BeanException, IOException {
        AttributeList attributeList = new AttributeList();
        String[] domains = attributes.getMetaAttributeDomains();
        for (int i = 0; i < domains.length; ++i) {
            String domain = domains[i];
            String[] names = attributes.getMetaAttributeNames(domain);
            for (int j = 0; j < names.length; ++j) {
                String name = names[j];
                Object value = attributes.getMetaAttribute(domain, name, null, this.context);
                String stringValue = ConverterRegistry.toAttributeValue(value);
                attributeList.setAttribute(domain, name, stringValue);
            }
        }
        writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/dataschema/1.0", "column-attributes", attributeList, true);
    }
}

