/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.metadata.mqleditor;

import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Operator implements Serializable
{
    GREATER_THAN(">", 1, true),
    LESS_THAN("<", 1, true),
    EQUAL("=", 1, true),
    GREATOR_OR_EQUAL(">=", 1, true),
    LESS_OR_EQUAL("<=", 1, true),
    EXACTLY_MATCHES("exactly matches", 0, true),
    CONTAINS("contains", 0, true),
    DOES_NOT_CONTAIN("does not contain", 0, true),
    BEGINS_WITH("begins with", 0, true),
    ENDS_WITH("ends with", 0, true),
    IS_NULL("is null", 2, false),
    IS_NOT_NULL("is not null", 2, false),
    IN("in", 0, true),
    NOT_EQUAL("<>", 1, true);

    private String strVal;
    private int operatorType;
    private boolean requiresValue;

    private Operator(String str, int operatorType, boolean requiresValue) {
        this.strVal = str;
        this.operatorType = operatorType;
        this.requiresValue = requiresValue;
    }

    public String toString() {
        return this.strVal;
    }

    public int getOperatorType() {
        return this.operatorType;
    }

    public boolean getRequiresValue() {
        return this.requiresValue;
    }

    public static Operator parse(String val) {
        if (val == null || val.equals("")) {
            return EQUAL;
        }
        if (val.equals(">")) {
            return GREATER_THAN;
        }
        if (val.equals(">=")) {
            return GREATOR_OR_EQUAL;
        }
        if (val.equals("=")) {
            return EQUAL;
        }
        if (val.equals("<")) {
            return LESS_THAN;
        }
        if (val.equals("<=")) {
            return LESS_OR_EQUAL;
        }
        if (val.equals("<>")) {
            return NOT_EQUAL;
        }
        if (val.equals("exactly matches")) {
            return EXACTLY_MATCHES;
        }
        if (val.equals("contains")) {
            return CONTAINS;
        }
        if (val.equals("does not contain")) {
            return DOES_NOT_CONTAIN;
        }
        if (val.equals("begins with")) {
            return BEGINS_WITH;
        }
        if (val.equals("ends with")) {
            return ENDS_WITH;
        }
        if (val.equals("is null")) {
            return IS_NULL;
        }
        if (val.equals("is not null")) {
            return IS_NOT_NULL;
        }
        if (val.equals("in")) {
            return IN;
        }
        if (val.equals("CONTAINS")) {
            return CONTAINS;
        }
        if (val.equals("BEGINSWITH")) {
            return BEGINS_WITH;
        }
        if (val.equals("ENDSWITH")) {
            return ENDS_WITH;
        }
        if (val.equals("ISNA")) {
            return IS_NULL;
        }
        if (val.equals("IN")) {
            return IN;
        }
        return EQUAL;
    }

    public boolean requiresValue() {
        return this.requiresValue;
    }

    public static Operator[] values(boolean stringType) {
        Operator[] vals = Operator.values();
        ArrayList<Operator> ops = new ArrayList<Operator>();
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i].operatorType == 2) {
                ops.add(vals[i]);
                continue;
            }
            if (vals[i].operatorType == 0 && stringType) {
                ops.add(vals[i]);
                continue;
            }
            if (vals[i].operatorType != 1 || stringType) continue;
            ops.add(vals[i]);
        }
        return ops.toArray(new Operator[0]);
    }
}

