/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.metadata.mqleditor.editor.controllers;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.commons.metadata.mqleditor.beans.Query;
import org.pentaho.commons.metadata.mqleditor.editor.MQLEditorService;
import org.pentaho.commons.metadata.mqleditor.editor.MqlDialogListener;
import org.pentaho.commons.metadata.mqleditor.editor.models.UIColumn;
import org.pentaho.commons.metadata.mqleditor.editor.models.UIColumns;
import org.pentaho.commons.metadata.mqleditor.editor.models.UIDomain;
import org.pentaho.commons.metadata.mqleditor.editor.models.UIModel;
import org.pentaho.commons.metadata.mqleditor.editor.models.Workspace;
import org.pentaho.ui.xul.XulServiceCallback;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

public class MainController
extends AbstractXulEventHandler {
    public static final int CANCELLED = 0;
    public static final int OK = 1;
    private int lastClicked = 0;
    private static XulDialog errorDialog;
    private XulMenuList modelList;
    private XulMenuList domainList;
    private XulTree categoryTree;
    private XulButton acceptButton;
    private Workspace workspace;
    private XulTree fieldTable;
    private XulTree conditionsTable;
    private XulTree ordersTable;
    private XulTextbox limit;
    private XulDialog dialog;
    private MQLEditorService service;
    private List<MqlDialogListener> listeners = new ArrayList<MqlDialogListener>();
    private Query savedQuery;
    BindingFactory bf;

    public boolean getOkClicked() {
        return this.lastClicked == 1;
    }

    public void setSavedQuery(Query savedQuery) {
        this.savedQuery = savedQuery;
        if (savedQuery == null) {
            this.clearWorkspace();
        }
        if (savedQuery != null) {
            this.workspace.wrap(savedQuery);
        }
    }

    @Bindable
    public void init() {
        this.createBindings();
    }

    public void showDialog() {
        this.dialog.show();
    }

    public void clearWorkspace() {
        this.workspace.clear();
    }

    private void createBindings() {
        this.modelList = (XulMenuList)this.document.getElementById("modelList");
        this.domainList = (XulMenuList)this.document.getElementById("domainList");
        this.categoryTree = (XulTree)this.document.getElementById("categoryTree");
        this.conditionsTable = (XulTree)this.document.getElementById("conditionsTree");
        this.ordersTable = (XulTree)this.document.getElementById("orderTable");
        this.fieldTable = (XulTree)this.document.getElementById("selectedColumnTree");
        this.dialog = (XulDialog)this.document.getElementById("mqlEditorDialog");
        this.limit = (XulTextbox)this.document.getElementById("limit");
        this.acceptButton = (XulButton)this.document.getElementById("mqlEditorDialog_accept");
        errorDialog = (XulDialog)this.document.getElementById("errorDialog");
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        Binding acceptButtonBinding = this.bf.createBinding((Object)this.workspace, "selections", (Object)this.acceptButton, "!disabled", new BindingConvertor[]{new BindingConvertor<List<UIColumns>, Boolean>(){

            public Boolean sourceToTarget(List<UIColumns> value) {
                return value != null && !value.isEmpty();
            }

            public List<UIColumns> targetToSource(Boolean value) {
                return null;
            }
        }});
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        Binding domainBinding = this.bf.createBinding((Object)this.workspace, "domains", (Object)this.domainList, "elements", new BindingConvertor[0]);
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bf.createBinding((Object)this.domainList, "selectedIndex", (Object)this.workspace, "selectedDomain", new BindingConvertor[]{new BindingConvertor<Integer, UIDomain>(){

            public UIDomain sourceToTarget(Integer value) {
                if (value < 0 || value > MainController.this.workspace.getDomains().size()) {
                    return null;
                }
                return MainController.this.workspace.getDomains().get(value);
            }

            public Integer targetToSource(UIDomain value) {
                return MainController.this.workspace.getDomains().indexOf(value);
            }
        }});
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        Binding domainToList = this.bf.createBinding((Object)this.workspace, "selectedDomain", (Object)this.modelList, "elements", new BindingConvertor[]{new BindingConvertor<UIDomain, List<UIModel>>(){

            public List<UIModel> sourceToTarget(UIDomain value) {
                return value.getModels();
            }

            public UIDomain targetToSource(List<UIModel> value) {
                return null;
            }
        }});
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        Binding modelToList = this.bf.createBinding((Object)this.workspace, "selectedModel", (Object)this.modelList, "selectedIndex", new BindingConvertor[]{new BindingConvertor<UIModel, Integer>(){

            public Integer sourceToTarget(UIModel value) {
                return MainController.this.workspace.getSelectedDomain().getModels().indexOf(value);
            }

            public UIModel targetToSource(Integer value) {
                if (value < 0) {
                    return null;
                }
                return MainController.this.workspace.getSelectedDomain().getModels().get(value);
            }
        }});
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.workspace, "categories", (Object)this.categoryTree, "elements", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.categoryTree, "absoluteSelectedRows", (Object)this.workspace, "selectedColumns", new BindingConvertor[]{new BindingConvertor<int[], List<UIColumn>>(){

            public List<UIColumn> sourceToTarget(int[] array) {
                if (array.length == 0) {
                    return null;
                }
                int value = array[0];
                if (value < 0) {
                    return null;
                }
                return MainController.this.workspace.getColumnsByPos(array);
            }

            public int[] targetToSource(List<UIColumn> value) {
                int[] positions = new int[value.size()];
                int i = 0;
                for (UIColumn col : value) {
                    positions[i++] = MainController.this.workspace.getSelectedCategory().getChildren().indexOf(col);
                }
                return positions;
            }
        }});
        this.bf.createBinding((Object)this.workspace, "selections", (Object)this.fieldTable, "elements", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.workspace, "conditions", (Object)this.conditionsTable, "elements", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.workspace, "orders", (Object)this.ordersTable, "elements", new BindingConvertor[0]);
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bf.createBinding((Object)this.workspace, "limit", (Object)this.limit, "value", new BindingConvertor[]{new BindingConvertor<Integer, String>(){

            public String sourceToTarget(Integer value) {
                if (value > -1) {
                    return value.toString();
                }
                return "";
            }

            public Integer targetToSource(String value) {
                try {
                    if (value.isEmpty()) {
                        return -1;
                    }
                    Integer returnInteger = Integer.parseInt(value);
                    return returnInteger;
                }
                catch (NumberFormatException nfe) {
                    return MainController.this.workspace.getLimit();
                }
            }
        }});
        try {
            domainBinding.fireSourceChanged();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    @Bindable
    public void moveSelectionToFields() {
        List<UIColumn> cols = this.workspace.getSelectedColumns();
        for (UIColumn col : cols) {
            this.workspace.addColumn((UIColumn)col.clone());
        }
    }

    @Bindable
    public void moveSelectionToConditions() {
        List<UIColumn> cols = this.workspace.getSelectedColumns();
        for (UIColumn col : cols) {
            this.workspace.addCondition(col);
        }
    }

    @Bindable
    public void moveSelectionToOrders() {
        List<UIColumn> cols = this.workspace.getSelectedColumns();
        for (UIColumn col : cols) {
            if (this.workspace.getOrders().contains(col)) continue;
            this.workspace.addOrder(col);
        }
    }

    public void setBindingFactory(BindingFactory bf) {
        this.bf = bf;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public String getName() {
        return "mainController";
    }

    @Bindable
    public void closeDialog() {
        this.lastClicked = 0;
        this.dialog.hide();
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onDialogCancel();
        }
    }

    @Bindable
    public void saveQuery() {
        this.lastClicked = 1;
        this.service.saveQuery(this.workspace.getMqlQuery(), new XulServiceCallback<String>(){

            public void error(String message, Throwable error) {
                System.out.println(message);
                error.printStackTrace();
            }

            public void success(String retVal) {
                try {
                    XulMessageBox box = (XulMessageBox)MainController.this.document.createElement("messagebox");
                    box.setTitle("Mql Query");
                    retVal = retVal.replace("><", ">\n<");
                    box.setMessage(retVal);
                }
                catch (Exception e) {
                    // empty catch block
                }
                MainController.this.workspace.setMqlStr(retVal);
                MainController.this.dialog.hide();
                for (MqlDialogListener listener : MainController.this.listeners) {
                    listener.onDialogAccept(MainController.this.workspace.getMqlQuery());
                }
                System.out.println(retVal);
            }
        });
    }

    public MQLEditorService getService() {
        return this.service;
    }

    public void setService(MQLEditorService service) {
        this.service = service;
    }

    public void addMqlDialogListener(MqlDialogListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeMqlDialogListener(MqlDialogListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    @Bindable
    public static void showErrorDialog(String message) {
        if (errorDialog == null) {
            throw new IllegalStateException("Error dialog has not been loaded yet");
        }
        XulLabel msg = (XulLabel)errorDialog.getElementById("errorLabel");
        msg.setValue(message);
        errorDialog.show();
    }

    @Bindable
    public static void closeErrorDialog(String message) {
        if (errorDialog == null) {
            throw new IllegalStateException("Error dialog has not been loaded yet");
        }
        errorDialog.hide();
    }
}

