/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.metadata.mqleditor.editor.gwt;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Window;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.XMLParser;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.commons.metadata.mqleditor.MqlDomain;
import org.pentaho.commons.metadata.mqleditor.beans.Domain;
import org.pentaho.commons.metadata.mqleditor.beans.Query;
import org.pentaho.commons.metadata.mqleditor.editor.MQLEditorService;
import org.pentaho.commons.metadata.mqleditor.editor.MqlDialogListener;
import org.pentaho.commons.metadata.mqleditor.editor.controllers.ConditionsController;
import org.pentaho.commons.metadata.mqleditor.editor.controllers.MainController;
import org.pentaho.commons.metadata.mqleditor.editor.controllers.OrderController;
import org.pentaho.commons.metadata.mqleditor.editor.controllers.PreviewController;
import org.pentaho.commons.metadata.mqleditor.editor.controllers.SelectedColumnController;
import org.pentaho.commons.metadata.mqleditor.editor.models.UIDomain;
import org.pentaho.commons.metadata.mqleditor.editor.models.Workspace;
import org.pentaho.gwt.widgets.client.utils.i18n.IResourceBundleLoadCallback;
import org.pentaho.gwt.widgets.client.utils.i18n.ResourceBundle;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulServiceCallback;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.gwt.GwtXulDomContainer;
import org.pentaho.ui.xul.gwt.GwtXulLoader;
import org.pentaho.ui.xul.gwt.GwtXulRunner;
import org.pentaho.ui.xul.gwt.binding.GwtBindingFactory;
import org.pentaho.ui.xul.gwt.util.AsyncConstructorListener;
import org.pentaho.ui.xul.impl.XulEventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GwtMqlEditor
implements IResourceBundleLoadCallback {
    private ResourceBundle bundle;
    private MainController mainController = new MainController();
    private Workspace workspace = new Workspace();
    private GwtXulDomContainer container;
    private SelectedColumnController selectedColumnController = new SelectedColumnController();
    private ConditionsController constraintController = new ConditionsController();
    private OrderController orderController = new OrderController();
    private PreviewController previewController = new PreviewController();
    private AsyncConstructorListener constructorListener;
    private List<MqlDialogListener> listeners = new ArrayList<MqlDialogListener>();
    private MQLEditorService service;

    public GwtMqlEditor(MQLEditorService service, AsyncConstructorListener<GwtMqlEditor> constructorListener) {
        this.mainController.setWorkspace(this.workspace);
        this.selectedColumnController.setWorkspace(this.workspace);
        this.constraintController.setWorkspace(this.workspace);
        this.orderController.setWorkspace(this.workspace);
        this.previewController.setWorkspace(this.workspace);
        this.constructorListener = constructorListener;
        this.setService(service);
    }

    public void setSelectedDomainId(String domainId) {
        this.workspace.setSelectedDomainId(domainId);
    }

    public void setSelectedModelId(String modelId) {
        this.workspace.setSelectedModelId(modelId);
    }

    public void setSavedQuery(Query savedQuery) {
        this.mainController.setSavedQuery(savedQuery);
    }

    public String getMqlQuery() {
        return this.workspace.getMqlStr();
    }

    public void show() {
        this.workspace.setSelectedColumn(null);
        this.mainController.showDialog();
    }

    public void hide() {
        XulDialog dialog = (XulDialog)this.container.getDocumentRoot().getElementById("mqlEditorDialog");
        dialog.hide();
    }

    public void addMqlDialogListener(MqlDialogListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        this.mainController.addMqlDialogListener(listener);
    }

    public void removeMqlDialogListener(MqlDialogListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
        this.mainController.removeMqlDialogListener(listener);
    }

    private void loadContainer(String xul) {
        try {
            if (xul == null || xul.indexOf("there.is.only.xul") < 0) {
                Window.alert((String)"Error loading XUL Application. Your session may have timed out.");
            }
            GwtXulLoader loader = new GwtXulLoader();
            Document gwtDoc = XMLParser.parse((String)xul);
            this.container = this.bundle != null ? loader.loadXul((Object)gwtDoc, (Object)this.bundle) : loader.loadXul((Object)gwtDoc);
            try {
                RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, GWT.getModuleBaseURL() + "mainFrame-gwt-overlay.xul");
                try {
                    Request response = builder.sendRequest(null, new RequestCallback(){

                        public void onError(Request request, Throwable exception) {
                        }

                        public void onResponseReceived(Request request, Response response) {
                            GwtMqlEditor.this.loadOverlay(response.getText());
                        }
                    });
                }
                catch (RequestException e) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            Window.alert((String)("Error Loading MQLEditor Xul file: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    private void loadOverlay(String xul) {
        Document gwtDoc = XMLParser.parse((String)xul);
        try {
            this.container.loadOverlay(gwtDoc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.displayXulDialog();
    }

    private void displayXulDialog() {
        try {
            GwtXulRunner runner = new GwtXulRunner();
            GwtBindingFactory bf = new GwtBindingFactory(this.container.getDocumentRoot());
            this.mainController.setBindingFactory((BindingFactory)bf);
            this.container.addEventHandler((XulEventHandler)this.mainController);
            this.constraintController.setBindingFactory((BindingFactory)bf);
            this.container.addEventHandler((XulEventHandler)this.constraintController);
            this.selectedColumnController.setBindingFactory((BindingFactory)bf);
            this.container.addEventHandler((XulEventHandler)this.selectedColumnController);
            this.orderController.setBindingFactory((BindingFactory)bf);
            this.container.addEventHandler((XulEventHandler)this.orderController);
            this.previewController.setBindingFactory((BindingFactory)bf);
            this.container.addEventHandler((XulEventHandler)this.previewController);
            runner.addContainer((XulDomContainer)this.container);
            runner.initialize();
            runner.start();
            if (this.constructorListener != null) {
                this.constructorListener.asyncConstructorDone((Object)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public void updateDomainList() {
        this.service.refreshMetadataDomains(new XulServiceCallback<List<MqlDomain>>(){

            public void error(String message, Throwable error) {
                Window.alert((String)"could not get list of metadata domains");
            }

            public void success(List<MqlDomain> domains) {
                GwtMqlEditor.this.updateDomains(domains);
                for (MqlDialogListener listener : GwtMqlEditor.this.listeners) {
                    listener.onDialogReady();
                }
            }
        });
    }

    public void loadDomainById(final String domainId) {
        this.service.getDomainByName(domainId, new XulServiceCallback<MqlDomain>(){

            public void success(MqlDomain mqlDomain) {
                if (mqlDomain != null) {
                    ArrayList<MqlDomain> domains = new ArrayList<MqlDomain>();
                    domains.add(mqlDomain);
                    GwtMqlEditor.this.updateDomains(domains);
                    for (MqlDialogListener listener : GwtMqlEditor.this.listeners) {
                        listener.onDialogReady();
                    }
                } else {
                    Window.alert((String)("could not find the requested domain - " + domainId));
                }
            }

            public void error(String s, Throwable throwable) {
                Window.alert((String)("could not find the requested domain - " + domainId));
            }
        });
    }

    private void setService(MQLEditorService service) {
        this.service = service;
        this.previewController.setService(service);
        this.mainController.setService(service);
        for (MqlDialogListener listener : this.listeners) {
            listener.onDialogReady();
        }
        try {
            this.bundle = new ResourceBundle(GWT.getModuleBaseURL(), "mainFrame", true, (IResourceBundleLoadCallback)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateDomains(List<MqlDomain> domains) {
        ArrayList<UIDomain> uiDomains = new ArrayList<UIDomain>();
        for (MqlDomain domain : domains) {
            uiDomains.add(new UIDomain((Domain)domain));
        }
        this.workspace.setDomains(uiDomains);
    }

    public void bundleLoaded(String bundleName) {
        try {
            RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, GWT.getModuleBaseURL() + "mainFrame.xul");
            try {
                Request response = builder.sendRequest(null, new RequestCallback(){

                    public void onError(Request request, Throwable exception) {
                        Window.alert((String)"could not find main Xul file");
                    }

                    public void onResponseReceived(Request request, Response response) {
                        GwtMqlEditor.this.loadContainer(response.getText());
                    }
                });
            }
            catch (RequestException e) {
                Window.alert((String)"could not find main Xul file");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Window.alert((String)"Unknown error loading main Xul file");
        }
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }
}

