/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.metadata.mqleditor.editor.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.pentaho.commons.metadata.mqleditor.editor.models.UIColumn;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.stereotype.Bindable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractModelNode<T>
extends XulEventSourceAdapter
implements List<T>,
Iterable<T> {
    protected List<T> children = new ArrayList<T>();
    protected AbstractModelNode parent;

    public AbstractModelNode() {
    }

    public AbstractModelNode(AbstractModelNode parent, List<T> children) {
        this(children);
        this.setParent(parent);
    }

    public AbstractModelNode(List<T> children) {
        Collections.copy(this.children, children);
    }

    public AbstractModelNode getParent() {
        return this.parent;
    }

    public void setParent(AbstractModelNode parent) {
        this.parent = parent;
    }

    @Bindable
    public List<T> getChildren() {
        return this.children;
    }

    protected void fireCollectionChanged() {
        this.changeSupport.firePropertyChange("children", null, this.getChildren());
    }

    @Override
    public boolean add(T child) {
        boolean retVal = this.children.add(child);
        this.fireCollectionChanged();
        return retVal;
    }

    @Override
    public T remove(int idx) {
        T t = this.children.remove(idx);
        this.fireCollectionChanged();
        return t;
    }

    @Override
    public boolean remove(Object child) {
        if (!this.children.contains(child)) {
            throw new IllegalArgumentException("Child does not exist in collection");
        }
        boolean retVal = this.children.remove(child);
        this.fireCollectionChanged();
        return retVal;
    }

    public T removeModel(int pos) {
        if (pos > this.children.size()) {
            throw new IllegalArgumentException("Specified position (" + pos + ") is greater than collection length");
        }
        T retVal = this.children.remove(pos);
        this.fireCollectionChanged();
        return retVal;
    }

    @Override
    public Iterator<T> iterator() {
        return this.children.iterator();
    }

    @Override
    public void clear() {
        this.children.clear();
        this.fireCollectionChanged();
    }

    public void moveChildUp(UIColumn column) {
        if (!this.children.contains(column)) {
            throw new IllegalArgumentException("child does not exist in collection");
        }
        int pos = this.children.indexOf(column);
        this.moveChildUp(pos);
    }

    public void moveChildUp(int position) {
        if (position - 1 < 0) {
            throw new IllegalArgumentException("Specified position (" + position + ") is greater than child collection length");
        }
        if (position == 0) {
            return;
        }
        T child = this.children.remove(position);
        this.children.add(position - 1, child);
        this.fireCollectionChanged();
    }

    public void moveChildDown(UIColumn column) {
        if (!this.children.contains(column)) {
            throw new IllegalArgumentException("child does not exist in collection");
        }
        int pos = this.children.indexOf(column);
        this.moveChildDown(pos);
    }

    public void moveChildDown(int position) {
        if (position < 0 || position + 1 >= this.children.size()) {
            throw new IllegalArgumentException("Specified position (" + position + ") is greater than child collection length");
        }
        T child = this.children.remove(position);
        this.children.add(position + 1, child);
        this.fireCollectionChanged();
    }

    public List<T> asList() {
        return this.children;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.children.addAll(c);
    }

    @Override
    public boolean contains(Object o) {
        return this.children.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean retval = true;
        for (Object t : c) {
            if (this.children.contains(t)) continue;
            retval = false;
            break;
        }
        return retval;
    }

    @Override
    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean retVal = this.children.removeAll(c);
        this.fireCollectionChanged();
        return retVal;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean retVal = this.children.retainAll(c);
        this.fireCollectionChanged();
        return retVal;
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public Object[] toArray() {
        return this.children.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.children.toArray(a);
    }

    @Override
    public void add(int index, T element) {
        this.children.add(index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.children.addAll(index, c);
    }

    @Override
    public T get(int index) {
        return this.children.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.children.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.children.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.children.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.children.listIterator(index);
    }

    @Override
    public T set(int index, T element) {
        return this.children.set(index, element);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        ArrayList<T> newList = new ArrayList<T>();
        for (int i = fromIndex; i < this.children.size() && i < toIndex; ++i) {
            newList.add(this.children.get(i));
        }
        return newList;
    }
}

