/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.metadata.mqleditor.editor.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.commons.metadata.mqleditor.MqlColumn;
import org.pentaho.commons.metadata.mqleditor.MqlDomain;
import org.pentaho.commons.metadata.mqleditor.MqlModel;
import org.pentaho.commons.metadata.mqleditor.MqlQuery;
import org.pentaho.commons.metadata.mqleditor.beans.Column;
import org.pentaho.commons.metadata.mqleditor.beans.Condition;
import org.pentaho.commons.metadata.mqleditor.beans.Domain;
import org.pentaho.commons.metadata.mqleditor.beans.Model;
import org.pentaho.commons.metadata.mqleditor.beans.Order;
import org.pentaho.commons.metadata.mqleditor.beans.Query;
import org.pentaho.commons.metadata.mqleditor.editor.models.UICategory;
import org.pentaho.commons.metadata.mqleditor.editor.models.UIColumn;
import org.pentaho.commons.metadata.mqleditor.editor.models.UIColumns;
import org.pentaho.commons.metadata.mqleditor.editor.models.UICondition;
import org.pentaho.commons.metadata.mqleditor.editor.models.UIConditions;
import org.pentaho.commons.metadata.mqleditor.editor.models.UIDomain;
import org.pentaho.commons.metadata.mqleditor.editor.models.UIModel;
import org.pentaho.commons.metadata.mqleditor.editor.models.UIOrder;
import org.pentaho.commons.metadata.mqleditor.editor.models.UIOrders;
import org.pentaho.commons.metadata.mqleditor.editor.models.UIQuery;
import org.pentaho.commons.metadata.mqleditor.utils.ModelUtil;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.stereotype.Bindable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workspace
extends XulEventSourceAdapter
implements MqlQuery {
    private UIModel selectedModel;
    private UIDomain selectedDomain;
    private List<UIDomain> domains;
    private List<UICategory> categories;
    private UICategory selectedCategory;
    private UIOrder selectedOrder;
    private int limit;
    private UIColumn selectedColumn;
    private List<UIColumn> selectedColumns = new ArrayList<UIColumn>();
    private UIColumns selections = new UIColumns();
    private UIConditions conditions = new UIConditions();
    private UIOrders orders = new UIOrders();
    private String queryStr;
    private PropertyChangeListener columnListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            Workspace.this.firePropertyChange("selections", null, Workspace.this.getSelections());
        }
    };
    private PropertyChangeListener conditionListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            Workspace.this.firePropertyChange("conditions", null, Workspace.this.getConditions());
        }
    };
    private PropertyChangeListener orderListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            Workspace.this.firePropertyChange("orders", null, Workspace.this.getOrders());
        }
    };

    public Workspace() {
        this.setupListeners();
    }

    public void wrap(Query thinWorkspace) {
        Domain domain = thinWorkspace.getDomain();
        if (domain == null) {
            return;
        }
        for (UIDomain uiDomain : this.domains) {
            if (!uiDomain.getName().equals(domain.getName())) continue;
            this.setSelectedDomain(uiDomain);
            break;
        }
        if (this.selectedDomain == null) {
            return;
        }
        Model model = thinWorkspace.getModel();
        if (model == null) {
            return;
        }
        for (UIModel uiModel : this.selectedDomain.getModels()) {
            if (!uiModel.getId().equals(model.getId())) continue;
            this.setSelectedModel(uiModel);
            break;
        }
        if (this.selectedModel == null) {
            return;
        }
        if (thinWorkspace.getColumns() != null) {
            for (Column col : thinWorkspace.getColumns()) {
                UIColumn c = this.findAndCloneColumn(col);
                if (c != null) {
                    this.selections.add(c);
                    continue;
                }
                System.out.println("could not find column");
            }
        }
        if (thinWorkspace.getOrders() != null) {
            for (Order order : thinWorkspace.getOrders()) {
                UIOrder ord = new UIOrder(order);
                ord.setColumn(this.findAndCloneColumn(order.getColumn()));
                this.orders.add(ord);
            }
        }
        if (thinWorkspace.getConditions() != null) {
            for (Condition condition : thinWorkspace.getConditions()) {
                UICondition cond = new UICondition(condition);
                cond.setColumn(this.findAndCloneColumn(condition.getColumn()));
                this.conditions.add(cond);
            }
        }
        if (thinWorkspace.getLimit() > -1) {
            this.setLimit(thinWorkspace.getLimit());
        }
    }

    @Bindable
    public void clear() {
        this.removeListeners();
        this.selectedColumn = null;
        this.selectedColumns = new ArrayList<UIColumn>();
        this.setOrders(new UIOrders());
        this.setSelections(new UIColumns());
        this.setConditions(new UIConditions());
        this.setLimit(-1);
        this.setupListeners();
    }

    public void setupListeners() {
        this.selections.addPropertyChangeListener("children", this.columnListener);
        this.conditions.addPropertyChangeListener("children", this.conditionListener);
        this.orders.addPropertyChangeListener("children", this.orderListener);
    }

    public void removeListeners() {
        this.selections.removePropertyChangeListener(this.columnListener);
        this.conditions.removePropertyChangeListener(this.conditionListener);
        this.orders.removePropertyChangeListener(this.orderListener);
    }

    private UIColumn findAndCloneColumn(MqlColumn col) {
        for (UICategory cat : this.selectedModel.getCategories()) {
            for (UIColumn c : cat.getBusinessColumns()) {
                if (!c.getId().equals(col.getId())) continue;
                UIColumn column = (UIColumn)c.clone();
                column.setSelectedAggType(col.getSelectedAggType());
                return column;
            }
        }
        return null;
    }

    @Bindable
    public void setSelectedModel(UIModel m) {
        UIModel prevVal = this.selectedModel;
        this.selectedModel = m;
        this.clear();
        this.firePropertyChange("selectedModel", prevVal, this.selectedModel);
        this.firePropertyChange("categories", null, this.getCategories());
    }

    @Bindable
    public UIModel getSelectedModel() {
        return this.selectedModel;
    }

    public UIColumn getColumnByPos(int pos) {
        if (pos < 0 || this.getSelectedModel() == null) {
            return null;
        }
        List children = this.getSelectedModel().getChildren();
        int curpos = 0;
        for (UICategory child : children) {
            if (child.getChildren().size() + 1 + curpos > pos) {
                int posInNode = pos - curpos - 1;
                if (posInNode < 0) {
                    return null;
                }
                return (UIColumn)child.getChildren().get(posInNode);
            }
            curpos += child.getChildren().size() + 1;
        }
        return null;
    }

    public List<UIColumn> getColumnsByPos(int[] positions) {
        ArrayList<UIColumn> cols = new ArrayList<UIColumn>();
        for (int pos : positions) {
            cols.add(this.getColumnByPos(pos));
        }
        return cols;
    }

    @Bindable
    public List<UICategory> getCategories() {
        return this.selectedModel != null ? this.selectedModel.getChildren() : null;
    }

    @Bindable
    public void setCategories(List<UICategory> categories) {
        this.categories = categories;
        this.firePropertyChange("categories", null, this.getCategories());
    }

    @Bindable
    public UICategory getSelectedCategory() {
        return this.selectedCategory;
    }

    @Bindable
    public void setSelectedCategory(UICategory selectedCategory) {
        List<UIColumn> prevColumns = this.getColumns();
        UICategory oldCat = this.selectedCategory;
        this.selectedCategory = selectedCategory;
        this.firePropertyChange("selectedCategory", oldCat, this.selectedCategory);
        this.firePropertyChange("columns", prevColumns, this.getColumns());
    }

    @Bindable
    public void setSelectedOrder(UIOrder selectedOrder) {
        UIOrder prevOrder = this.selectedOrder;
        this.selectedOrder = selectedOrder;
        this.firePropertyChange("selectedOrder", prevOrder, this.selectedOrder);
    }

    public List<UIColumn> getColumns() {
        return this.selectedCategory != null ? this.selectedCategory.getChildren() : null;
    }

    @Bindable
    public UIColumn getSelectedColumn() {
        return this.selectedColumn;
    }

    @Bindable
    public void setSelectedColumn(UIColumn selectedColumn) {
        UIColumn prevColumn = this.selectedColumn;
        this.selectedColumn = selectedColumn;
        this.firePropertyChange("selectedColumn", prevColumn, this.getSelectedColumn());
    }

    public void addColumn(UIColumn col) {
        this.selections.add(col);
    }

    public void addCondition(UIColumn col) {
        UICondition condition = new UICondition();
        condition.setColumn(col);
        this.conditions.add(condition);
    }

    public void addOrder(UIColumn col) {
        UIOrder order = new UIOrder();
        order.setColumn(col);
        this.orders.add(order);
    }

    @Bindable
    public UIColumns getSelections() {
        return this.selections;
    }

    @Bindable
    public void setSelections(UIColumns columns) {
        this.selections = columns;
        this.firePropertyChange("selections", null, this.getSelections());
    }

    @Bindable
    public void setSelectedColumns(List<UIColumn> selectedColumns) {
        List<UIColumn> prevSelected = this.selectedColumns;
        this.selectedColumns = selectedColumns;
        this.firePropertyChange("selectedColumns", prevSelected, selectedColumns);
    }

    @Bindable
    public List<UIColumn> getSelectedColumns() {
        return this.selectedColumns;
    }

    @Bindable
    public UIConditions getConditions() {
        return this.conditions;
    }

    @Bindable
    public void setConditions(UIConditions conditions) {
        this.conditions = conditions;
        this.firePropertyChange("conditions", null, this.getConditions());
    }

    @Bindable
    public UIOrders getOrders() {
        return this.orders;
    }

    @Bindable
    public void setOrders(UIOrders orders) {
        this.orders = orders;
        this.firePropertyChange("orders", null, this.getOrders());
    }

    @Override
    @Bindable
    public MqlModel getModel() {
        return this.selectedModel;
    }

    @Bindable
    protected void setModel(UIModel model) {
        this.selectedModel = model;
    }

    @Bindable
    public UIDomain getSelectedDomain() {
        return this.selectedDomain;
    }

    @Bindable
    public void setSelectedDomain(UIDomain selectedDomain) {
        UIDomain prevDomain = this.selectedDomain;
        this.selectedDomain = selectedDomain;
        this.clear();
        this.firePropertyChange("selectedDomain", prevDomain, selectedDomain);
    }

    @Override
    @Bindable
    public MqlDomain getDomain() {
        return this.selectedDomain;
    }

    public MqlQuery getMqlQuery() {
        UIQuery query = new UIQuery();
        ArrayList<UIColumn> cols = new ArrayList<UIColumn>();
        ArrayList<UIOrder> orders = new ArrayList<UIOrder>();
        ArrayList<UICondition> conditions = new ArrayList<UICondition>();
        for (UIColumn col : this.selections) {
            cols.add(col);
        }
        for (UIOrder order : this.orders) {
            orders.add(order);
        }
        for (UICondition condition : this.conditions) {
            conditions.add(condition);
        }
        query.setColumns(cols);
        query.setOrders(orders);
        query.setConditions(conditions);
        query.setLimit(this.limit);
        query.setMqlStr(this.getMqlStr());
        query.setDomain(this.selectedDomain);
        query.setModel(this.selectedModel);
        return ModelUtil.convertUIModelToBean(query);
    }

    @Override
    public String getMqlStr() {
        return this.queryStr;
    }

    public void setMqlStr(String query) {
        this.queryStr = query;
    }

    @Bindable
    public List<UIDomain> getDomains() {
        return this.domains;
    }

    @Bindable
    public void setDomains(List<UIDomain> domains) {
        List<UIDomain> oldDomains = this.domains;
        this.domains = domains;
        if (oldDomains != domains) {
            this.firePropertyChange("domains", null, domains);
        }
    }

    public void addDomain(UIDomain domain) {
        this.domains.add(domain);
        this.firePropertyChange("domains", null, this.domains);
    }

    @Override
    public Map<String, Object> getDefaultParameterMap() {
        throw new UnsupportedOperationException();
    }

    @Bindable
    public void setSelectedModelId(String modelId) {
        for (UIModel uiModel : this.selectedDomain.getModels()) {
            if (!uiModel.getId().equals(modelId)) continue;
            this.setSelectedModel(uiModel);
            break;
        }
    }

    @Bindable
    public void setSelectedDomainId(String domainId) {
        for (UIDomain uiDomain : this.domains) {
            if (!uiDomain.getName().equals(domainId)) continue;
            this.setSelectedDomain(uiDomain);
            break;
        }
    }

    @Bindable
    public void setLimit(int limit) {
        this.limit = limit;
        this.firePropertyChange("limit", null, limit);
    }

    @Override
    @Bindable
    public int getLimit() {
        return this.limit;
    }
}

