/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.metadata.mqleditor.editor.service.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.NotImplementedException;
import org.pentaho.commons.metadata.mqleditor.AggType;
import org.pentaho.commons.metadata.mqleditor.ColumnType;
import org.pentaho.commons.metadata.mqleditor.CombinationType;
import org.pentaho.commons.metadata.mqleditor.MqlCategory;
import org.pentaho.commons.metadata.mqleditor.MqlColumn;
import org.pentaho.commons.metadata.mqleditor.MqlCondition;
import org.pentaho.commons.metadata.mqleditor.MqlDomain;
import org.pentaho.commons.metadata.mqleditor.MqlModel;
import org.pentaho.commons.metadata.mqleditor.MqlOrder;
import org.pentaho.commons.metadata.mqleditor.MqlQuery;
import org.pentaho.commons.metadata.mqleditor.Operator;
import org.pentaho.commons.metadata.mqleditor.beans.Column;
import org.pentaho.commons.metadata.mqleditor.beans.Condition;
import org.pentaho.commons.metadata.mqleditor.beans.Domain;
import org.pentaho.commons.metadata.mqleditor.beans.Model;
import org.pentaho.commons.metadata.mqleditor.editor.service.util.ConditionFormatter;
import org.pentaho.commons.metadata.mqleditor.editor.service.util.FormulaParser;
import org.pentaho.commons.metadata.mqleditor.editor.service.util.OperatorFormatter;
import org.pentaho.commons.metadata.mqleditor.utils.ModelSerializer;
import org.pentaho.commons.metadata.mqleditor.utils.ModelUtil;
import org.pentaho.metadata.model.Category;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.query.model.Constraint;
import org.pentaho.metadata.query.model.Order;
import org.pentaho.metadata.query.model.Parameter;
import org.pentaho.metadata.query.model.Query;
import org.pentaho.metadata.query.model.util.QueryXmlHelper;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.pms.factory.CwmSchemaFactoryInterface;
import org.pentaho.pms.mql.MQLQuery;
import org.pentaho.pms.mql.MQLQueryImpl;
import org.pentaho.pms.mql.OrderBy;
import org.pentaho.pms.mql.Selection;
import org.pentaho.pms.mql.WhereCondition;
import org.pentaho.pms.schema.BusinessCategory;
import org.pentaho.pms.schema.BusinessColumn;
import org.pentaho.pms.schema.BusinessModel;
import org.pentaho.pms.schema.SchemaMeta;
import org.pentaho.pms.schema.concept.types.aggregation.AggregationSettings;
import org.pentaho.pms.util.UniqueList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MQLEditorServiceDelegate {
    private String locale = Locale.getDefault().toString();
    private List<MqlDomain> domains = new ArrayList<MqlDomain>();
    private Set<String> domainNames = new TreeSet<String>();
    private CwmSchemaFactoryInterface factory;
    private IMetadataDomainRepository domainRepository;
    private final ConditionFormatter conditionFormatter = new ConditionFormatter(new OperatorFormatter());
    private Map<String, SchemaMeta> modelIdToSchemaMetaMap = new HashMap<String, SchemaMeta>();

    public MQLEditorServiceDelegate(IMetadataDomainRepository domainRepository) {
        this.domainRepository = domainRepository;
        for (String id : domainRepository.getDomainIds()) {
            if (this.domainNames.contains(id)) continue;
            this.addThinDomain(id);
        }
    }

    public MQLEditorServiceDelegate() {
    }

    protected String getLocale() {
        return this.locale;
    }

    public List<MqlDomain> refreshMetadataDomains() {
        this.domains.clear();
        this.domainNames.clear();
        if (this.domainRepository != null) {
            for (String id : this.domainRepository.getDomainIds()) {
                if (this.domainNames.contains(id)) continue;
                this.addThinDomain(id);
            }
        }
        return this.domains;
    }

    public void addThinDomain(String id) {
        org.pentaho.metadata.model.Domain thinDomain = this.domainRepository.getDomain(id);
        try {
            Domain domain = new Domain();
            domain.setName(thinDomain.getId());
            for (LogicalModel model : thinDomain.getLogicalModels()) {
                Model myModel = this.createModel(model);
                domain.getModels().add(myModel);
            }
            this.domains.add(domain);
            this.domainNames.add(domain.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String[][] getPreviewData(MqlQuery query, int page, int limit) {
        throw new NotImplementedException("Preview not implemented in the Deligate");
    }

    private Model createModel(BusinessModel m) {
        Model model = new Model();
        model.setName(m.getName(this.getLocale()));
        model.setId(m.getId());
        UniqueList cats = m.getRootCategory().getBusinessCategories();
        for (BusinessCategory cat : cats) {
            model.getCategories().add(this.createCategory(m, cat));
        }
        return model;
    }

    private Model createModel(LogicalModel m) {
        Model model = new Model();
        model.setName(m.getName(this.getLocale()));
        model.setId(m.getId());
        for (Category cat : m.getCategories()) {
            model.getCategories().add(this.createCategory(m, cat));
        }
        return model;
    }

    private org.pentaho.commons.metadata.mqleditor.beans.Category createCategory(BusinessModel m, BusinessCategory c) {
        org.pentaho.commons.metadata.mqleditor.beans.Category cat = new org.pentaho.commons.metadata.mqleditor.beans.Category();
        cat.setName(c.getName(this.getLocale()));
        cat.setId(c.getId());
        UniqueList cols = c.getBusinessColumns();
        for (BusinessColumn col : cols) {
            cat.getBusinessColumns().add(this.createColumn(m, col));
        }
        return cat;
    }

    private org.pentaho.commons.metadata.mqleditor.beans.Category createCategory(LogicalModel m, Category c) {
        org.pentaho.commons.metadata.mqleditor.beans.Category cat = new org.pentaho.commons.metadata.mqleditor.beans.Category();
        cat.setName(c.getName(this.getLocale()));
        cat.setId(c.getId());
        for (LogicalColumn col : c.getLogicalColumns()) {
            cat.getBusinessColumns().add(this.createColumn(m, col));
        }
        return cat;
    }

    private Column createColumn(BusinessModel m, BusinessColumn c) {
        Column col = new Column();
        col.setName(c.getName(this.getLocale()));
        col.setId(c.getId());
        int type = c.getPhysicalColumn().getDataType().getType();
        ColumnType ourType = null;
        switch (type) {
            case 3: {
                ourType = ColumnType.BOOLEAN;
                break;
            }
            case 1: {
                ourType = ColumnType.TEXT;
                break;
            }
            case 4: {
                ourType = ColumnType.FLOAT;
                break;
            }
            case 2: {
                ourType = ColumnType.DATE;
            }
        }
        col.setType(ourType);
        List possibleAggs = c.getAggregationList();
        for (AggregationSettings agg : possibleAggs) {
            col.getAggTypes().add(this.getAggType(agg.getType()));
        }
        AggType defaultAggType = this.getAggType(c.getAggregationType().getType());
        if (!col.getAggTypes().contains((Object)defaultAggType)) {
            col.getAggTypes().add(defaultAggType);
        }
        col.setDefaultAggType(defaultAggType);
        col.setSelectedAggType(defaultAggType);
        return col;
    }

    private Column createColumn(LogicalModel m, LogicalColumn c) {
        Column col = new Column();
        col.setName(c.getName(this.getLocale()));
        col.setId(c.getId());
        ColumnType ourType = null;
        if (c.getDataType() != null) {
            int type = c.getDataType().getType();
            switch (type) {
                case 3: {
                    ourType = ColumnType.BOOLEAN;
                    break;
                }
                case 1: {
                    ourType = ColumnType.TEXT;
                    break;
                }
                case 4: {
                    ourType = ColumnType.FLOAT;
                    break;
                }
                case 2: {
                    ourType = ColumnType.DATE;
                }
            }
        }
        col.setType(ourType);
        List possibleAggs = c.getAggregationList();
        if (possibleAggs != null) {
            for (AggregationType agg : possibleAggs) {
                col.getAggTypes().add(this.getAggType(agg.ordinal()));
            }
        }
        AggType defaultAggType = null;
        defaultAggType = c.getAggregationType() != null ? this.getAggType(c.getAggregationType().ordinal()) : AggType.NONE;
        if (!col.getAggTypes().contains((Object)defaultAggType)) {
            col.getAggTypes().add(defaultAggType);
        }
        col.setDefaultAggType(defaultAggType);
        col.setSelectedAggType(defaultAggType);
        return col;
    }

    private AggType getAggType(int type) {
        switch (type) {
            case 3: {
                return AggType.COUNT;
            }
            case 4: {
                return AggType.COUNT_DISTINCT;
            }
            case 2: {
                return AggType.AVERAGE;
            }
            case 6: {
                return AggType.MAX;
            }
            case 5: {
                return AggType.MIN;
            }
            case 1: {
                return AggType.SUM;
            }
        }
        return AggType.NONE;
    }

    private AggregationType getAggregationType(AggType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case COUNT: {
                return AggregationType.COUNT;
            }
            case COUNT_DISTINCT: {
                return AggregationType.COUNT_DISTINCT;
            }
            case AVERAGE: {
                return AggregationType.AVERAGE;
            }
            case MAX: {
                return AggregationType.MAXIMUM;
            }
            case MIN: {
                return AggregationType.MINIMUM;
            }
            case SUM: {
                return AggregationType.SUM;
            }
        }
        return AggregationType.NONE;
    }

    private AggregationSettings getAggregationSettings(AggType type) {
        if (type == null) {
            return AggregationSettings.NONE;
        }
        switch (type) {
            case COUNT: {
                return AggregationSettings.COUNT;
            }
            case COUNT_DISTINCT: {
                return AggregationSettings.COUNT_DISTINCT;
            }
            case AVERAGE: {
                return AggregationSettings.AVERAGE;
            }
            case MAX: {
                return AggregationSettings.MAXIMUM;
            }
            case MIN: {
                return AggregationSettings.MINIMUM;
            }
            case SUM: {
                return AggregationSettings.SUM;
            }
        }
        return AggregationSettings.NONE;
    }

    public List<MqlDomain> getMetadataDomains() {
        return this.domains;
    }

    public MqlDomain getDomainByName(String name) {
        this.refreshMetadataDomains();
        if (!name.endsWith(".xmi")) {
            return this.matchLegacyDomainName(name);
        }
        for (MqlDomain domain : this.domains) {
            if (!domain.getName().equals(name)) continue;
            return domain;
        }
        return null;
    }

    private MqlDomain matchLegacyDomainName(String name) {
        for (MqlDomain domain : this.domains) {
            if (!domain.getName().contains(name)) continue;
            return domain;
        }
        return null;
    }

    private BusinessColumn[] getColumns(BusinessModel model, List<? extends MqlColumn> thincols) {
        BusinessColumn[] cols = new BusinessColumn[thincols.size()];
        int i = 0;
        for (MqlColumn mqlColumn : thincols) {
            UniqueList list = model.getAllBusinessColumns();
            for (Object col : list.getList()) {
                if (!((BusinessColumn)col).getId().equals(mqlColumn.getId())) continue;
                cols[i] = (BusinessColumn)col;
                cols[i].setAggregationType(this.getAggregationSettings(mqlColumn.getSelectedAggType()));
                ++i;
            }
        }
        return cols;
    }

    private BusinessColumn getColumn(BusinessModel model, MqlColumn thinCol) {
        UniqueList list = model.getAllBusinessColumns();
        for (Object col : list.getList()) {
            BusinessColumn bCol = (BusinessColumn)col;
            if (!bCol.getId().equals(thinCol.getId())) continue;
            AggType aggType = thinCol.getSelectedAggType();
            if (aggType == null && thinCol.getDefaultAggType() != null) {
                aggType = thinCol.getDefaultAggType();
            }
            bCol.setAggregationType(this.getAggregationSettings(aggType));
            return bCol;
        }
        return null;
    }

    private MQLWhereConditionModel[] getConditions(BusinessModel model, List<? extends MqlCondition> thinConditions) {
        MQLWhereConditionModel[] conditions = new MQLWhereConditionModel[thinConditions.size()];
        int i = 0;
        for (MqlCondition mqlCondition : thinConditions) {
            BusinessColumn col = this.getColumn(model, mqlCondition.getColumn());
            MQLWhereConditionModel where = new MQLWhereConditionModel(mqlCondition.getCombinationType() == null ? "" : mqlCondition.getCombinationType().toString(), col, this.conditionFormatter.getCondition(mqlCondition, "[" + col.toString() + "]"));
            conditions[i++] = where;
        }
        return conditions;
    }

    private List<OrderBy> getOrders(BusinessModel model, List<? extends MqlOrder> thinOrders) {
        ArrayList<OrderBy> ord = new ArrayList<OrderBy>();
        for (MqlOrder mqlOrder : thinOrders) {
            Selection selection = new Selection(this.getColumn(model, mqlOrder.getColumn()));
            ord.add(new OrderBy(selection, mqlOrder.getOrderType() == MqlOrder.Type.ASC));
        }
        return ord;
    }

    public String saveQuery(MqlQuery query) {
        org.pentaho.metadata.model.Domain thinDomain;
        if (query.getColumns().isEmpty()) {
            throw new RuntimeException("query is not valid without columns");
        }
        if (this.domainRepository != null && (thinDomain = this.domainRepository.getDomain(query.getDomain().getName())) != null) {
            Query queryModel = this.convertQueryModel(thinDomain, query);
            return new QueryXmlHelper().toXML(queryModel);
        }
        MQLQuery fatQ = this.convertModel(query);
        if (fatQ != null) {
            return fatQ.getXML();
        }
        return "";
    }

    private Category findCategory(LogicalModel model, MqlColumn col) {
        for (Category category : model.getCategories()) {
            for (LogicalColumn lcol : category.getLogicalColumns()) {
                if (!lcol.getId().equals(col.getId())) continue;
                return category;
            }
        }
        return null;
    }

    public Query convertQueryModel(MqlQuery query) {
        org.pentaho.metadata.model.Domain thinDomain = this.domainRepository.getDomain(query.getDomain().getName());
        return this.convertQueryModel(thinDomain, query);
    }

    private DataType getDataType(ColumnType type) {
        switch (type) {
            case BOOLEAN: {
                return DataType.BOOLEAN;
            }
            case DATE: {
                return DataType.STRING;
            }
            case FLOAT: 
            case NUMERIC: {
                return DataType.NUMERIC;
            }
            case TEXT: {
                return DataType.STRING;
            }
        }
        return DataType.UNKNOWN;
    }

    private Query convertQueryModel(org.pentaho.metadata.model.Domain thinDomain, MqlQuery query) {
        LogicalModel model = thinDomain.findLogicalModel(query.getModel().getId());
        if (model != null) {
            Query queryObject = new Query(thinDomain, model);
            try {
                if (query.getColumns().size() > 0) {
                    LogicalColumn column;
                    Category view;
                    for (MqlColumn mqlColumn : query.getColumns()) {
                        view = this.findCategory(model, mqlColumn);
                        if (view == null) {
                            System.err.println("could not find category for column " + mqlColumn.getId());
                            return null;
                        }
                        column = view.findLogicalColumn(mqlColumn.getId());
                        if (column == null) {
                            System.err.println("could not find column : " + mqlColumn.getId());
                            return null;
                        }
                        queryObject.getSelections().add(new org.pentaho.metadata.query.model.Selection(view, column, this.getAggregationType(mqlColumn.getSelectedAggType())));
                    }
                    for (MqlCondition mqlCondition : query.getConditions()) {
                        view = this.findCategory(model, mqlCondition.getColumn());
                        AggregationType type = this.getAggregationType(mqlCondition.getSelectedAggType());
                        String field = "[";
                        field = field + view.getId() + "." + mqlCondition.getColumn().getId();
                        if (type != null) {
                            field = field + "." + type.toString();
                        }
                        field = field + "]";
                        if (mqlCondition.isParameterized()) {
                            queryObject.getParameters().add(new Parameter(mqlCondition.getValue().replaceAll("[\\{\\}]", ""), this.getDataType(mqlCondition.getColumn().getType()), (Object)mqlCondition.getDefaultValue()));
                        }
                        queryObject.getConstraints().add(new Constraint(this.getComboType(mqlCondition.getCombinationType()), this.conditionFormatter.getCondition(mqlCondition, field)));
                    }
                    for (MqlOrder mqlOrder : query.getOrders()) {
                        view = this.findCategory(model, mqlOrder.getColumn());
                        column = view.findLogicalColumn(mqlOrder.getColumn().getId());
                        if (view == null || column == null) {
                            return null;
                        }
                        queryObject.getOrders().add(new Order(new org.pentaho.metadata.query.model.Selection(view, column, this.getAggregationType(mqlOrder.getSelectedAggType())), this.getOrderType(mqlOrder.getOrderType())));
                    }
                    queryObject.setLimit(query.getLimit());
                    return queryObject;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private Order.Type getOrderType(MqlOrder.Type type) {
        return Order.Type.values()[type.ordinal()];
    }

    private org.pentaho.metadata.query.model.CombinationType getComboType(CombinationType type) {
        if (type == null) {
            return null;
        }
        return org.pentaho.metadata.query.model.CombinationType.values()[type.ordinal()];
    }

    public MqlQuery convertModelToThin(MQLQuery fatQ) {
        org.pentaho.commons.metadata.mqleditor.beans.Query query = new org.pentaho.commons.metadata.mqleditor.beans.Query();
        BusinessModel model = null;
        for (BusinessModel businessModel : this.modelIdToSchemaMetaMap.get(fatQ.getModel().getId()).getBusinessModels()) {
            if (businessModel.getId() != fatQ.getModel().getId()) continue;
            model = businessModel;
        }
        for (MqlModel mqlModel : this.domains.get(0).getModels()) {
            if (!mqlModel.getId().equals(fatQ.getModel().getId())) continue;
            query.setModel((Model)mqlModel);
            query.setDomain((Domain)this.domains.get(0));
        }
        ArrayList<Column> cols = new ArrayList<Column>();
        for (Selection sel : fatQ.getSelections()) {
            Column col = this.createColumn(model, sel.getBusinessColumn());
            cols.add(col);
        }
        query.setColumns(cols);
        ArrayList<Condition> arrayList = new ArrayList<Condition>();
        for (WhereCondition w : fatQ.getConstraints()) {
            Pattern p = Pattern.compile("\\[([^\\]]*)\\.([^\\]]*)\\] (.*)");
            Matcher m = p.matcher(w.getCondition());
            if (!m.find()) continue;
            String cat = m.group(1);
            String col = m.group(2);
            UniqueList list = model.getAllBusinessColumns();
            BusinessColumn fatcol = null;
            for (Object c : list.getList()) {
                if (!((BusinessColumn)c).getId().equals(col)) continue;
                fatcol = (BusinessColumn)c;
            }
            Column c = this.createColumn(model, fatcol);
            String condition = m.group(3);
            String operator = w.getOperator();
            Condition cond = new Condition();
            cond.setColumn(c);
            cond.setValue(condition);
            cond.setOperator(Operator.parse(operator));
            arrayList.add(cond);
        }
        query.setConditions(arrayList);
        ArrayList<org.pentaho.commons.metadata.mqleditor.beans.Order> orders = new ArrayList<org.pentaho.commons.metadata.mqleditor.beans.Order>();
        for (OrderBy ord : fatQ.getOrder()) {
            Column col = this.createColumn(model, ord.getSelection().getBusinessColumn());
            if (ord.getSelection().getAggregationType() != null) {
                col.setDefaultAggType(this.getAggType(ord.getSelection().getAggregationType().getType()));
            }
            org.pentaho.commons.metadata.mqleditor.beans.Order o = new org.pentaho.commons.metadata.mqleditor.beans.Order();
            o.setColumn(col);
            o.setOrderType(ord.isAscending() ? MqlOrder.Type.ASC : MqlOrder.Type.DESC);
            orders.add(o);
        }
        query.setOrders(orders);
        query.setLimit(fatQ.getLimit());
        return query;
    }

    public MQLQuery convertModel(MqlQuery query) {
        SchemaMeta meta = this.modelIdToSchemaMetaMap.get(query.getModel().getId());
        UniqueList models = meta.getBusinessModels();
        BusinessModel realModel = null;
        for (BusinessModel m : models) {
            if (!m.getId().equals(query.getModel().getId())) continue;
            realModel = m;
            break;
        }
        if (realModel != null) {
            MQLQueryImpl mqlQuery = null;
            try {
                BusinessColumn[] businessColumns = this.getColumns(realModel, query.getColumns());
                if (businessColumns.length > 0) {
                    BusinessModel businessModel = realModel;
                    mqlQuery = new MQLQueryImpl(meta, businessModel, null, meta.getActiveLocale());
                    ArrayList<Selection> selections = new ArrayList<Selection>();
                    for (int i = 0; i < businessColumns.length; ++i) {
                        selections.add(new Selection(businessColumns[i], businessColumns[i].getAggregationType()));
                    }
                    mqlQuery.setSelections(selections);
                    MQLWhereConditionModel[] wherelist = this.getConditions(realModel, query.getConditions());
                    ArrayList<WhereCondition> constraints = new ArrayList<WhereCondition>();
                    BusinessCategory rootCat = businessModel.getRootCategory();
                    for (int i = 0; i < wherelist.length; ++i) {
                        BusinessCategory businessCategory = rootCat.findBusinessCategoryForBusinessColumn(wherelist[i].getField());
                        constraints.add(new WhereCondition(businessModel, wherelist[i].getOperator(), wherelist[i].getCondition()));
                    }
                    mqlQuery.setConstraints(constraints);
                    mqlQuery.setOrder(this.getOrders(realModel, query.getOrders()));
                    mqlQuery.setLimit(query.getLimit());
                    return mqlQuery;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String serializeModel(MqlQuery uiQuery) {
        org.pentaho.commons.metadata.mqleditor.beans.Query query = ModelUtil.convertUIModelToBean(uiQuery);
        return ModelSerializer.serialize(query);
    }

    public MqlQuery deserializeModel(String serializedQuery) {
        return ModelSerializer.deSerialize(serializedQuery);
    }

    public MqlQuery convertModelToThin(Query query) {
        org.pentaho.commons.metadata.mqleditor.beans.Query q = new org.pentaho.commons.metadata.mqleditor.beans.Query();
        String domainId = query.getDomain().getId();
        String modelId = query.getLogicalModel().getId();
        MqlDomain selectedDomain = null;
        MqlModel selectedModel = null;
        for (MqlDomain mqlDomain : this.domains) {
            if (!mqlDomain.getName().equals(domainId)) continue;
            selectedDomain = mqlDomain;
            break;
        }
        if (selectedDomain == null) {
            throw new IllegalStateException("Could not find domain: " + domainId);
        }
        q.setDomain((Domain)selectedDomain);
        for (MqlModel mqlModel : selectedDomain.getModels()) {
            if (!mqlModel.getId().equals(modelId)) continue;
            selectedModel = mqlModel;
            break;
        }
        if (selectedModel == null) {
            throw new IllegalStateException("Could not find model: " + modelId);
        }
        q.setModel((Model)selectedModel);
        List<Column> cols = q.getColumns();
        for (org.pentaho.metadata.query.model.Selection sel : query.getSelections()) {
            Column c = (Column)this.convertNewThinColumn(selectedModel, sel.getLogicalColumn().getId());
            c.setSelectedAggType(this.convertNewThinAggregationType(sel.getAggregationType()));
            cols.add(c);
        }
        for (Constraint constraint : query.getConstraints()) {
            FormulaParser fp = new FormulaParser(constraint.getFormula());
            Condition cond = fp.getCondition();
            block4: for (MqlCategory mqlCategory : selectedModel.getCategories()) {
                for (MqlColumn mqlColumn : mqlCategory.getBusinessColumns()) {
                    if (!mqlColumn.getId().equals(fp.getColID())) continue;
                    cond.setColumn((Column)mqlColumn);
                    break block4;
                }
            }
            if (fp.getAggType() != null) {
                cond.setSelectedAggType(this.convertNewThinAggregationType(AggregationType.valueOf((String)fp.getAggType())));
            }
            cond.setCombinationType(CombinationType.valueOf(constraint.getCombinationType().name().toUpperCase()));
            String val = cond.getValue();
            if (val.indexOf("[param:") == 0) {
                String string = val.substring(7, val.length() - 1);
                cond.setValue("{" + string + "}");
                cond.setParameterized(true);
                for (Parameter parameter : query.getParameters()) {
                    if (!parameter.getName().equals(string)) continue;
                    cond.setDefaultValue(this.getDisplayableDefaultValue(parameter));
                    break;
                }
            }
            q.getConditions().add(cond);
        }
        for (Order ord : query.getOrders()) {
            org.pentaho.commons.metadata.mqleditor.beans.Order o = new org.pentaho.commons.metadata.mqleditor.beans.Order();
            o.setColumn((Column)this.convertNewThinColumn(selectedModel, ord.getSelection().getLogicalColumn().getId()));
            o.setOrderType(MqlOrder.Type.valueOf(ord.getType().toString().toUpperCase()));
            q.getOrders().add(o);
        }
        q.setLimit(query.getLimit());
        return q;
    }

    private AggType convertNewThinAggregationType(AggregationType aggregationType) {
        switch (aggregationType) {
            case COUNT: {
                return AggType.COUNT;
            }
            case COUNT_DISTINCT: {
                return AggType.COUNT_DISTINCT;
            }
            case AVERAGE: {
                return AggType.AVERAGE;
            }
            case MINIMUM: {
                return AggType.MIN;
            }
            case MAXIMUM: {
                return AggType.MAX;
            }
            case SUM: {
                return AggType.SUM;
            }
        }
        return AggType.NONE;
    }

    private MqlColumn convertNewThinColumn(MqlModel selectedModel, String colId) {
        for (MqlCategory mqlCategory : selectedModel.getCategories()) {
            for (MqlColumn mqlColumn : mqlCategory.getBusinessColumns()) {
                if (!mqlColumn.getId().equals(colId)) continue;
                if (mqlColumn instanceof Column) {
                    return ((Column)mqlColumn).clone();
                }
                return mqlColumn;
            }
        }
        return null;
    }

    private String getDisplayableDefaultValue(Parameter p) {
        if (p == null || p.getDefaultValue() == null) {
            return null;
        }
        if (p.getDefaultValue() instanceof Object[]) {
            Object[] values = (Object[])p.getDefaultValue();
            StringBuilder sb = new StringBuilder();
            for (Object value : values) {
                if (sb.length() > 0) {
                    sb.append("|");
                }
                if (value.toString().contains("|")) {
                    sb.append("\"").append(value).append("\"");
                    continue;
                }
                sb.append(value);
            }
            return sb.toString();
        }
        return p.getDefaultValue().toString();
    }

    private class MQLWhereConditionModel {
        private String operator;
        private BusinessColumn field;
        private String condition;

        public MQLWhereConditionModel(String operator, BusinessColumn field, String condition) {
            this.operator = operator;
            this.field = field;
            this.condition = condition;
        }

        public String getOperator() {
            return this.operator;
        }

        public BusinessColumn getField() {
            return this.field;
        }

        public String getCondition() {
            return this.condition;
        }

        public void setCondition(String condition) {
            this.condition = condition;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }
    }
}

