/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.metadata.mqleditor.utils;

import java.util.ArrayList;
import org.pentaho.commons.metadata.mqleditor.MqlColumn;
import org.pentaho.commons.metadata.mqleditor.MqlCondition;
import org.pentaho.commons.metadata.mqleditor.MqlOrder;
import org.pentaho.commons.metadata.mqleditor.MqlQuery;
import org.pentaho.commons.metadata.mqleditor.beans.Column;
import org.pentaho.commons.metadata.mqleditor.beans.Condition;
import org.pentaho.commons.metadata.mqleditor.beans.Domain;
import org.pentaho.commons.metadata.mqleditor.beans.Model;
import org.pentaho.commons.metadata.mqleditor.beans.Order;
import org.pentaho.commons.metadata.mqleditor.beans.Query;

public class ModelUtil {
    public static Query convertUIModelToBean(MqlQuery uiQuery) {
        Query query = new Query();
        if (uiQuery.getDomain() == null || uiQuery.getModel() == null) {
            return null;
        }
        Domain domain = new Domain();
        domain.setName(uiQuery.getDomain().getName());
        domain.setId(uiQuery.getDomain().getId());
        query.setDomain(domain);
        Model model = new Model();
        model.setName(uiQuery.getModel().getName());
        model.setId(uiQuery.getModel().getId());
        query.setMqlStr(uiQuery.getMqlStr());
        query.setModel(model);
        ArrayList<Column> cols = new ArrayList<Column>();
        for (MqlColumn mqlColumn : uiQuery.getColumns()) {
            Column column = new Column();
            column.setId(mqlColumn.getId());
            column.setName(mqlColumn.getName());
            column.setType(mqlColumn.getType());
            column.setAggTypes(mqlColumn.getAggTypes());
            column.setDefaultAggType(mqlColumn.getDefaultAggType());
            column.setSelectedAggType(mqlColumn.getSelectedAggType());
            cols.add(column);
        }
        query.setColumns(cols);
        ArrayList<Order> orders = new ArrayList<Order>();
        if (uiQuery.getOrders() != null) {
            for (MqlOrder mqlOrder : uiQuery.getOrders()) {
                Order order = new Order();
                Column col = new Column();
                col.setId(mqlOrder.getColumn().getId());
                col.setName(mqlOrder.getColumn().getName());
                col.setType(mqlOrder.getColumn().getType());
                col.setAggTypes(mqlOrder.getColumn().getAggTypes());
                col.setDefaultAggType(mqlOrder.getColumn().getDefaultAggType());
                col.setSelectedAggType(mqlOrder.getColumn().getSelectedAggType());
                order.setColumn(col);
                order.setOrderType(mqlOrder.getOrderType());
                order.setSelectedAggType(mqlOrder.getSelectedAggType());
                orders.add(order);
            }
        }
        query.setOrders(orders);
        ArrayList<Condition> arrayList = new ArrayList<Condition>();
        if (uiQuery.getConditions() != null) {
            for (MqlCondition mqlCondition : uiQuery.getConditions()) {
                Condition con = new Condition();
                Column col = new Column();
                col.setId(mqlCondition.getColumn().getId());
                col.setName(mqlCondition.getColumn().getName());
                col.setType(mqlCondition.getColumn().getType());
                col.setAggTypes(mqlCondition.getColumn().getAggTypes());
                col.setDefaultAggType(mqlCondition.getColumn().getDefaultAggType());
                col.setSelectedAggType(mqlCondition.getColumn().getSelectedAggType());
                con.setColumn(col);
                con.setCombinationType(mqlCondition.getCombinationType());
                con.setParameterized(mqlCondition.isParameterized());
                con.setDefaultValue(mqlCondition.getDefaultValue());
                con.setOperator(mqlCondition.getOperator());
                con.setValue(mqlCondition.getValue());
                con.setSelectedAggType(mqlCondition.getSelectedAggType());
                arrayList.add(con);
            }
        }
        query.setLimit(uiQuery.getLimit());
        query.setConditions(arrayList);
        return query;
    }
}

