/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.smb;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileNotFoundException;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.FileTypeHasNoContentException;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.UserAuthenticationData;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.smb.SmbFileName;
import org.apache.commons.vfs.provider.smb.SmbFileProvider;
import org.apache.commons.vfs.provider.smb.SmbFileRandomAccessContent;
import org.apache.commons.vfs.provider.smb.SmbFileSystem;
import org.apache.commons.vfs.util.RandomAccessMode;
import org.apache.commons.vfs.util.UserAuthenticatorUtils;

public class SmbFileObject
extends AbstractFileObject
implements FileObject {
    private SmbFile file;

    protected SmbFileObject(FileName fileName, SmbFileSystem smbFileSystem) throws FileSystemException {
        super(fileName, smbFileSystem);
    }

    protected void doAttach() throws Exception {
        if (this.file == null) {
            this.file = this.createSmbFile(this.getName());
        }
    }

    protected void doDetach() throws Exception {
        this.file = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SmbFile createSmbFile(FileName fileName) throws MalformedURLException, SmbException, FileSystemException {
        SmbFile smbFile;
        NtlmPasswordAuthentication ntlmPasswordAuthentication;
        SmbFileName smbFileName = (SmbFileName)fileName;
        String string = smbFileName.getUriWithoutAuth();
        UserAuthenticationData userAuthenticationData = null;
        try {
            userAuthenticationData = UserAuthenticatorUtils.authenticate(this.getFileSystem().getFileSystemOptions(), SmbFileProvider.AUTHENTICATOR_TYPES);
            ntlmPasswordAuthentication = new NtlmPasswordAuthentication(UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(userAuthenticationData, UserAuthenticationData.DOMAIN, UserAuthenticatorUtils.toChar(smbFileName.getDomain()))), UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(userAuthenticationData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(smbFileName.getUserName()))), UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(userAuthenticationData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(smbFileName.getPassword()))));
            smbFile = new SmbFile(string, ntlmPasswordAuthentication);
        }
        catch (Throwable throwable) {
            UserAuthenticatorUtils.cleanup(userAuthenticationData);
            throw throwable;
        }
        UserAuthenticatorUtils.cleanup(userAuthenticationData);
        if (smbFile.isDirectory() && !smbFile.toString().endsWith("/")) {
            smbFile = new SmbFile(string + "/", ntlmPasswordAuthentication);
        }
        return smbFile;
    }

    protected FileType doGetType() throws Exception {
        if (!this.file.exists()) {
            return FileType.IMAGINARY;
        }
        if (this.file.isDirectory()) {
            return FileType.FOLDER;
        }
        if (this.file.isFile()) {
            return FileType.FILE;
        }
        throw new FileSystemException("vfs.provider.smb/get-type.error", this.getName());
    }

    protected String[] doListChildren() throws Exception {
        if (!this.file.isDirectory()) {
            return null;
        }
        return UriParser.encode(this.file.list());
    }

    protected boolean doIsHidden() throws Exception {
        return this.file.isHidden();
    }

    protected void doDelete() throws Exception {
        this.file.delete();
    }

    protected void doRename(FileObject fileObject) throws Exception {
        this.file.renameTo(this.createSmbFile(fileObject.getName()));
    }

    protected void doCreateFolder() throws Exception {
        this.file.mkdir();
        this.file = this.createSmbFile(this.getName());
    }

    protected long doGetContentSize() throws Exception {
        return this.file.length();
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.file.getLastModified();
    }

    protected InputStream doGetInputStream() throws Exception {
        try {
            return new SmbFileInputStream(this.file);
        }
        catch (SmbException smbException) {
            if (smbException.getNtStatus() == -1073741809) {
                throw new FileNotFoundException(this.getName());
            }
            if (this.file.isDirectory()) {
                throw new FileTypeHasNoContentException(this.getName());
            }
            throw smbException;
        }
    }

    protected OutputStream doGetOutputStream(boolean bl) throws Exception {
        return new SmbFileOutputStream(this.file, bl);
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode randomAccessMode) throws Exception {
        return new SmbFileRandomAccessContent(this.file, randomAccessMode);
    }
}

