/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.webdav;

import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.http.HttpFileSystemConfigBuilder;
import org.apache.commons.vfs.provider.webdav.WebdavFileSystem;

public final class WebdavFileSystemConfigBuilder
extends HttpFileSystemConfigBuilder {
    private static final WebdavFileSystemConfigBuilder BUILDER = new WebdavFileSystemConfigBuilder();

    private WebdavFileSystemConfigBuilder() {
        super("webdav.");
    }

    public static HttpFileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    public void setCreatorName(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, "creatorName", string);
    }

    public String getCreatorName(FileSystemOptions fileSystemOptions) {
        return this.getString(fileSystemOptions, "creatorName");
    }

    public void setVersioning(FileSystemOptions fileSystemOptions, boolean bl) {
        this.setParam(fileSystemOptions, "versioning", bl);
    }

    public boolean isVersioning(FileSystemOptions fileSystemOptions) {
        return this.getBoolean(fileSystemOptions, "versioning", false);
    }

    protected Class getConfigClass() {
        return WebdavFileSystem.class;
    }
}

