/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.tasks;

import java.util.StringTokenizer;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.tasks.VfsTask;
import org.apache.commons.vfs.util.Messages;
import org.apache.tools.ant.BuildException;

public class DeleteTask
extends VfsTask {
    private String file;
    private String srcDirUrl;
    private String filesList;

    public void setFile(String string) {
        this.file = string;
    }

    public void setSrcDir(String string) {
        this.srcDirUrl = string;
    }

    public void setIncludes(String string) {
        this.filesList = string;
    }

    public void execute() throws BuildException {
        if (this.file == null && this.srcDirUrl == null || this.srcDirUrl != null && this.filesList == null) {
            String string = Messages.getString("vfs.tasks/delete.no-source-files.error");
            throw new BuildException(string);
        }
        try {
            if (this.srcDirUrl != null && this.filesList != null) {
                this.log("Deleting " + this.filesList + " in the directory " + this.srcDirUrl);
                if (!this.srcDirUrl.endsWith("/")) {
                    this.srcDirUrl = this.srcDirUrl + "/";
                }
                StringTokenizer stringTokenizer = new StringTokenizer(this.filesList, ", \t\n\r\f", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    FileObject fileObject = this.resolveFile(this.srcDirUrl + string);
                    fileObject.delete(Selectors.SELECT_ALL);
                }
            } else {
                FileObject fileObject = this.resolveFile(this.file);
                this.log("Deleting " + fileObject);
                fileObject.delete(Selectors.SELECT_ALL);
            }
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }
}

