/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

class MozillaDelegate {
    Browser browser;
    Listener listener;
    boolean hasFocus;
    static boolean GtkLoaded;
    static boolean IsLinux;

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        IsLinux = osName.startsWith("linux");
    }

    MozillaDelegate(Browser browser) {
        if (!IsLinux) {
            browser.dispose();
            SWT.error(2, null, " [Unsupported platform]");
        }
        this.browser = browser;
        if (!GtkLoaded) {
            GtkLoaded = true;
            try {
                Library.loadLibrary("swt-gtk");
            }
            catch (UnsatisfiedLinkError e) {
                browser.dispose();
                SWT.error(2, e);
            }
        }
    }

    static Browser findBrowser(int handle) {
        Display display = Display.getCurrent();
        Shell[] shells = display.getShells();
        Browser browser = null;
        int i = 0;
        while (i < shells.length) {
            browser = MozillaDelegate.findBrowser(shells[i], handle);
            if (browser != null) break;
            ++i;
        }
        return browser;
    }

    static Browser findBrowser(Control control, int gtkHandle) {
        if (control instanceof Browser) {
            Browser browser = (Browser)control;
            WebBrowser webBrowser = browser.webBrowser;
            if (webBrowser instanceof Mozilla && ((Mozilla)webBrowser).embedHandle == gtkHandle) {
                return browser;
            }
        }
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Browser browser = MozillaDelegate.findBrowser(children[i], gtkHandle);
                if (browser != null) {
                    return browser;
                }
                ++i;
            }
        }
        return null;
    }

    static char[] mbcsToWcs(String codePage, byte[] buffer) {
        return Converter.mbcsToWcs(codePage, buffer);
    }

    static byte[] wcsToMbcs(String codePage, String string, boolean terminate) {
        return Converter.wcsToMbcs(codePage, string, terminate);
    }

    int getHandle() {
        if (Mozilla.BrowserCount == 1) {
            GTK.gtk_init_check(new int[1], null);
            final Display display = this.browser.getDisplay();
            display.asyncExec(new Runnable(){

                /*
                 * Unable to fully structure code
                 */
                public void run() {
                    if (Mozilla.BrowserCount != 0) ** GOTO lbl5
                    return;
lbl-1000:
                    // 1 sources

                    {
                        GTK.gtk_main_iteration();
lbl5:
                        // 2 sources

                        ** while (GTK.gtk_events_pending() != 0)
                    }
lbl6:
                    // 1 sources

                    display.timerExec(25, this);
                }
            });
        }
        this.browser.getShell().setFocus();
        int result = GTK.gtk_plug_new(this.browser.embeddedHandle);
        GTK.gtk_widget_show(result);
        return result;
    }

    String getLibraryName() {
        return "libxpcom.so";
    }

    void handleFocus() {
        if (this.hasFocus) {
            return;
        }
        this.hasFocus = true;
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == MozillaDelegate.this.browser) {
                    return;
                }
                ((Mozilla)MozillaDelegate.this.browser.webBrowser).Deactivate();
                MozillaDelegate.this.hasFocus = false;
                MozillaDelegate.this.browser.getDisplay().removeFilter(15, this);
                MozillaDelegate.this.browser.getShell().removeListener(27, this);
                MozillaDelegate.this.listener = null;
            }
        };
        this.browser.getDisplay().addFilter(15, this.listener);
        this.browser.getShell().addListener(27, this.listener);
    }

    void init() {
    }

    void onDispose(int embedHandle) {
        if (this.listener != null) {
            this.browser.getDisplay().removeFilter(15, this.listener);
            this.browser.getShell().removeListener(27, this.listener);
            this.listener = null;
        }
        GTK.gtk_widget_destroy(embedHandle);
        while (GTK.gtk_events_pending() != 0) {
            GTK.gtk_main_iteration();
        }
        this.browser = null;
    }

    void setSize(int embedHandle, int width, int height) {
    }
}

