/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    private static final int COLORSWATCH_SIZE_DEPTH4 = 40;
    private static final int COLORSWATCH_SIZE_DEPTH8 = 15;
    private static final int COLORSWATCH_SIZE_DEPTH16 = 10;
    private static final int COLORSWATCH_BORDER = 1;
    private Shell shell;
    private Canvas colorsCanvas;
    private Label sampleLabel;
    private Label selectionLabel;
    private Canvas sampleCanvas;
    private Canvas selectionCanvas;
    private Button okButton;
    private Button cancelButton;
    private int colorChooserWidth;
    private int colorChooserHeight;
    private boolean okSelected;
    private RGB rgb;
    private int colorSwatchExtent;
    private Color[][] colorGrid;

    public ColorDialog(Shell parent) {
        this(parent, 0);
    }

    public ColorDialog(Shell parent, int style) {
        super(parent, style | 0x20 | 0x800 | 0x10000);
        this.checkSubclass();
    }

    void createChildren() {
        Shell dialog = this.shell;
        GridLayout layout = new GridLayout(2, false);
        dialog.setLayout(layout);
        this.colorChooserWidth = this.colorSwatchExtent * this.colorGrid.length - 1;
        this.colorChooserHeight = this.colorSwatchExtent * this.colorGrid[0].length - 1;
        this.colorsCanvas = new Canvas(dialog, 2048);
        GridData data = new GridData();
        data.widthHint = this.colorChooserWidth;
        data.heightHint = this.colorChooserHeight;
        this.colorsCanvas.setLayoutData(data);
        Composite buttonsGroup = new Composite(dialog, 0);
        buttonsGroup.setLayout(new GridLayout());
        buttonsGroup.setLayoutData(new GridData(1));
        this.createOkCancel(buttonsGroup);
        Composite bottomGroup = new Composite(dialog, 0);
        layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        bottomGroup.setLayout(layout);
        bottomGroup.setLayoutData(new GridData(1808));
        this.createSampleGroup(bottomGroup);
        this.createSelectionGroup(bottomGroup);
    }

    void createOkCancel(Composite parent) {
        this.okButton = new Button(parent, 8);
        this.okButton.setText(SWT.getMessage("SWT_OK"));
        this.shell.setDefaultButton(this.okButton);
        GridData data = new GridData(768);
        this.okButton.setLayoutData(data);
        this.cancelButton = new Button(parent, 8);
        this.cancelButton.setText(SWT.getMessage("SWT_Cancel"));
        data = new GridData(768);
        this.cancelButton.setLayoutData(data);
    }

    void createSampleGroup(Composite parent) {
        Group sampleGroup = new Group(parent, 0);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        sampleGroup.setLayout(new GridLayout());
        sampleGroup.setLayoutData(data);
        sampleGroup.setText(SWT.getMessage("SWT_Sample"));
        this.sampleLabel = new Label(sampleGroup, 0x1000800);
        this.sampleLabel.setAlignment(0x1000000);
        this.sampleLabel.setText(SWT.getMessage("SWT_A_Sample_Text"));
        data = new GridData(768);
        this.sampleLabel.setLayoutData(data);
        this.sampleCanvas = new Canvas(sampleGroup, 2048);
        data = new GridData(768);
        data.heightHint = 15;
        this.sampleCanvas.setLayoutData(data);
    }

    void createSelectionGroup(Composite parent) {
        Group selectionGroup = new Group(parent, 0);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        selectionGroup.setLayout(new GridLayout());
        selectionGroup.setLayoutData(data);
        selectionGroup.setText(SWT.getMessage("SWT_Selection"));
        this.selectionLabel = new Label(selectionGroup, 0x1000800);
        this.selectionLabel.setAlignment(0x1000000);
        this.selectionLabel.setText(SWT.getMessage("SWT_Current_Selection"));
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.selectionLabel.setLayoutData(data);
        this.selectionCanvas = new Canvas(selectionGroup, 2048);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 15;
        this.selectionCanvas.setLayoutData(data);
    }

    void disposeColors() {
        int row = 0;
        while (row < this.colorGrid.length) {
            int column = 0;
            while (column < this.colorGrid[row].length) {
                this.colorGrid[row][column].dispose();
                ++column;
            }
            ++row;
        }
    }

    void drawColor(int xIndex, int yIndex, Color color, GC gc) {
        int colorExtent = this.colorSwatchExtent - 1;
        gc.setBackground(color);
        gc.fillRectangle(xIndex * this.colorSwatchExtent, yIndex * this.colorSwatchExtent, colorExtent, colorExtent);
    }

    public RGB getRGB() {
        return this.rgb;
    }

    void handleEvents(Event event) {
        if (event.type == 9) {
            this.paint(event);
        } else if (event.type == 3) {
            this.mouseDown(event);
        } else if (event.type == 5) {
            this.mouseMove(event);
        } else if (event.type == 13) {
            if (event.widget == this.okButton) {
                this.okSelected = true;
                this.shell.setVisible(false);
            } else if (event.widget == this.cancelButton) {
                this.okSelected = false;
                this.shell.setVisible(false);
            }
        }
    }

    void initialize4BitColors() {
        Display display = this.shell.display;
        this.colorGrid[0][0] = new Color(display, 0, 0, 0);
        this.colorGrid[0][1] = new Color(display, 255, 255, 255);
        this.colorGrid[1][0] = new Color(display, 128, 128, 128);
        this.colorGrid[1][1] = new Color(display, 192, 192, 192);
        this.colorGrid[2][0] = new Color(display, 0, 0, 128);
        this.colorGrid[2][1] = new Color(display, 0, 0, 255);
        this.colorGrid[3][0] = new Color(display, 0, 128, 128);
        this.colorGrid[3][1] = new Color(display, 0, 255, 255);
        this.colorGrid[4][0] = new Color(display, 0, 128, 0);
        this.colorGrid[4][1] = new Color(display, 0, 255, 0);
        this.colorGrid[5][0] = new Color(display, 128, 128, 0);
        this.colorGrid[5][1] = new Color(display, 255, 255, 0);
        this.colorGrid[6][0] = new Color(display, 128, 0, 0);
        this.colorGrid[6][1] = new Color(display, 255, 0, 0);
        this.colorGrid[7][0] = new Color(display, 128, 0, 128);
        this.colorGrid[7][1] = new Color(display, 255, 0, 255);
    }

    void initialize8BitColors() {
        Display display = this.shell.display;
        int numRows = this.colorGrid[0].length;
        int iterationStep = 64;
        int row = 0;
        int column = 0;
        int red = 0;
        while (red <= 256) {
            int blue = 0;
            while (blue <= 256) {
                int green = 0;
                while (green <= 256) {
                    if (row == numRows) {
                        row = 0;
                        ++column;
                    }
                    if (red == 256) {
                        red = 255;
                    }
                    if (blue == 256) {
                        blue = 255;
                    }
                    if (green == 256) {
                        green = 255;
                    }
                    this.colorGrid[column][row++] = new Color(display, red, green, blue);
                    green += iterationStep;
                }
                blue += iterationStep;
            }
            red += iterationStep;
        }
    }

    void initialize16BitColors() {
        Display display = this.shell.display;
        int numRows = this.colorGrid[0].length;
        int iterationStep = 51;
        int row = 0;
        int column = 0;
        int red = 0;
        while (red <= 255) {
            int blue = 0;
            while (blue <= 255) {
                if (blue == iterationStep && column < 20) {
                    blue += iterationStep;
                }
                int green = 0;
                while (green <= 255) {
                    if (row == 2 || row == 5) {
                        this.colorGrid[column][row++] = new Color(display, red, green - iterationStep / 2, blue);
                    }
                    if (row == numRows) {
                        row = 0;
                        ++column;
                    }
                    this.colorGrid[column][row++] = new Color(display, red, green, blue);
                    green += iterationStep;
                }
                blue += iterationStep;
            }
            red += iterationStep;
        }
    }

    void initializeWidgets() {
        Display display = this.shell.display;
        if (this.rgb != null) {
            Color selectionColor = new Color(display, this.rgb);
            this.selectionCanvas.setBackground(selectionColor);
            this.selectionLabel.setBackground(selectionColor);
            selectionColor.dispose();
        }
    }

    void installListeners() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ColorDialog.this.handleEvents(event);
            }
        };
        this.okButton.addListener(13, listener);
        this.cancelButton.addListener(13, listener);
        this.colorsCanvas.addListener(9, listener);
        this.colorsCanvas.addListener(3, listener);
        this.colorsCanvas.addListener(5, listener);
    }

    void mouseDown(Event event) {
        int swatchExtent = this.colorSwatchExtent;
        Color color = this.colorGrid[event.x / swatchExtent][event.y / swatchExtent];
        this.selectionCanvas.setBackground(color);
        this.selectionLabel.setBackground(color);
    }

    void mouseMove(Event event) {
        int swatchExtent = this.colorSwatchExtent;
        if (event.x < 0 || event.x > this.colorChooserWidth) {
            return;
        }
        if (event.y < 0 || event.y > this.colorChooserHeight) {
            return;
        }
        int xgrid = Math.min(this.colorGrid.length - 1, event.x / swatchExtent);
        int ygrid = Math.min(this.colorGrid[0].length - 1, event.y / swatchExtent);
        Color color = this.colorGrid[xgrid][ygrid];
        this.sampleCanvas.setBackground(color);
        this.sampleLabel.setBackground(color);
    }

    public RGB open() {
        this.shell = new Shell(this.parent, this.getStyle() | 0x20 | 0x800 | 0x10000);
        Display display = this.shell.display;
        this.setColorDepth(display.getDepth());
        this.createChildren();
        this.installListeners();
        this.openModal();
        if (this.okSelected) {
            Color selectionColor = this.selectionCanvas.getBackground();
            this.rgb = new RGB(selectionColor.getRed(), selectionColor.getGreen(), selectionColor.getBlue());
        }
        this.disposeColors();
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
        if (!this.okSelected) {
            return null;
        }
        return this.rgb;
    }

    void openDialog() {
        Shell dialog = this.shell;
        Point pt = dialog.computeSize(-1, -1, false);
        Display display = dialog.display;
        Rectangle displayRect = display.getBounds();
        int widthLimit = displayRect.width * 7 / 8;
        int heightLimit = displayRect.height * 7 / 8;
        if (pt.x > widthLimit) {
            pt = dialog.computeSize(widthLimit, -1, false);
        }
        Rectangle parentBounds = null;
        parentBounds = this.parent.isVisible() ? this.getParent().getBounds() : this.parent.getMonitor().getBounds();
        int originX = (parentBounds.width - pt.x) / 2 + parentBounds.x;
        originX = Math.max(originX, 0);
        originX = Math.min(originX, widthLimit - pt.x);
        int originY = (parentBounds.height - pt.y) / 2 + parentBounds.y;
        originY = Math.max(originY, 0);
        originY = Math.min(originY, heightLimit - pt.y);
        dialog.setBounds(originX, originY, pt.x, pt.y);
        String title = this.getText();
        if (title.length() == 0) {
            title = SWT.getMessage("SWT_ColorDialog_Title");
        }
        this.shell.setText(title);
        dialog.open();
    }

    void openModal() {
        Display display = this.shell.display;
        this.initializeWidgets();
        this.openDialog();
        while (!this.shell.isDisposed() && this.shell.getVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    void paint(Event event) {
        int column = 0;
        while (column < this.colorGrid.length) {
            int row = 0;
            while (row < this.colorGrid[0].length) {
                this.drawColor(column, row, this.colorGrid[column][row], event.gc);
                ++row;
            }
            ++column;
        }
    }

    void setColorDepth(int bits) {
        if (bits == 4) {
            this.colorSwatchExtent = 40;
            this.colorGrid = new Color[8][2];
            this.initialize4BitColors();
            return;
        }
        if (bits == 8) {
            this.colorSwatchExtent = 15;
            this.colorGrid = new Color[25][5];
            this.initialize8BitColors();
            return;
        }
        this.colorSwatchExtent = 10;
        this.colorGrid = new Color[32][8];
        this.initialize16BitColors();
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }
}

