/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableItem
extends Item {
    Table parent;
    int index = -1;
    boolean checked;
    boolean grayed;
    boolean cached;
    String[] texts;
    int[] textWidths = new int[1];
    int customWidth = -1;
    int fontHeight;
    int[] fontHeights;
    int imageIndent;
    Image[] images;
    Color foreground;
    Color background;
    String[] displayTexts;
    Color[] cellForegrounds;
    Color[] cellBackgrounds;
    Font font;
    Font[] cellFonts;
    static final int MARGIN_TEXT = 3;

    public TableItem(Table parent, int style) {
        this(parent, style, TableItem.checkNull((Table)parent).itemsCount);
    }

    public TableItem(Table parent, int style, int index) {
        this(parent, style, index, true);
    }

    TableItem(Table parent, int style, int index, boolean notifyParent) {
        super(parent, style);
        int validItemIndex = parent.itemsCount;
        if (index < 0 || index > validItemIndex) {
            this.error(6);
        }
        this.parent = parent;
        this.index = index;
        int columnCount = parent.columns.length;
        if (columnCount > 0) {
            this.displayTexts = new String[columnCount];
            if (columnCount > 1) {
                this.texts = new String[columnCount];
                this.textWidths = new int[columnCount];
                this.images = new Image[columnCount];
            }
        }
        if (notifyParent) {
            parent.createItem(this);
        }
    }

    void addColumn(TableColumn column) {
        int index = column.getIndex();
        int columnCount = this.parent.columns.length;
        if (columnCount > 1) {
            if (columnCount == 2) {
                this.texts = new String[2];
            } else {
                String[] newTexts = new String[columnCount];
                System.arraycopy(this.texts, 0, newTexts, 0, index);
                System.arraycopy(this.texts, index, newTexts, index + 1, columnCount - index - 1);
                this.texts = newTexts;
            }
            if (index == 0) {
                this.texts[1] = this.text;
                this.text = "";
            }
            if (columnCount == 2) {
                this.images = new Image[2];
            } else {
                Image[] newImages = new Image[columnCount];
                System.arraycopy(this.images, 0, newImages, 0, index);
                System.arraycopy(this.images, index, newImages, index + 1, columnCount - index - 1);
                this.images = newImages;
            }
            if (index == 0) {
                this.images[1] = this.image;
                this.image = null;
            }
            int[] newTextWidths = new int[columnCount];
            System.arraycopy(this.textWidths, 0, newTextWidths, 0, index);
            System.arraycopy(this.textWidths, index, newTextWidths, index + 1, columnCount - index - 1);
            this.textWidths = newTextWidths;
        } else {
            this.customWidth = -1;
        }
        String[] newDisplayTexts = new String[columnCount];
        if (columnCount > 1) {
            System.arraycopy(this.displayTexts, 0, newDisplayTexts, 0, index);
            System.arraycopy(this.displayTexts, index, newDisplayTexts, index + 1, columnCount - index - 1);
        }
        this.displayTexts = newDisplayTexts;
        if (this.cellBackgrounds != null) {
            Color[] newCellBackgrounds = new Color[columnCount];
            System.arraycopy(this.cellBackgrounds, 0, newCellBackgrounds, 0, index);
            System.arraycopy(this.cellBackgrounds, index, newCellBackgrounds, index + 1, columnCount - index - 1);
            this.cellBackgrounds = newCellBackgrounds;
        }
        if (this.cellForegrounds != null) {
            Color[] newCellForegrounds = new Color[columnCount];
            System.arraycopy(this.cellForegrounds, 0, newCellForegrounds, 0, index);
            System.arraycopy(this.cellForegrounds, index, newCellForegrounds, index + 1, columnCount - index - 1);
            this.cellForegrounds = newCellForegrounds;
        }
        if (this.cellFonts != null) {
            Font[] newCellFonts = new Font[columnCount];
            System.arraycopy(this.cellFonts, 0, newCellFonts, 0, index);
            System.arraycopy(this.cellFonts, index, newCellFonts, index + 1, columnCount - index - 1);
            this.cellFonts = newCellFonts;
            int[] newFontHeights = new int[columnCount];
            System.arraycopy(this.fontHeights, 0, newFontHeights, 0, index);
            System.arraycopy(this.fontHeights, index, newFontHeights, index + 1, columnCount - index - 1);
            this.fontHeights = newFontHeights;
        }
        if (index == 0 && columnCount > 1 && (this.parent.style & 0x20) != 0) {
            GC gc = new GC(this.parent);
            gc.setFont(this.getFont(1, false));
            this.computeDisplayText(1, gc);
            gc.dispose();
        }
    }

    static Table checkNull(Table table) {
        if (table == null) {
            SWT.error(4);
        }
        return table;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        this.grayed = false;
        this.checked = false;
        this.texts = null;
        this.textWidths = new int[1];
        this.fontHeight = 0;
        this.fontHeights = null;
        this.images = null;
        this.background = null;
        this.foreground = null;
        this.displayTexts = null;
        this.cellBackgrounds = null;
        this.cellForegrounds = null;
        this.font = null;
        this.cellFonts = null;
        this.cached = false;
        this.text = "";
        this.image = null;
        int columnCount = this.parent.columns.length;
        if (columnCount > 0) {
            this.displayTexts = new String[columnCount];
            if (columnCount > 1) {
                this.texts = new String[columnCount];
                this.textWidths = new int[columnCount];
                this.images = new Image[columnCount];
            }
        }
    }

    void computeDisplayText(int columnIndex, GC gc) {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return;
        }
        int columnCount = this.parent.columns.length;
        if (columnCount == 0) {
            String text = this.getText(0, false);
            this.textWidths[columnIndex] = gc.stringExtent((String)text).x;
            return;
        }
        TableColumn column = this.parent.columns[columnIndex];
        int availableWidth = column.width - 2 * this.parent.getCellPadding() - 6;
        if (columnIndex == 0) {
            availableWidth -= this.parent.col0ImageWidth;
            if (this.parent.col0ImageWidth > 0) {
                availableWidth -= 3;
            }
            if ((this.parent.style & 0x20) != 0) {
                availableWidth -= this.parent.checkboxBounds.width;
                availableWidth -= 3;
            }
        } else {
            Image image = this.getImage(columnIndex, false);
            if (image != null) {
                availableWidth -= image.getBounds().width;
                availableWidth -= 3;
            }
        }
        String text = this.getText(columnIndex, false);
        int textWidth = gc.stringExtent((String)text).x;
        if (textWidth <= availableWidth) {
            this.displayTexts[columnIndex] = text;
            this.textWidths[columnIndex] = textWidth;
            return;
        }
        int ellipsisWidth = gc.stringExtent((String)"...").x;
        if ((availableWidth -= ellipsisWidth) <= 0) {
            this.displayTexts[columnIndex] = "...";
            this.textWidths[columnIndex] = ellipsisWidth;
            return;
        }
        int index = Math.min(availableWidth / gc.getFontMetrics().getAverageCharWidth(), text.length());
        textWidth = gc.stringExtent((String)text.substring((int)0, (int)index)).x;
        if (availableWidth == textWidth) {
            this.displayTexts[columnIndex] = String.valueOf(text.substring(0, index)) + "...";
            this.textWidths[columnIndex] = textWidth + ellipsisWidth;
            return;
        }
        if (availableWidth < textWidth) {
            do {
                if (--index < 0) {
                    this.displayTexts[columnIndex] = "...";
                    this.textWidths[columnIndex] = ellipsisWidth;
                    return;
                }
                text = text.substring(0, index);
            } while (availableWidth < (textWidth = gc.stringExtent((String)text).x));
            this.displayTexts[columnIndex] = String.valueOf(text) + "...";
            this.textWidths[columnIndex] = textWidth + ellipsisWidth;
            return;
        }
        int previousWidth = 0;
        while (textWidth < availableWidth) {
            previousWidth = textWidth;
            textWidth = gc.stringExtent((String)text.substring((int)0, (int)(++index))).x;
        }
        this.displayTexts[columnIndex] = String.valueOf(text.substring(0, index - 1)) + "...";
        this.textWidths[columnIndex] = previousWidth + ellipsisWidth;
    }

    void computeDisplayTexts(GC gc) {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return;
        }
        int columnCount = this.parent.columns.length;
        if (columnCount == 0) {
            return;
        }
        int i = 0;
        while (i < columnCount) {
            gc.setFont(this.getFont(i, false));
            this.computeDisplayText(i, gc);
            ++i;
        }
    }

    void computeTextWidths(GC gc) {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return;
        }
        int validColumnCount = Math.max(1, this.parent.columns.length);
        this.textWidths = new int[validColumnCount];
        int i = 0;
        while (i < this.textWidths.length) {
            String value = this.getDisplayText(i);
            if (value != null) {
                gc.setFont(this.getFont(i, false));
                this.textWidths[i] = gc.stringExtent((String)value).x;
            }
            ++i;
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        Table parent = this.parent;
        int startIndex = this.index;
        int endIndex = parent.itemsCount - 1;
        this.dispose(true);
        parent.redrawItems(startIndex, endIndex, false);
    }

    void dispose(boolean notifyParent) {
        if (this.isDisposed()) {
            return;
        }
        if (notifyParent) {
            this.parent.destroyItem(this);
        }
        super.dispose();
        this.foreground = null;
        this.background = null;
        this.cellForegrounds = null;
        this.cellBackgrounds = null;
        this.font = null;
        this.cellFonts = null;
        this.images = null;
        this.displayTexts = null;
        this.texts = null;
        this.fontHeights = null;
        this.textWidths = null;
        this.parent = null;
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.background != null) {
            return this.background;
        }
        return this.parent.getBackground();
    }

    public Color getBackground(int columnIndex) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int validColumnCount = Math.max(1, this.parent.columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return this.getBackground();
        }
        if (this.cellBackgrounds == null || this.cellBackgrounds[columnIndex] == null) {
            return this.getBackground();
        }
        return this.cellBackgrounds[columnIndex];
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return this.getBounds(true);
    }

    Rectangle getBounds(boolean checkData) {
        TableColumn column;
        int right;
        if (checkData && !this.parent.checkData(this, true)) {
            this.error(24);
        }
        int x = this.getTextX(0);
        int width = this.textWidths[0] + 6;
        if (this.parent.columns.length > 0 && x + width > (right = (column = this.parent.columns[0]).getX() + column.width)) {
            width = Math.max(0, right - x);
        }
        return new Rectangle(x, this.parent.getItemY(this), width, this.parent.itemHeight - 1);
    }

    public Rectangle getBounds(int columnIndex) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        TableColumn[] columns = this.parent.columns;
        int columnCount = columns.length;
        int validColumnCount = Math.max(1, columnCount);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (columnCount == 0) {
            int width = this.getContentWidth(0);
            return new Rectangle(this.getContentX(0), this.parent.getItemY(this), width, this.parent.itemHeight - 1);
        }
        TableColumn column = columns[columnIndex];
        if (columnIndex == 0) {
            int x = this.getContentX(0);
            int offset = x - column.getX();
            int width = Math.max(0, column.width - offset - 1);
            return new Rectangle(x, this.parent.getItemY(this) + 1, width, this.parent.itemHeight - 1);
        }
        return new Rectangle(column.getX(), this.parent.getItemY(this) + 1, column.width, this.parent.itemHeight - 1);
    }

    Rectangle getCellBounds(int columnIndex) {
        int y = this.parent.getItemY(this);
        if (this.parent.columns.length == 0) {
            int width;
            if (this.customWidth != -1) {
                width = this.getContentX(0) + this.customWidth + this.parent.horizontalOffset;
            } else {
                int textPaintWidth = this.textWidths[0] + 6;
                width = this.getTextX(0) + textPaintWidth + this.parent.horizontalOffset;
            }
            return new Rectangle(-this.parent.horizontalOffset, y, width, this.parent.itemHeight);
        }
        TableColumn column = this.parent.columns[columnIndex];
        return new Rectangle(column.getX(), y, column.width, this.parent.itemHeight);
    }

    Rectangle getCheckboxBounds() {
        if ((this.parent.getStyle() & 0x20) == 0) {
            return null;
        }
        Rectangle result = this.parent.checkboxBounds;
        result.x = this.parent.columns.length == 0 ? this.parent.getCellPadding() - this.parent.horizontalOffset : this.parent.columns[0].getX() + this.parent.getCellPadding();
        result.y = this.parent.getItemY(this) + (this.parent.itemHeight - result.height) / 2;
        return result;
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.checked;
    }

    int getContentWidth(int columnIndex) {
        int width = this.textWidths[columnIndex] + 6;
        if (columnIndex == 0) {
            width += this.parent.col0ImageWidth;
            if (this.parent.col0ImageWidth > 0) {
                width += 3;
            }
        } else {
            Image image = this.getImage(columnIndex, false);
            if (image != null) {
                width += image.getBounds().width + 3;
            }
        }
        return width;
    }

    int getContentX(int columnIndex) {
        Rectangle checkboxBounds;
        int minX = this.parent.getCellPadding();
        if (columnIndex == 0 && (checkboxBounds = this.getCheckboxBounds()) != null) {
            minX += checkboxBounds.width + 3;
        }
        if (this.parent.columns.length == 0) {
            return minX - this.parent.horizontalOffset;
        }
        TableColumn column = this.parent.columns[columnIndex];
        int columnX = column.getX();
        if ((column.style & 0x4000) != 0) {
            return columnX + minX;
        }
        int contentWidth = this.getContentWidth(columnIndex);
        int contentX = 0;
        contentX = (column.style & 0x20000) != 0 ? column.width - this.parent.getCellPadding() - contentWidth : (column.width - contentWidth) / 2;
        return Math.max(columnX + minX, columnX + contentX);
    }

    String getDisplayText(int columnIndex) {
        if (this.parent.columns.length == 0) {
            return this.getText(0, false);
        }
        String result = this.displayTexts[columnIndex];
        return result != null ? result : "";
    }

    Rectangle getFocusBounds() {
        int width;
        int x = 0;
        TableColumn[] columns = this.parent.columns;
        int[] columnOrder = this.parent.getColumnOrder();
        if ((this.parent.style & 0x10000) != 0) {
            int col0index;
            int n = col0index = columnOrder.length == 0 ? 0 : columnOrder[0];
            x = col0index == 0 ? (this.parent.hooks(42) ? this.getContentX(0) : this.getTextX(0)) : -this.parent.horizontalOffset;
        } else {
            x = this.parent.hooks(42) ? this.getContentX(0) : this.getTextX(0);
        }
        if (columns.length > 0) {
            int rightX = columns[0].getX() + columns[0].width;
            x = Math.min(x, rightX - 1);
        }
        if (columns.length == 0) {
            width = this.customWidth != -1 ? this.customWidth : this.textWidths[0] + 6;
        } else {
            TableColumn column = (this.parent.style & 0x10000) != 0 ? columns[columnOrder[columnOrder.length - 1]] : columns[0];
            width = column.getX() + column.width - x - 1;
        }
        return new Rectangle(x, this.parent.getItemY(this) + (this.parent.linesVisible ? 1 : 0), width, this.parent.itemHeight - (this.parent.linesVisible ? 1 : 0));
    }

    public Font getFont() {
        this.checkWidget();
        return this.getFont(true);
    }

    Font getFont(boolean checkData) {
        if (checkData && !this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.font != null) {
            return this.font;
        }
        return this.parent.getFont();
    }

    public Font getFont(int columnIndex) {
        this.checkWidget();
        return this.getFont(columnIndex, true);
    }

    Font getFont(int columnIndex, boolean checkData) {
        if (checkData && !this.parent.checkData(this, true)) {
            this.error(24);
        }
        int validColumnCount = Math.max(1, this.parent.columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return this.getFont(checkData);
        }
        if (this.cellFonts == null || this.cellFonts[columnIndex] == null) {
            return this.getFont(checkData);
        }
        return this.cellFonts[columnIndex];
    }

    int getFontHeight() {
        if (this.fontHeight != 0) {
            return this.fontHeight;
        }
        return this.parent.fontHeight;
    }

    int getFontHeight(int columnIndex) {
        if (this.fontHeights == null || this.fontHeights[columnIndex] == 0) {
            return this.getFontHeight();
        }
        return this.fontHeights[columnIndex];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.foreground != null) {
            return this.foreground;
        }
        return this.parent.getForeground();
    }

    public Color getForeground(int columnIndex) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int validColumnCount = Math.max(1, this.parent.columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return this.getForeground();
        }
        if (this.cellForegrounds == null || this.cellForegrounds[columnIndex] == null) {
            return this.getForeground();
        }
        return this.cellForegrounds[columnIndex];
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.grayed;
    }

    Rectangle getHitBounds() {
        int[] columnOrder = this.parent.getColumnOrder();
        int contentX = 0;
        if ((this.parent.style & 0x10000) != 0) {
            int col0index;
            int n = col0index = columnOrder.length == 0 ? 0 : columnOrder[0];
            contentX = col0index == 0 ? this.getContentX(0) : 0;
        } else {
            contentX = this.getContentX(0);
        }
        int width = 0;
        TableColumn[] columns = this.parent.columns;
        if (columns.length == 0) {
            width = this.getContentWidth(0);
        } else {
            TableColumn column = (this.parent.style & 0x10000) != 0 ? columns[columnOrder[columnOrder.length - 1]] : columns[0];
            width = column.getX() + column.width - contentX;
        }
        return new Rectangle(contentX, this.parent.getItemY(this), width, this.parent.itemHeight);
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getImage();
    }

    public Image getImage(int columnIndex) {
        this.checkWidget();
        return this.getImage(columnIndex, true);
    }

    Image getImage(int columnIndex, boolean checkData) {
        if (checkData && !this.parent.checkData(this, true)) {
            this.error(24);
        }
        int validColumnCount = Math.max(1, this.parent.columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return null;
        }
        if (columnIndex == 0) {
            return super.getImage();
        }
        return this.images[columnIndex];
    }

    public Rectangle getImageBounds(int columnIndex) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int validColumnCount = Math.max(1, this.parent.columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return new Rectangle(0, 0, 0, 0);
        }
        int padding = this.parent.getCellPadding();
        int startX = this.getContentX(columnIndex);
        int itemHeight = this.parent.itemHeight;
        int imageSpaceY = itemHeight - 2 * padding;
        int y = this.parent.getItemY(this);
        Image image = this.getImage(columnIndex, false);
        int drawWidth = 0;
        if (columnIndex == 0) {
            drawWidth = this.parent.col0ImageWidth;
        } else if (image != null) {
            drawWidth = image.getBounds().width;
        }
        return new Rectangle(startX, y + padding, drawWidth, imageSpaceY);
    }

    public int getImageIndent() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.imageIndent;
    }

    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    int getPreferredWidth(int columnIndex) {
        int width = 0;
        GC gc = new GC(this.parent);
        gc.setFont(this.getFont(columnIndex, false));
        width += gc.stringExtent((String)this.getText((int)columnIndex, (boolean)false)).x + 6;
        if (columnIndex == 0) {
            if (this.parent.col0ImageWidth > 0) {
                width += this.parent.col0ImageWidth;
                width += 3;
            }
        } else {
            Image image = this.getImage(columnIndex, false);
            if (image != null) {
                width += image.getBounds().width;
                width += 3;
            }
        }
        if (this.parent.hooks(41)) {
            Event event = new Event();
            event.item = this;
            event.gc = gc;
            event.index = columnIndex;
            event.x = this.getContentX(columnIndex);
            event.y = this.parent.getItemY(this);
            event.width = width;
            event.height = this.parent.itemHeight;
            this.parent.sendEvent(41, event);
            if (this.parent.itemHeight != event.height) {
                this.parent.customHeightSet = true;
                boolean update = this.parent.setItemHeight(event.height + 2 * this.parent.getCellPadding());
                if (update) {
                    this.parent.redraw();
                }
            }
            width = event.width;
        }
        gc.dispose();
        if (columnIndex == 0 && (this.parent.style & 0x20) != 0) {
            width += this.parent.checkboxBounds.width;
            width += 3;
        }
        return width + 2 * this.parent.getCellPadding();
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getText();
    }

    public String getText(int columnIndex) {
        this.checkWidget();
        return this.getText(columnIndex, true);
    }

    String getText(int columnIndex, boolean checkData) {
        if (checkData && !this.parent.checkData(this, true)) {
            this.error(24);
        }
        int validColumnCount = Math.max(1, this.parent.columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return "";
        }
        if (columnIndex == 0) {
            return super.getText();
        }
        if (this.texts[columnIndex] == null) {
            return "";
        }
        return this.texts[columnIndex];
    }

    public Rectangle getTextBounds(int columnIndex) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        TableColumn[] columns = this.parent.columns;
        int columnCount = columns.length;
        int validColumnCount = Math.max(1, columnCount);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (columnCount == 0) {
            int x = this.getTextX(0) + 3;
            int width = Math.max(0, this.getContentX(0) + this.getContentWidth(0) - x);
            return new Rectangle(x, this.parent.getItemY(this), width, this.parent.itemHeight - 1);
        }
        TableColumn column = columns[columnIndex];
        if (columnIndex == 0) {
            int x = this.getTextX(0) + 3;
            int offset = x - column.getX();
            int width = Math.max(0, column.width - offset - 1);
            return new Rectangle(x, this.parent.getItemY(this) + 1, width, this.parent.itemHeight - 1);
        }
        int x = this.getTextX(columnIndex) + 3;
        int offset = x - column.getX();
        int width = Math.max(0, column.width - offset - 3);
        return new Rectangle(x, this.parent.getItemY(this) + 1, width, this.parent.itemHeight - 1);
    }

    int getTextX(int columnIndex) {
        int textX = this.getContentX(columnIndex);
        if (columnIndex == 0) {
            textX += this.parent.col0ImageWidth;
            if (this.parent.col0ImageWidth > 0) {
                textX += 3;
            }
        } else {
            Image image = this.getImage(columnIndex, false);
            if (image != null) {
                textX += image.getBounds().width + 3;
            }
        }
        return textX;
    }

    boolean isInViewport() {
        int topIndex = this.parent.topIndex;
        if (this.index < topIndex) {
            return false;
        }
        int visibleCount = this.parent.clientArea.height / this.parent.itemHeight;
        return this.index <= topIndex + visibleCount;
    }

    boolean isSelected() {
        return this.parent.getSelectionIndex(this) != -1;
    }

    boolean paint(GC gc, TableColumn column, boolean backgroundOnly) {
        int fillWidth;
        if (!this.parent.checkData(this, true)) {
            return false;
        }
        int columnIndex = 0;
        int x = 0;
        if (column != null) {
            columnIndex = column.getIndex();
            x = column.getX();
        }
        int oldAlpha = gc.getAlpha();
        boolean oldAdvanced = gc.getAdvanced();
        int oldAntialias = gc.getAntialias();
        Pattern oldBackgroundPattern = gc.getBackgroundPattern();
        Pattern oldForegroundPattern = gc.getForegroundPattern();
        int oldInterpolation = gc.getInterpolation();
        int oldTextAntialias = gc.getTextAntialias();
        if (this.parent.hooks(41)) {
            int contentWidth = this.getContentWidth(columnIndex);
            int contentX = this.getContentX(columnIndex);
            gc.setFont(this.getFont(columnIndex, false));
            Event event = new Event();
            event.item = this;
            event.gc = gc;
            event.index = columnIndex;
            event.x = contentX;
            event.y = this.parent.getItemY(this);
            event.width = contentWidth;
            event.height = this.parent.itemHeight;
            this.parent.sendEvent(41, event);
            event.gc = null;
            if (gc.isDisposed()) {
                return false;
            }
            gc.setAlpha(oldAlpha);
            gc.setAntialias(oldAntialias);
            gc.setBackgroundPattern(oldBackgroundPattern);
            gc.setForegroundPattern(oldForegroundPattern);
            gc.setInterpolation(oldInterpolation);
            gc.setTextAntialias(oldTextAntialias);
            gc.setAdvanced(oldAdvanced);
            if (this.isDisposed()) {
                return false;
            }
            if (this.parent.itemHeight != event.height) {
                this.parent.customHeightSet = true;
                boolean update = this.parent.setItemHeight(event.height + 2 * this.parent.getCellPadding());
                if (update) {
                    this.parent.redraw();
                }
            }
            if (this.parent.columns.length == 0) {
                int change = event.width - (this.customWidth != -1 ? this.customWidth : contentWidth);
                if (event.width != contentWidth || this.customWidth != -1) {
                    this.customWidth = event.width;
                }
                if (change != 0) {
                    this.parent.updateHorizontalBar(contentX + event.width, change);
                }
            }
        }
        Rectangle clientArea = this.parent.clientArea;
        if (clientArea.x + clientArea.width < x) {
            return false;
        }
        Rectangle cellBounds = this.getCellBounds(columnIndex);
        if (this.parent.linesVisible) {
            ++cellBounds.y;
            --cellBounds.height;
        }
        int cellRightX = 0;
        cellRightX = column != null ? column.getX() + column.width : cellBounds.x + cellBounds.width;
        gc.setClipping(x, cellBounds.y, clientArea.width - x, cellBounds.height);
        int y = this.parent.getItemY(this);
        int itemHeight = this.parent.itemHeight;
        if (column == null) {
            this.parent.drawBackground(gc, 0, y, clientArea.width, itemHeight);
        } else {
            int fillWidth2 = cellBounds.width;
            if (this.parent.linesVisible) {
                --fillWidth2;
            }
            this.parent.drawBackground(gc, cellBounds.x, cellBounds.y, fillWidth2, cellBounds.height);
        }
        boolean isSelected = this.isSelected();
        boolean isFocusItem = this.parent.focusItem == this;
        boolean drawBackground = true;
        boolean drawForeground = true;
        boolean drawSelection = isSelected;
        boolean drawFocus = isFocusItem;
        if (this.parent.hooks(40)) {
            drawBackground = this.background != null || this.cellBackgrounds != null && this.cellBackgrounds[columnIndex] != null;
            gc.setFont(this.getFont(columnIndex, false));
            if (isSelected && (columnIndex == 0 || (this.parent.style & 0x10000) != 0)) {
                gc.setForeground(this.display.getSystemColor(27));
                gc.setBackground(this.display.getSystemColor(26));
            } else {
                gc.setForeground(this.getForeground(columnIndex));
                gc.setBackground(this.getBackground(columnIndex));
            }
            Event event = new Event();
            event.item = this;
            event.gc = gc;
            event.index = columnIndex;
            event.doit = true;
            event.detail = 16;
            if (drawBackground) {
                event.detail |= 8;
            }
            if (isSelected) {
                event.detail |= 2;
            }
            if (isFocusItem) {
                event.detail |= 4;
            }
            event.x = cellBounds.x;
            event.y = cellBounds.y;
            event.width = cellBounds.width;
            event.height = cellBounds.height;
            gc.setClipping(cellBounds);
            this.parent.sendEvent(40, event);
            event.gc = null;
            if (gc.isDisposed()) {
                return false;
            }
            gc.setAlpha(oldAlpha);
            gc.setAntialias(oldAntialias);
            gc.setBackgroundPattern(oldBackgroundPattern);
            gc.setClipping(cellBounds);
            gc.setForegroundPattern(oldForegroundPattern);
            gc.setInterpolation(oldInterpolation);
            gc.setTextAntialias(oldTextAntialias);
            gc.setAdvanced(oldAdvanced);
            if (this.isDisposed()) {
                return false;
            }
            if (!event.doit) {
                drawFocus = false;
                drawSelection = false;
                drawForeground = false;
                drawBackground = false;
            } else {
                drawBackground = drawBackground && (event.detail & 8) != 0;
                drawForeground = (event.detail & 0x10) != 0;
                drawSelection = isSelected && (event.detail & 2) != 0;
                boolean bl = drawFocus = isFocusItem && (event.detail & 4) != 0;
            }
        }
        if (drawBackground) {
            gc.setBackground(this.getBackground(columnIndex));
            if (columnIndex == 0 && (column == null || column.getOrderIndex() == 0)) {
                Rectangle focusBounds = this.getFocusBounds();
                fillWidth = 0;
                if (column == null) {
                    fillWidth = focusBounds.width;
                } else {
                    fillWidth = column.width - focusBounds.x;
                    if (this.parent.linesVisible) {
                        --fillWidth;
                    }
                }
                gc.fillRectangle(focusBounds.x, focusBounds.y, fillWidth, focusBounds.height);
            } else {
                int fillWidth3 = cellBounds.width;
                gc.fillRectangle(cellBounds.x, cellBounds.y, fillWidth3, cellBounds.height);
            }
        }
        if (drawSelection && (columnIndex == 0 || (this.parent.style & 0x10000) != 0) && (this.parent.hasFocus() || (this.parent.style & 0x8000) == 0)) {
            gc.setBackground(this.display.getSystemColor(26));
            if (columnIndex == 0) {
                int fillWidth4;
                Rectangle focusBounds = this.getFocusBounds();
                int startX = column == null || column.getOrderIndex() == 0 || (this.parent.style & 0x10000) == 0 ? focusBounds.x + 1 : column.getX();
                if (column == null) {
                    fillWidth4 = focusBounds.width - 2;
                } else {
                    fillWidth4 = column.getX() + column.width - startX;
                    if (column.getOrderIndex() == this.parent.columns.length - 1 || (this.parent.style & 0x10000) == 0) {
                        fillWidth4 -= 2;
                    }
                }
                if (fillWidth4 > 0) {
                    gc.fillRectangle(startX, focusBounds.y + 1, fillWidth4, focusBounds.height - 2);
                }
            } else {
                int startX = column.getX();
                fillWidth = column.width;
                if (column.getOrderIndex() == 0) {
                    ++startX;
                    --fillWidth;
                }
                if (column.getOrderIndex() == this.parent.columns.length - 1) {
                    fillWidth -= 2;
                }
                if (fillWidth > 0) {
                    gc.fillRectangle(column.getX(), cellBounds.y + 1, fillWidth, cellBounds.height - 2);
                }
            }
        }
        if (backgroundOnly) {
            return false;
        }
        if (columnIndex == 0 && (this.parent.style & 0x20) != 0) {
            Image baseImage = this.grayed ? this.parent.getGrayUncheckedImage() : this.parent.getUncheckedImage();
            Rectangle checkboxBounds = this.getCheckboxBounds();
            gc.drawImage(baseImage, checkboxBounds.x, checkboxBounds.y);
            if (this.checked) {
                Image checkmarkImage = this.parent.getCheckmarkImage();
                Rectangle checkmarkBounds = checkmarkImage.getBounds();
                int xInset = (checkboxBounds.width - checkmarkBounds.width) / 2;
                int yInset = (checkboxBounds.height - checkmarkBounds.height) / 2;
                gc.drawImage(checkmarkImage, checkboxBounds.x + xInset, checkboxBounds.y + yInset);
            }
        }
        if (drawForeground) {
            Image image = this.getImage(columnIndex, false);
            String text = this.getDisplayText(columnIndex);
            Rectangle imageArea = this.getImageBounds(columnIndex);
            int startX = imageArea.x;
            int padding = this.parent.getCellPadding();
            gc.setClipping(startX, cellBounds.y + padding - (this.parent.linesVisible ? 1 : 0), cellRightX - startX - padding, cellBounds.height - 2 * (padding - (this.parent.linesVisible ? 1 : 0)));
            if (image != null) {
                Rectangle imageBounds = image.getBounds();
                gc.drawImage(image, 0, 0, imageBounds.width, imageBounds.height, imageArea.x, imageArea.y, imageArea.width, imageArea.height);
            }
            if (text.length() > 0) {
                gc.setFont(this.getFont(columnIndex, false));
                int fontHeight = this.getFontHeight(columnIndex);
                if (drawSelection && (columnIndex == 0 || (this.parent.style & 0x10000) != 0)) {
                    if (this.parent.hasFocus() || (this.parent.style & 0x8000) == 0) {
                        gc.setForeground(this.display.getSystemColor(27));
                    }
                } else if (!isSelected || drawSelection) {
                    gc.setForeground(this.getForeground(columnIndex));
                }
                x = this.getTextX(columnIndex) + 3;
                gc.drawString(text, x, y + (itemHeight - fontHeight) / 2, true);
            }
        }
        if (this.parent.hooks(42)) {
            int contentWidth = this.getContentWidth(columnIndex);
            int contentX = this.getContentX(columnIndex);
            gc.setFont(this.getFont(columnIndex, false));
            if (isSelected && (columnIndex == 0 || (this.parent.style & 0x10000) != 0)) {
                gc.setForeground(this.display.getSystemColor(27));
                gc.setBackground(this.display.getSystemColor(26));
            } else {
                gc.setForeground(this.getForeground(columnIndex));
                gc.setBackground(this.getBackground(columnIndex));
            }
            Event event = new Event();
            event.item = this;
            event.gc = gc;
            event.index = columnIndex;
            if (isSelected) {
                event.detail |= 2;
            }
            if (drawFocus) {
                event.detail |= 4;
            }
            event.x = contentX;
            event.y = cellBounds.y;
            event.width = contentWidth;
            event.height = cellBounds.height;
            gc.setClipping(cellBounds);
            this.parent.sendEvent(42, event);
            event.gc = null;
            if (gc.isDisposed()) {
                return false;
            }
            gc.setAlpha(oldAlpha);
            gc.setAntialias(oldAntialias);
            gc.setBackgroundPattern(oldBackgroundPattern);
            gc.setClipping(cellBounds);
            gc.setForegroundPattern(oldForegroundPattern);
            gc.setInterpolation(oldInterpolation);
            gc.setTextAntialias(oldTextAntialias);
            gc.setAdvanced(oldAdvanced);
            boolean bl = drawFocus = isFocusItem && (event.detail & 4) != 0;
        }
        return isFocusItem && !drawFocus;
    }

    void redraw(int x, int y, int width, int height, int columnIndex) {
        if (!this.parent.hooks(40) && !this.parent.hooks(42)) {
            this.parent.redraw(x, y, width, height, false);
            return;
        }
        Rectangle cellBounds = this.getCellBounds(columnIndex);
        this.parent.redraw(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height, false);
    }

    void redrawItem() {
        this.parent.redraw(0, this.parent.getItemY(this), this.parent.clientArea.width, this.parent.itemHeight, false);
    }

    void removeColumn(TableColumn column, int index) {
        int columnCount = this.parent.columns.length;
        if (columnCount == 0) {
            this.cellForegrounds = null;
            this.cellBackgrounds = null;
            this.displayTexts = null;
            this.cellFonts = null;
            this.fontHeights = null;
            GC gc = new GC(this.parent);
            this.computeTextWidths(gc);
            gc.dispose();
            return;
        }
        String[] newTexts = new String[columnCount];
        System.arraycopy(this.texts, 0, newTexts, 0, index);
        System.arraycopy(this.texts, index + 1, newTexts, index, columnCount - index);
        this.texts = newTexts;
        Image[] newImages = new Image[columnCount];
        System.arraycopy(this.images, 0, newImages, 0, index);
        System.arraycopy(this.images, index + 1, newImages, index, columnCount - index);
        this.images = newImages;
        int[] newTextWidths = new int[columnCount];
        System.arraycopy(this.textWidths, 0, newTextWidths, 0, index);
        System.arraycopy(this.textWidths, index + 1, newTextWidths, index, columnCount - index);
        this.textWidths = newTextWidths;
        String[] newDisplayTexts = new String[columnCount];
        System.arraycopy(this.displayTexts, 0, newDisplayTexts, 0, index);
        System.arraycopy(this.displayTexts, index + 1, newDisplayTexts, index, columnCount - index);
        this.displayTexts = newDisplayTexts;
        if (this.cellBackgrounds != null) {
            Color[] newCellBackgrounds = new Color[columnCount];
            System.arraycopy(this.cellBackgrounds, 0, newCellBackgrounds, 0, index);
            System.arraycopy(this.cellBackgrounds, index + 1, newCellBackgrounds, index, columnCount - index);
            this.cellBackgrounds = newCellBackgrounds;
        }
        if (this.cellForegrounds != null) {
            Color[] newCellForegrounds = new Color[columnCount];
            System.arraycopy(this.cellForegrounds, 0, newCellForegrounds, 0, index);
            System.arraycopy(this.cellForegrounds, index + 1, newCellForegrounds, index, columnCount - index);
            this.cellForegrounds = newCellForegrounds;
        }
        if (this.cellFonts != null) {
            Font[] newCellFonts = new Font[columnCount];
            System.arraycopy(this.cellFonts, 0, newCellFonts, 0, index);
            System.arraycopy(this.cellFonts, index + 1, newCellFonts, index, columnCount - index);
            this.cellFonts = newCellFonts;
            int[] newFontHeights = new int[columnCount];
            System.arraycopy(this.fontHeights, 0, newFontHeights, 0, index);
            System.arraycopy(this.fontHeights, index + 1, newFontHeights, index, columnCount - index);
            this.fontHeights = newFontHeights;
        }
        if (index == 0) {
            this.text = this.texts[0] != null ? this.texts[0] : "";
            this.texts[0] = null;
            this.image = this.images[0];
            this.images[0] = null;
            if ((this.parent.style & 0x20) != 0) {
                GC gc = new GC(this.parent);
                gc.setFont(this.getFont(0, false));
                this.computeDisplayText(0, gc);
                gc.dispose();
            }
        }
        if (columnCount < 2) {
            this.texts = null;
            this.images = null;
        }
    }

    public void setBackground(Color value) {
        this.checkWidget();
        if (value != null && value.isDisposed()) {
            SWT.error(5);
        }
        if (this.background == value) {
            return;
        }
        if (this.background != null && this.background.equals(value)) {
            return;
        }
        this.background = value;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redrawItem();
    }

    public void setBackground(int columnIndex, Color value) {
        this.checkWidget();
        if (value != null && value.isDisposed()) {
            SWT.error(5);
        }
        int validColumnCount = Math.max(1, this.parent.columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return;
        }
        if (this.cellBackgrounds == null) {
            this.cellBackgrounds = new Color[validColumnCount];
        }
        if (this.cellBackgrounds[columnIndex] == value) {
            return;
        }
        if (this.cellBackgrounds[columnIndex] != null && this.cellBackgrounds[columnIndex].equals(value)) {
            return;
        }
        this.cellBackgrounds[columnIndex] = value;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.isInViewport()) {
            Rectangle bounds = this.getCellBounds(columnIndex);
            this.parent.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
        }
    }

    public void setChecked(boolean value) {
        this.checkWidget();
        if ((this.parent.getStyle() & 0x20) == 0) {
            return;
        }
        if (this.checked == value) {
            return;
        }
        this.checked = value;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.isInViewport()) {
            if (this.parent.hooks(40) || this.parent.hooks(42)) {
                this.redrawItem();
            } else {
                Rectangle bounds = this.getCheckboxBounds();
                this.parent.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
            }
        }
    }

    public void setFont(Font value) {
        this.checkWidget();
        if (value != null && value.isDisposed()) {
            SWT.error(5);
        }
        if (this.font == value) {
            return;
        }
        if (value != null && value.equals(this.font)) {
            return;
        }
        Rectangle bounds = this.getBounds(false);
        int oldRightX = bounds.x + bounds.width;
        this.font = value;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        GC gc = new GC(this.parent);
        gc.setFont(this.getFont(false));
        this.fontHeight = gc.getFontMetrics().getHeight();
        this.computeDisplayTexts(gc);
        this.computeTextWidths(gc);
        gc.dispose();
        if (this.parent.columns.length == 0) {
            bounds = this.getBounds(false);
            int newRightX = bounds.x + bounds.width;
            this.parent.updateHorizontalBar(newRightX, newRightX - oldRightX);
        }
        this.redrawItem();
    }

    public void setFont(int columnIndex, Font value) {
        this.checkWidget();
        if (value != null && value.isDisposed()) {
            SWT.error(5);
        }
        int validColumnCount = Math.max(1, this.parent.columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return;
        }
        if (this.cellFonts == null) {
            if (value == null) {
                return;
            }
            this.cellFonts = new Font[validColumnCount];
        }
        if (this.cellFonts[columnIndex] == value) {
            return;
        }
        if (this.cellFonts[columnIndex] != null && this.cellFonts[columnIndex].equals(value)) {
            return;
        }
        this.cellFonts[columnIndex] = value;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        GC gc = new GC(this.parent);
        gc.setFont(this.getFont(columnIndex, false));
        if (this.fontHeights == null) {
            this.fontHeights = new int[validColumnCount];
        }
        this.fontHeights[columnIndex] = gc.getFontMetrics().getHeight();
        this.computeDisplayText(columnIndex, gc);
        gc.dispose();
        if (this.isInViewport()) {
            Rectangle bounds = this.getCellBounds(columnIndex);
            this.parent.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
        }
    }

    public void setForeground(Color value) {
        this.checkWidget();
        if (value != null && value.isDisposed()) {
            SWT.error(5);
        }
        if (this.foreground == value) {
            return;
        }
        if (this.foreground != null && this.foreground.equals(value)) {
            return;
        }
        this.foreground = value;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redrawItem();
    }

    public void setForeground(int columnIndex, Color value) {
        this.checkWidget();
        if (value != null && value.isDisposed()) {
            SWT.error(5);
        }
        int validColumnCount = Math.max(1, this.parent.columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return;
        }
        if (this.cellForegrounds == null) {
            this.cellForegrounds = new Color[validColumnCount];
        }
        if (this.cellForegrounds[columnIndex] == value) {
            return;
        }
        if (this.cellForegrounds[columnIndex] != null && this.cellForegrounds[columnIndex].equals(value)) {
            return;
        }
        this.cellForegrounds[columnIndex] = value;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.isInViewport()) {
            this.redraw(this.getTextX(columnIndex), this.parent.getItemY(this), this.textWidths[columnIndex] + 6, this.parent.itemHeight, columnIndex);
        }
    }

    public void setGrayed(boolean value) {
        this.checkWidget();
        if ((this.parent.getStyle() & 0x20) == 0) {
            return;
        }
        if (this.grayed == value) {
            return;
        }
        this.grayed = value;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.isInViewport()) {
            Rectangle bounds = this.getCheckboxBounds();
            this.parent.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
        }
    }

    public void setImage(Image value) {
        this.checkWidget();
        this.setImage(0, value);
    }

    public void setImage(Image[] value) {
        this.checkWidget();
        if (value == null) {
            this.error(4);
        }
        int i = 0;
        while (i < value.length) {
            if (value[i] != null) {
                this.setImage(i, value[i]);
            }
            ++i;
        }
    }

    public void setImage(int columnIndex, Image value) {
        GC gc;
        this.checkWidget();
        if (value != null && value.isDisposed()) {
            this.error(5);
        }
        TableColumn[] columns = this.parent.columns;
        int validColumnCount = Math.max(1, columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return;
        }
        Image image = this.getImage(columnIndex, false);
        if (value == image) {
            return;
        }
        if (value != null && value.equals(image)) {
            return;
        }
        if (columnIndex == 0) {
            super.setImage(value);
        } else {
            this.images[columnIndex] = value;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (columns.length > 0) {
            gc = new GC(this.parent);
            gc.setFont(this.getFont(columnIndex, false));
            this.computeDisplayText(columnIndex, gc);
            gc.dispose();
        }
        if (value == null) {
            this.redrawItem();
            return;
        }
        if (this.parent.imageHeight == 0) {
            int oldItemHeight = this.parent.itemHeight;
            this.parent.setImageHeight(value.getBounds().height);
            if (oldItemHeight != this.parent.itemHeight) {
                if (columnIndex == 0) {
                    this.parent.col0ImageWidth = value.getBounds().width;
                    if (columns.length > 0) {
                        GC gc2 = new GC(this.parent);
                        TableItem[] rootItems = this.parent.items;
                        int i = 0;
                        while (i < this.parent.itemsCount) {
                            rootItems[i].updateColumnWidth(columns[0], gc2);
                            ++i;
                        }
                        gc2.dispose();
                    }
                }
                this.parent.redraw();
                return;
            }
        }
        if (columnIndex == 0 && this.parent.col0ImageWidth == 0) {
            this.parent.col0ImageWidth = value.getBounds().width;
            if (columns.length == 0) {
                this.parent.redraw();
            } else {
                gc = new GC(this.parent);
                TableItem[] rootItems = this.parent.items;
                int i = 0;
                while (i < this.parent.itemsCount) {
                    rootItems[i].updateColumnWidth(columns[0], gc);
                    ++i;
                }
                gc.dispose();
                this.parent.redraw(columns[0].getX(), 0, columns[0].width, this.parent.clientArea.height, true);
            }
            return;
        }
        this.redrawItem();
    }

    public void setImageIndent(int indent) {
        this.checkWidget();
        if (indent < 0) {
            return;
        }
        if (this.imageIndent == indent) {
            return;
        }
        this.imageIndent = indent;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setText(int columnIndex, String value) {
        this.checkWidget();
        if (value == null) {
            this.error(4);
        }
        int validColumnCount = Math.max(1, this.parent.columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return;
        }
        if (value.equals(this.getText(columnIndex, false))) {
            return;
        }
        if (columnIndex == 0) {
            super.setText(value);
        } else {
            this.texts[columnIndex] = value;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        int oldWidth = this.textWidths[columnIndex];
        GC gc = new GC(this.parent);
        gc.setFont(this.getFont(columnIndex, false));
        this.computeDisplayText(columnIndex, gc);
        gc.dispose();
        if (this.parent.columns.length == 0) {
            Rectangle bounds = this.getBounds(false);
            int rightX = bounds.x + bounds.width;
            this.parent.updateHorizontalBar(rightX, this.textWidths[columnIndex] - oldWidth);
        }
        if (this.isInViewport()) {
            this.redraw(this.getTextX(columnIndex), this.parent.getItemY(this), Math.max(oldWidth, this.textWidths[columnIndex]) + 6, this.parent.itemHeight, columnIndex);
        }
    }

    public void setText(String value) {
        this.checkWidget();
        Rectangle bounds = this.getBounds(false);
        int oldRightX = bounds.x + bounds.width;
        this.setText(0, value);
        if (this.parent.columns.length == 0) {
            bounds = this.getBounds(false);
            int newRightX = bounds.x + bounds.width;
            this.parent.updateHorizontalBar(newRightX, newRightX - oldRightX);
        }
    }

    public void setText(String[] value) {
        this.checkWidget();
        if (value == null) {
            this.error(4);
        }
        Rectangle bounds = this.getBounds(false);
        int oldRightX = bounds.x + bounds.width;
        int i = 0;
        while (i < value.length) {
            if (value[i] != null) {
                this.setText(i, value[i]);
            }
            ++i;
        }
        if (this.parent.columns.length == 0) {
            bounds = this.getBounds(false);
            int newRightX = bounds.x + bounds.width;
            this.parent.updateHorizontalBar(newRightX, newRightX - oldRightX);
        }
    }

    void updateColumnWidth(TableColumn column, GC gc) {
        int columnIndex = column.getIndex();
        gc.setFont(this.getFont(columnIndex, false));
        String oldDisplayText = this.displayTexts[columnIndex];
        this.computeDisplayText(columnIndex, gc);
        if (this.isInViewport()) {
            boolean columnIsLeft;
            boolean bl = columnIsLeft = (column.style & 0x4000) != 0;
            if (!columnIsLeft || this.parent.hooks(40) || this.parent.hooks(42)) {
                Rectangle cellBounds = this.getCellBounds(columnIndex);
                this.parent.redraw(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height, false);
                return;
            }
            if (oldDisplayText == null || !oldDisplayText.equals(this.displayTexts[columnIndex])) {
                Rectangle cellBounds = this.getCellBounds(columnIndex);
                int textX = this.getTextX(columnIndex);
                this.parent.redraw(textX, cellBounds.y, cellBounds.x + cellBounds.width - textX, cellBounds.height, false);
            }
        }
    }

    void updateFont(GC gc) {
        if (this.font == null) {
            this.computeDisplayTexts(gc);
            this.computeTextWidths(gc);
        }
    }
}

