/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.dom.DOMDocumentFactory;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.jfreereport.castormodel.jfree.types.AlignmentEnum;
import org.pentaho.jfreereport.castormodel.jfree.types.PageFormats;
import org.pentaho.jfreereport.castormodel.reportspec.Field;
import org.pentaho.jfreereport.castormodel.reportspec.ReportSpec;
import org.pentaho.jfreereport.wizard.utility.CastorUtility;
import org.pentaho.jfreereport.wizard.utility.report.ReportGenerationUtility;
import org.pentaho.jfreereport.wizard.utility.report.ReportSpecUtility;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.concept.types.Alignment;
import org.pentaho.metadata.model.concept.types.Color;
import org.pentaho.metadata.model.concept.types.ColumnWidth;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.model.concept.types.Font;
import org.pentaho.metadata.query.model.Query;
import org.pentaho.metadata.query.model.util.QueryXmlHelper;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IMessageFormatter;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.engine.ISolutionEngine;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.engine.ISolutionFilter;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.api.repository.ISolutionRepositoryService;
import org.pentaho.platform.api.util.XmlParseException;
import org.pentaho.platform.engine.core.output.SimpleOutputHandler;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.StandaloneApplicationContext;
import org.pentaho.platform.engine.services.WebServiceUtil;
import org.pentaho.platform.engine.services.solution.PentahoEntityResolver;
import org.pentaho.platform.uifoundation.component.xml.PMDUIComponent;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.web.MimeHelper;
import org.pentaho.platform.util.web.SimpleUrlFactory;
import org.pentaho.platform.util.xml.XmlHelper;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.pentaho.platform.web.http.PentahoHttpSessionHelper;
import org.pentaho.platform.web.http.request.HttpRequestParameterProvider;
import org.pentaho.platform.web.servlet.AdhocWebServiceException;
import org.pentaho.platform.web.servlet.AdhocWebServiceInteract;
import org.pentaho.platform.web.servlet.HttpMimeTypeListener;
import org.pentaho.platform.web.servlet.ServletBase;
import org.pentaho.platform.web.servlet.messages.Messages;
import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.schema.concept.DefaultPropertyID;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdhocWebService
extends ServletBase {
    private static final long serialVersionUID = -2011812808062152707L;
    private static final Log logger = LogFactory.getLog(AdhocWebService.class);
    private static final String WAQR_EXTENSION = "waqr";
    private static final Field DEFAULT_FIELD_PROPS = new Field();
    private static final String RE_GET_BASE_WAQR_FILENAME = "^(.*)\\.waqr\\.xreportspec$";
    private static final Pattern BASE_WAQR_FILENAME_PATTERN = Pattern.compile("^(.*)\\.waqr\\.xreportspec$");
    private static final String SOLUTION_NAVIGATION_DOCUMENT_MAP = "AdhocWebService.SOLUTION_NAVIGATION_DOCUMENT_MAP";
    private static final String FULL_SOLUTION_DOC = "AdhocWebService.FULL_SOLUTION_DOC";
    private static final String NOT_SET_VALUE = "not-set";
    private static final String METADATA_PROPERTY_ID_VERTICAL_ALIGNMENT = "vertical-alignment";
    private static final String WAQR_REPOSITORY_PATH = "/system/waqr";
    private static final Map<DataType, String> METADATA_TYPE_TO_REPORT_SPEC_TYPE = new HashMap<DataType, String>();
    private static final Set<Integer> PERCENT_SET;

    @Override
    public Log getLogger() {
        return logger;
    }

    public String getPayloadAsString(HttpServletRequest request) throws IOException {
        ServletInputStream is = request.getInputStream();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        String content = null;
        byte[] buffer = new byte[2048];
        int b = is.read(buffer);
        while (b > 0) {
            os.write(buffer, 0, b);
            b = is.read(buffer);
        }
        content = os.toString(LocaleHelper.getSystemEncoding());
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PentahoSystem.systemEntryPoint();
        ServletOutputStream outputStream = response.getOutputStream();
        try {
            boolean wrapWithSoap = "false".equals(request.getParameter("ajax"));
            String solutionName = request.getParameter("solution");
            String actionPath = request.getParameter("path");
            String actionName = request.getParameter("action");
            String component = request.getParameter("component");
            String content = null;
            try {
                content = this.getPayloadAsString(request);
            }
            catch (IOException ioEx) {
                String msg = Messages.getErrorString("AdhocWebService.ERROR_0006_FAILED_TO_GET_PAYLOAD_FROM_REQUEST");
                this.error(msg, ioEx);
                WebServiceUtil.writeString((OutputStream)outputStream, (String)WebServiceUtil.getErrorXml((String)(msg + " " + ioEx.getLocalizedMessage())), (boolean)false);
            }
            HttpRequestParameterProvider parameterProvider = null;
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (!StringUtils.isEmpty((String)content)) {
                Document doc = null;
                try {
                    doc = XmlDom4JHelper.getDocFromString((String)content, (EntityResolver)new PentahoEntityResolver());
                }
                catch (XmlParseException e) {
                    String msg = Messages.getErrorString("HttpWebService.ERROR_0001_ERROR_DURING_WEB_SERVICE");
                    this.error(msg, e);
                    WebServiceUtil.writeString((OutputStream)response.getOutputStream(), (String)WebServiceUtil.getErrorXml((String)msg), (boolean)false);
                }
                List parameterNodes = doc.selectNodes("//SOAP-ENV:Body/*/*");
                for (int i = 0; i < parameterNodes.size(); ++i) {
                    Node parameterNode = (Node)parameterNodes.get(i);
                    String parameterName = parameterNode.getName();
                    String parameterValue = parameterNode.getText();
                    if ("action".equals(parameterName)) {
                        ActionInfo info = ActionInfo.parseActionString((String)parameterValue);
                        solutionName = info.getSolutionName();
                        actionPath = info.getPath();
                        actionName = info.getActionName();
                        parameters.put("solution", solutionName);
                        parameters.put("path", actionPath);
                        parameters.put("name", actionName);
                        continue;
                    }
                    if ("component".equals(parameterName)) {
                        component = parameterValue;
                        continue;
                    }
                    parameters.put(parameterName, parameterValue);
                }
                parameterProvider = new SimpleParameterProvider(parameters);
            } else {
                parameterProvider = new HttpRequestParameterProvider(request);
            }
            if (!"generatePreview".equals(component)) {
                response.setContentType("text/xml");
                response.setCharacterEncoding(LocaleHelper.getSystemEncoding());
            }
            IPentahoSession userSession = this.getPentahoSession(request);
            response.setHeader("expires", "0");
            this.dispatch(request, response, component, (IParameterProvider)parameterProvider, (OutputStream)outputStream, userSession, wrapWithSoap);
        }
        catch (IOException ioEx) {
            String msg = Messages.getErrorString("HttpWebService.ERROR_0001_ERROR_DURING_WEB_SERVICE");
            this.error(msg, ioEx);
            WebServiceUtil.writeString((OutputStream)outputStream, (String)WebServiceUtil.getErrorXml((String)msg), (boolean)false);
        }
        catch (AdhocWebServiceException ex) {
            String msg = ex.getLocalizedMessage();
            this.error(msg, (Throwable)((Object)ex));
            WebServiceUtil.writeString((OutputStream)outputStream, (String)WebServiceUtil.getErrorXml((String)msg), (boolean)false);
        }
        catch (PentahoMetadataException ex) {
            String msg = ex.getLocalizedMessage();
            this.error(msg, ex);
            WebServiceUtil.writeString((OutputStream)outputStream, (String)WebServiceUtil.getErrorXml((String)msg), (boolean)false);
        }
        catch (PentahoAccessControlException ex) {
            String msg = ex.getLocalizedMessage();
            this.error(msg, ex);
            WebServiceUtil.writeString((OutputStream)outputStream, (String)WebServiceUtil.getErrorXml((String)msg), (boolean)false);
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
        this.debug(Messages.getString("HttpWebService.DEBUG_WEB_SERVICE_END"));
    }

    protected void dispatch(HttpServletRequest request, HttpServletResponse response, String component, IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession, boolean wrapWithSoap) throws IOException, AdhocWebServiceException, PentahoMetadataException, PentahoAccessControlException {
        if ("listbusinessmodels".equals(component)) {
            this.listBusinessModels(parameterProvider, outputStream, userSession, wrapWithSoap);
        } else if ("getbusinessmodel".equals(component)) {
            this.getBusinessModel(parameterProvider, outputStream, userSession, wrapWithSoap);
        } else if ("generatePreview".equals(component)) {
            this.generatePreview(request, response, parameterProvider, outputStream, userSession, wrapWithSoap);
        } else if ("saveFile".equals(component)) {
            this.saveFile(parameterProvider, outputStream, userSession, wrapWithSoap);
        } else if ("searchTable".equals(component)) {
            this.searchTable(parameterProvider, outputStream, userSession, wrapWithSoap);
        } else if ("getWaqrReportSpecDoc".equals(component)) {
            this.getWaqrReportSpecDoc(parameterProvider, outputStream, userSession, wrapWithSoap);
        } else if ("getTemplateReportSpec".equals(component)) {
            this.getTemplateReportSpec(parameterProvider, outputStream, userSession, wrapWithSoap);
        } else if ("getSolutionRepositoryDoc".equals(component)) {
            String path = parameterProvider.getStringParameter("path", null);
            String solutionName = parameterProvider.getStringParameter("solution", null);
            Document doc = this.getSolutionRepositoryDoc(solutionName, path, userSession);
            WebServiceUtil.writeDocument((OutputStream)outputStream, (Document)doc, (boolean)wrapWithSoap);
        } else if ("getWaqrRepositoryDoc".equals(component)) {
            String folderPath = parameterProvider.getStringParameter("folderPath", null);
            Document doc = this.getWaqrRepositoryDoc(folderPath, userSession);
            WebServiceUtil.writeDocument((OutputStream)outputStream, (Document)doc, (boolean)wrapWithSoap);
        } else if ("getWaqrRepositoryIndexDoc".equals(component)) {
            this.getWaqrRepositoryIndexDoc(parameterProvider, outputStream, userSession, wrapWithSoap);
        } else if ("deleteWaqrReport".equals(component)) {
            this.deleteWaqrReport(parameterProvider, outputStream, userSession, wrapWithSoap);
        } else if ("getJFreePaperSizes".equals(component)) {
            this.getJFreePaperSizes(parameterProvider, outputStream, userSession, wrapWithSoap);
        } else {
            throw new RuntimeException(Messages.getErrorString("HttpWebService.UNRECOGNIZED_COMPONENT_REQUEST", component));
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private void getJFreePaperSizes(IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession, boolean wrapWithSoap) throws IOException {
        StringBuffer xmlStr = new StringBuffer();
        Enumeration pageFormatsEnum = PageFormats.enumerate();
        xmlStr.append("<pageFormats>\n");
        while (pageFormatsEnum.hasMoreElements()) {
            PageFormats pf = (PageFormats)pageFormatsEnum.nextElement();
            xmlStr.append("\t<pageFormat name='" + AdhocWebService.toFriendlyName(pf.toString()) + "' value='" + pf.toString() + "'/>\n");
        }
        xmlStr.append("</pageFormats>\n");
        WebServiceUtil.writeString((OutputStream)outputStream, (String)xmlStr.toString(), (boolean)wrapWithSoap);
    }

    private static String toFriendlyName(String name) {
        StringBuffer friendlyName = new StringBuffer();
        String[] components = name.split("_");
        for (int ii = 0; ii < components.length; ++ii) {
            String component = components[ii];
            friendlyName.append(component);
            if (ii >= components.length - 1) continue;
            friendlyName.append(" ");
        }
        return friendlyName.toString();
    }

    private void generatePreview(HttpServletRequest request, HttpServletResponse response, IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession, boolean wrapWithSoap) throws IOException, AdhocWebServiceException, PentahoMetadataException {
        String outputType = parameterProvider.getStringParameter("outputType", null);
        String mimeType = MimeHelper.getMimeTypeFromExtension((String)("." + outputType));
        HttpMimeTypeListener listener = new HttpMimeTypeListener(request, response);
        listener.setMimeType(mimeType);
        listener.setName(Messages.getString("AdhocWebService.USER_REPORT_PREVIEW"));
        String reportXML = URLDecoder.decode(parameterProvider.getStringParameter("reportXml", null), "UTF-8");
        String templatePath = parameterProvider.getStringParameter("templatePath", null);
        try {
            boolean interactive = "true".equals(parameterProvider.getStringParameter("interactive", null));
            this.createJFreeReportAsStream(reportXML, templatePath, outputType, outputStream, userSession, "debug", wrapWithSoap, interactive);
        }
        catch (Exception e) {
            response.setContentType("text/html");
            String msg = Messages.getString("AdhocWebService.ERROR_0012_FAILED_TO_GENERATE_PREVIEW");
            outputStream.write(AdhocWebService.getErrorHtml(request, e, msg).getBytes());
            this.error(msg, e);
        }
    }

    private void createJFreeReportAsStream(String reportXML, String templatePath, String outputType, OutputStream outputStream, IPentahoSession userSession, String loggingLevel, boolean wrapWithSoap, boolean interactive) throws AdhocWebServiceException, IOException, PentahoMetadataException {
        if (StringUtil.doesPathContainParentPathSegment((String)templatePath)) {
            String msg = Messages.getString("AdhocWebService.ERROR_0008_MISSING_OR_INVALID_REPORT_NAME");
            throw new AdhocWebServiceException(msg);
        }
        Document reportSpecDoc = null;
        try {
            reportSpecDoc = XmlDom4JHelper.getDocFromString((String)reportXML, (EntityResolver)new PentahoEntityResolver());
        }
        catch (XmlParseException e) {
            String msg = Messages.getErrorString("HttpWebService.ERROR_0001_ERROR_DURING_WEB_SERVICE");
            this.error(msg, e);
            throw new AdhocWebServiceException(msg, e);
        }
        Element mqlNode = (Element)reportSpecDoc.selectSingleNode("/report-spec/query/mql");
        mqlNode.detach();
        Node reportNameNd = reportSpecDoc.selectSingleNode("/report-spec/report-name");
        String reportName = null != reportNameNd ? reportNameNd.getText() : "";
        Node reportDescNd = reportSpecDoc.selectSingleNode("/report-spec/report-desc");
        String reportDesc = reportDescNd.getText();
        String[] outputTypeList = new String[]{outputType};
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)userSession);
        String xactionFilename = userSession.getId() + "_wqr_preview.xaction";
        ByteArrayOutputStream jfreeOutputStream = new ByteArrayOutputStream();
        this.createJFreeReportDefinitionAsStream(reportXML, templatePath, mqlNode, repository, userSession, jfreeOutputStream);
        ByteArrayOutputStream xactionOutputStream = this.createMQLReportActionSequenceAsStream(reportName, reportDesc, mqlNode, outputTypeList, xactionFilename, jfreeOutputStream.toString(LocaleHelper.getSystemEncoding()), null, loggingLevel, userSession);
        SimpleParameterProvider actionSequenceParameterProvider = new SimpleParameterProvider();
        actionSequenceParameterProvider.setParameter("type", outputType);
        actionSequenceParameterProvider.setParameter("logging-level", "error");
        actionSequenceParameterProvider.setParameter("level", "error");
        OutputStream out = interactive ? new ByteArrayOutputStream() : outputStream;
        IRuntimeContext runtimeContext = AdhocWebService.executeActionSequence(xactionOutputStream.toString(LocaleHelper.getSystemEncoding()), "preview.xaction", (IParameterProvider)actionSequenceParameterProvider, userSession, out);
        if (runtimeContext != null) {
            runtimeContext.dispose();
        }
        if (interactive) {
            AdhocWebServiceInteract.interactiveOutput(out.toString(), outputStream, userSession);
        }
    }

    private static String getJFreeColorString(Color color) {
        String b;
        String g;
        if (color == null) {
            return "#FF0000";
        }
        String r = Integer.toHexString(color.getRed());
        if (r.length() == 1) {
            r = "0" + r;
        }
        if ((g = Integer.toHexString(color.getGreen())).length() == 1) {
            g = "0" + g;
        }
        if ((b = Integer.toHexString(color.getBlue())).length() == 1) {
            b = "0" + b;
        }
        return "#" + r + g + b;
    }

    private static void startup(String solutionRootPath, String fullyQualifiedServerUrl) {
        LocaleHelper.setLocale((Locale)Locale.getDefault());
        PentahoSystem.loggingLevel = 5;
        if (PentahoSystem.getApplicationContext() == null) {
            StandaloneApplicationContext applicationContext = new StandaloneApplicationContext(solutionRootPath, "");
            applicationContext.setFullyQualifiedServerURL(fullyQualifiedServerUrl);
            System.setProperty("java.naming.factory.initial", "org.osjava.sj.SimpleContextFactory");
            System.setProperty("org.osjava.sj.root", solutionRootPath + "/system/simple-jndi");
            System.setProperty("org.osjava.sj.delimiter", "/");
            PentahoSystem.init((IApplicationContext)applicationContext);
        }
    }

    public static IRuntimeContext executeActionSequence(String xactionStr, String xActionName, IParameterProvider parameterProvider, IPentahoSession session, OutputStream outputStream) {
        IRuntimeContext runtimeContext = null;
        AdhocWebService.startup(null, null);
        ArrayList messages = new ArrayList();
        String instanceId = null;
        IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
        ISolutionEngine solutionEngine = (ISolutionEngine)PentahoSystem.get(ISolutionEngine.class, (IPentahoSession)session);
        solutionEngine.setLoggingLevel(5);
        solutionEngine.init(session);
        HashMap<String, IParameterProvider> parameterProviderMap = new HashMap<String, IParameterProvider>();
        parameterProviderMap.put("request", parameterProvider);
        SimpleUrlFactory urlFactory = new SimpleUrlFactory(requestContext.getContextPath());
        SimpleOutputHandler outputHandler = new SimpleOutputHandler(outputStream, false);
        solutionEngine.setSession(session);
        runtimeContext = solutionEngine.execute(xactionStr, "preview.xaction", "Adhoc Reporting", false, true, instanceId, false, parameterProviderMap, (IOutputHandler)outputHandler, null, (IPentahoUrlFactory)urlFactory, messages);
        if (6 != solutionEngine.getStatus()) {
            try {
                outputStream.write(Messages.getErrorString("AdhocWebService.ERROR_0012_FAILED_TO_GENERATE_PREVIEW").getBytes());
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        return runtimeContext;
    }

    private static boolean isDefaultStringProperty(String property) {
        return StringUtils.isEmpty((String)property);
    }

    private static boolean isNotSetStringProperty(String property) {
        return NOT_SET_VALUE.equals(property);
    }

    public void createJFreeReportDefinitionAsStream(String reportXML, String templatePath, Element mqlNode, ISolutionRepository repository, IPentahoSession userSession, OutputStream jfreeMergedOutputStream) throws IOException, AdhocWebServiceException, PentahoMetadataException {
        boolean bUseTemplate;
        HashMap<String, Element> reportSpecTypeToElement = null;
        Document templateDoc = null;
        Element templateItems = null;
        boolean bl = bUseTemplate = !StringUtils.isEmpty((String)templatePath);
        if (bUseTemplate) {
            templatePath = WAQR_REPOSITORY_PATH + templatePath;
            templateDoc = repository.getResourceAsDocument(templatePath, 1);
            templateItems = (Element)templateDoc.selectSingleNode("/report/items");
            List nodes = templateItems.elements();
            Iterator it = nodes.iterator();
            reportSpecTypeToElement = new HashMap<String, Element>();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                reportSpecTypeToElement.put(element.getName(), element);
            }
        }
        String xml = mqlNode.asXML();
        QueryXmlHelper helper = new QueryXmlHelper();
        IMetadataDomainRepository repo = (IMetadataDomainRepository)PentahoSystem.get(IMetadataDomainRepository.class, null);
        Query queryObject = null;
        try {
            queryObject = helper.fromXML(repo, xml);
        }
        catch (Exception e) {
            String msg = Messages.getErrorString("HttpWebService.ERROR_0001_ERROR_DURING_WEB_SERVICE");
            this.error(msg, e);
            throw new AdhocWebServiceException(msg, e);
        }
        LogicalModel model = null;
        if (queryObject != null) {
            model = queryObject.getLogicalModel();
        }
        if (model == null) {
            throw new AdhocWebServiceException(Messages.getErrorString("AdhocWebService.ERROR_0003_BUSINESS_VIEW_INVALID"));
        }
        String locale = LocaleHelper.getClosestLocale((String)LocaleHelper.getLocale().toString(), (String[])queryObject.getDomain().getLocaleCodes());
        String reportXMLEncoding = XmlHelper.getEncoding((String)reportXML);
        ByteArrayInputStream reportSpecInputStream = new ByteArrayInputStream(reportXML.getBytes(reportXMLEncoding));
        ReportSpec reportSpec = (ReportSpec)CastorUtility.getInstance().readCastorObject((InputStream)reportSpecInputStream, ReportSpec.class, reportXMLEncoding);
        if (reportSpec == null) {
            throw new AdhocWebServiceException(Messages.getErrorString("AdhocWebService.ERROR_0002_REPORT_INVALID"));
        }
        LogicalColumn[] columns = new LogicalColumn[reportSpec.getField().length];
        for (int i = 0; i < reportSpec.getField().length; ++i) {
            Field field = reportSpec.getField()[i];
            String name = field.getName();
            LogicalColumn column = model.findLogicalColumn(name);
            columns[i] = (LogicalColumn)column.clone();
        }
        boolean columnWidthUnitsConsistent = AdhocWebService.areMetadataColumnUnitsConsistent(reportSpec, model);
        if (!columnWidthUnitsConsistent) {
            logger.error((Object)Messages.getErrorString("AdhocWebService.ERROR_0013_INCONSISTENT_COLUMN_WIDTH_UNITS"));
        } else {
            ColumnWidth property;
            int i;
            double columnWidthScaleFactor = 1.0;
            int missingColumnWidthCount = 0;
            int columnWidthSumOfPercents = AdhocWebService.getSumOfMetadataColumnWidths(reportSpec, model);
            missingColumnWidthCount = AdhocWebService.getMissingColumnWidthCount(reportSpec, model);
            if (missingColumnWidthCount > 0) {
                double defaultWidth;
                if (columnWidthSumOfPercents < 100) {
                    int remainingPercent = 100 - columnWidthSumOfPercents;
                    defaultWidth = remainingPercent / missingColumnWidthCount;
                    columnWidthSumOfPercents = 100;
                } else {
                    defaultWidth = 10.0;
                    columnWidthSumOfPercents += missingColumnWidthCount * 10;
                }
                for (i = 0; i < columns.length; ++i) {
                    property = (ColumnWidth)columns[i].getProperty(DefaultPropertyID.COLUMN_WIDTH.getId());
                    if (property != null) continue;
                    property = new ColumnWidth(ColumnWidth.WidthType.PERCENT, defaultWidth);
                    columns[i].setProperty(DefaultPropertyID.COLUMN_WIDTH.getId(), (Object)property);
                }
            }
            if (columnWidthSumOfPercents > 100) {
                columnWidthScaleFactor = 100.0 / (double)columnWidthSumOfPercents;
            }
            if (columnWidthScaleFactor < 1.0) {
                for (i = 0; i < columns.length; ++i) {
                    property = (ColumnWidth)columns[i].getProperty(DefaultPropertyID.COLUMN_WIDTH.getId());
                    ColumnWidth newProperty = new ColumnWidth(property.getType(), columnWidthScaleFactor * property.getWidth());
                    columns[i].setProperty(DefaultPropertyID.COLUMN_WIDTH.getId(), (Object)newProperty);
                }
            }
        }
        for (int i = 0; i < reportSpec.getField().length; ++i) {
            Field field = reportSpec.getField()[i];
            LogicalColumn column = columns[i];
            AdhocWebService.applyMetadata(field, column, columnWidthUnitsConsistent, locale);
            if (bUseTemplate) {
                Element templateDefaults = null;
                if (column.getDataType() != null) {
                    templateDefaults = (Element)reportSpecTypeToElement.get(METADATA_TYPE_TO_REPORT_SPEC_TYPE.get(column.getDataType()));
                }
                AdhocWebService.applyTemplate(field, templateDefaults);
            }
            AdhocWebService.applyDefaults(field);
        }
        ByteArrayOutputStream jfreeOutputStream = new ByteArrayOutputStream();
        ReportGenerationUtility.createJFreeReportXMLAsStream((ReportSpec)reportSpec, (String)reportXMLEncoding, (OutputStream)jfreeOutputStream);
        String jfreeXml = jfreeOutputStream.toString(reportXMLEncoding);
        Document generatedJFreeDoc = null;
        try {
            generatedJFreeDoc = XmlDom4JHelper.getDocFromString((String)jfreeXml, (EntityResolver)new PentahoEntityResolver());
        }
        catch (XmlParseException e) {
            String msg = Messages.getErrorString("HttpWebService.ERROR_0001_ERROR_DURING_WEB_SERVICE");
            this.error(msg, e);
            throw new AdhocWebServiceException(msg, e);
        }
        if (bUseTemplate) {
            Element reportItems = (Element)generatedJFreeDoc.selectSingleNode("/report/items");
            List templateAttrs = templateItems.attributes();
            for (Attribute attr : templateAttrs) {
                String name = attr.getName();
                String value = attr.getText();
                Node node = reportItems.selectSingleNode("@" + name);
                if (node != null) {
                    node.setText(value);
                    continue;
                }
                reportItems.addAttribute(name, value);
            }
            List templateElements = templateItems.elements();
            for (Element element : templateElements) {
                element.detach();
                reportItems.add(element);
            }
            ReportGenerationUtility.mergeTemplateAsStream((Document)templateDoc, (Document)generatedJFreeDoc, (OutputStream)jfreeMergedOutputStream);
        } else {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding(reportXMLEncoding);
            XMLWriter writer = new XMLWriter(jfreeMergedOutputStream, format);
            writer.write(generatedJFreeDoc);
            writer.close();
        }
    }

    private static void applyDefaults(Field targetField) {
        if (AdhocWebService.isNotSetStringProperty(targetField.getHorizontalAlignment())) {
            targetField.setHorizontalAlignment(AdhocWebService.getDefaultHorizontalAlignment(targetField));
        }
        if (AdhocWebService.isNotSetStringProperty(targetField.getVerticalAlignment())) {
            targetField.setVerticalAlignment(DEFAULT_FIELD_PROPS.getVerticalAlignment());
        }
    }

    private static String getDefaultHorizontalAlignment(Field targetField) {
        switch (targetField.getType()) {
            case 2: {
                return AlignmentEnum.RIGHT.toString();
            }
        }
        return AlignmentEnum.LEFT.toString();
    }

    private static int getSumOfMetadataColumnWidths(ReportSpec reportSpec, LogicalModel model) {
        int sum = 0;
        for (int i = 0; i < reportSpec.getField().length; ++i) {
            Field field = reportSpec.getField()[i];
            String name = field.getName();
            LogicalColumn column = model.findLogicalColumn(name);
            ColumnWidth property = (ColumnWidth)column.getProperty(DefaultPropertyID.COLUMN_WIDTH.getId());
            if (property == null) continue;
            sum += (int)property.getWidth();
        }
        return sum;
    }

    private static int getMissingColumnWidthCount(ReportSpec reportSpec, LogicalModel model) {
        int count = 0;
        for (int i = 0; i < reportSpec.getField().length; ++i) {
            Field field = reportSpec.getField()[i];
            String name = field.getName();
            LogicalColumn column = model.findLogicalColumn(name);
            ColumnWidth property = (ColumnWidth)column.getProperty(DefaultPropertyID.COLUMN_WIDTH.getId());
            if (property != null) continue;
            ++count;
        }
        return count;
    }

    private static boolean areMetadataColumnUnitsConsistent(ReportSpec reportSpec, LogicalModel model) {
        HashSet<Integer> unitsSet = new HashSet<Integer>();
        for (int i = 0; i < reportSpec.getField().length; ++i) {
            Field field = reportSpec.getField()[i];
            String name = field.getName();
            LogicalColumn column = model.findLogicalColumn(name);
            ColumnWidth property = (ColumnWidth)column.getProperty(DefaultPropertyID.COLUMN_WIDTH.getId());
            if (property == null) continue;
            unitsSet.add(property.getType().ordinal());
        }
        return AdhocWebService.isSetConsistent(unitsSet);
    }

    private static boolean isSetConsistent(Set<Integer> unitsSet) {
        return unitsSet.isEmpty() || CollectionUtils.isSubCollection(unitsSet, PERCENT_SET);
    }

    private static void applyMetadata(Field field, LogicalColumn column, boolean columnWidthUnitsConsistent, String locale) {
        String format;
        String htmlColor;
        Color color;
        String valignSetting;
        Alignment alignment;
        Font font;
        ColumnWidth property;
        if (columnWidthUnitsConsistent && (property = (ColumnWidth)column.getProperty(DefaultPropertyID.COLUMN_WIDTH.getId())) != null) {
            field.setWidth(new BigDecimal(property.getWidth()));
            field.setIsWidthPercent(property.getType() == ColumnWidth.WidthType.PERCENT);
            field.setWidthLocked(true);
        }
        if ((font = (Font)column.getProperty(DefaultPropertyID.FONT.getId())) != null) {
            if (font.getHeight() > 0) {
                field.setFontSize(font.getHeight());
            }
            field.setFontName(font.getName());
            int fontStyle = 0;
            if (font.isBold()) {
                fontStyle = ReportSpecUtility.addFontStyleBold((int)fontStyle);
            }
            if (font.isItalic()) {
                fontStyle = ReportSpecUtility.addFontStyleItalic((int)fontStyle);
            }
            field.setFontStyle(fontStyle);
        }
        if (AdhocWebService.isNotSetStringProperty(field.getHorizontalAlignment()) && (alignment = (Alignment)column.getProperty(DefaultPropertyID.ALIGNMENT.getId())) != null) {
            if (alignment == Alignment.LEFT) {
                field.setHorizontalAlignment("left");
            } else if (alignment == Alignment.RIGHT) {
                field.setHorizontalAlignment("right");
            } else if (alignment == Alignment.CENTERED) {
                field.setHorizontalAlignment("center");
            }
        }
        if (AdhocWebService.isNotSetStringProperty(field.getVerticalAlignment()) && (valignSetting = (String)column.getProperty(METADATA_PROPERTY_ID_VERTICAL_ALIGNMENT)) != null) {
            field.setVerticalAlignment(valignSetting);
        }
        if ((color = (Color)column.getProperty(DefaultPropertyID.COLOR_BG.getId())) != null) {
            htmlColor = AdhocWebService.getJFreeColorString(color);
            field.setBackgroundColor(htmlColor);
            field.setUseBackgroundColor(true);
        }
        if ((color = (Color)column.getProperty(DefaultPropertyID.COLOR_FG.getId())) != null) {
            htmlColor = AdhocWebService.getJFreeColorString(color);
            field.setFontColor(htmlColor);
        }
        String metaDataDisplayName = column.getName(locale);
        if (field.getIsDetail()) {
            field.setDisplayName(metaDataDisplayName);
        } else {
            String reportSpecDisplayName = field.getDisplayName();
            if (AdhocWebService.isDefaultStringProperty(reportSpecDisplayName)) {
                String displayName = column.getName(locale);
                field.setDisplayName(displayName + ": $(" + field.getName() + ")");
            }
        }
        if (AdhocWebService.isDefaultStringProperty(field.getFormat()) && !StringUtils.isEmpty((String)(format = (String)column.getProperty(DefaultPropertyID.MASK.getId())))) {
            field.setFormat(format);
        }
    }

    private static void applyTemplate(Field field, Element templateDefaults) {
        if (templateDefaults != null) {
            Node node = null;
            if (AdhocWebService.isNotSetStringProperty(field.getHorizontalAlignment()) && (node = templateDefaults.selectSingleNode("@alignment")) != null) {
                field.setHorizontalAlignment(node.getText());
            }
            if (AdhocWebService.isNotSetStringProperty(field.getVerticalAlignment()) && (node = templateDefaults.selectSingleNode("@vertical-alignment")) != null) {
                field.setVerticalAlignment(node.getText());
            }
            if (AdhocWebService.isDefaultStringProperty(field.getFormat()) && (node = templateDefaults.selectSingleNode("@format")) != null) {
                field.setFormat(node.getText());
            }
            if (AdhocWebService.isDefaultStringProperty(field.getFontName()) && (node = templateDefaults.selectSingleNode("@fontname")) != null) {
                field.setFontName(node.getText());
            }
            if (AdhocWebService.isDefaultStringProperty(field.getFontColor()) && (node = templateDefaults.selectSingleNode("@color")) != null) {
                field.setFontColor(node.getText());
            }
            if (!field.hasFontSize() && (node = templateDefaults.selectSingleNode("@fontsize")) != null) {
                field.setFontSize(Integer.parseInt(node.getText()));
            }
        }
    }

    private void addMQLQueryXml(Element elem, String domainId, String modelId, String tableId, String columnId, String searchStr) {
        Element mqlElement = elem.addElement("mql");
        mqlElement.addElement("domain_type").setText("relational");
        mqlElement.addElement("domain_id").setText(domainId);
        mqlElement.addElement("model_id").setText(modelId);
        Element selectionElement = mqlElement.addElement("selections");
        selectionElement = selectionElement.addElement("selection");
        selectionElement.addElement("table").setText(tableId);
        selectionElement.addElement("column").setText(columnId);
        if (!StringUtils.isEmpty((String)searchStr)) {
            Element constraintElement = mqlElement.addElement("constraints");
            constraintElement = constraintElement.addElement("constraint");
            constraintElement.addElement("table_id").setText(tableId);
            constraintElement.addElement("condition").setText(searchStr);
        }
    }

    public void createMQLQueryActionSequence(String domainId, String modelId, String tableId, String columnId, String searchStr, OutputStream outputStream, String userSessionName) throws IOException {
        Document document = DOMDocumentFactory.getInstance().createDocument();
        document.setXMLEncoding(LocaleHelper.getSystemEncoding());
        Element actionSeqElement = document.addElement("action-sequence");
        actionSeqElement.addElement("version").setText("1");
        actionSeqElement.addElement("title").setText("MQL Query");
        actionSeqElement.addElement("logging-level").setText("ERROR");
        Element documentationElement = actionSeqElement.addElement("documentation");
        Element authorElement = documentationElement.addElement("author");
        if (userSessionName != null) {
            authorElement.setText(userSessionName);
        } else {
            authorElement.setText("Web Query & Reporting");
        }
        documentationElement.addElement("description").setText("Temporary action sequence used by Web Query & Reporting");
        documentationElement.addElement("result-type").setText("result-set");
        Element outputsElement = actionSeqElement.addElement("outputs");
        Element reportTypeElement = outputsElement.addElement("query_result");
        reportTypeElement.addAttribute("type", "result-set");
        Element destinationsElement = reportTypeElement.addElement("destinations");
        destinationsElement.addElement("response").setText("query_result");
        Element actionsElement = actionSeqElement.addElement("actions");
        Element actionDefinitionElement = actionsElement.addElement("action-definition");
        Element actionOutputsElement = actionDefinitionElement.addElement("action-outputs");
        Element ruleResultElement = actionOutputsElement.addElement("query-result");
        ruleResultElement.addAttribute("type", "result-set");
        ruleResultElement.addAttribute("mapping", "query_result");
        actionDefinitionElement.addElement("component-name").setText("MQLRelationalDataComponent");
        actionDefinitionElement.addElement("action-type").setText("MQL Query");
        Element componentDefinitionElement = actionDefinitionElement.addElement("component-definition");
        if ("true".equals(PentahoSystem.getSystemSetting((String)"adhoc-preview-log-sql", (String)"false"))) {
            componentDefinitionElement.addElement("logSql").addCDATA("true");
        }
        this.addMQLQueryXml(componentDefinitionElement, domainId, modelId, tableId, columnId, searchStr);
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(LocaleHelper.getSystemEncoding());
        XMLWriter writer = new XMLWriter(outputStream, format);
        writer.write(document);
        writer.close();
    }

    public ByteArrayOutputStream createMQLReportActionSequenceAsStream(String reportName, String reportDescription, Element mqlNode, String[] outputTypeList, String xactionName, String jfreeReportXML, String jfreeReportFilename, String loggingLevel, IPentahoSession userSession) throws IOException, AdhocWebServiceException {
        Element locationElement;
        boolean bIsMultipleOutputType = outputTypeList.length > 1;
        Document document = DOMDocumentFactory.getInstance().createDocument();
        document.setXMLEncoding(LocaleHelper.getSystemEncoding());
        Element actionSeqElement = document.addElement("action-sequence");
        Element actionSeqNameElement = actionSeqElement.addElement("name");
        actionSeqNameElement.setText(xactionName);
        Element actionSeqVersionElement = actionSeqElement.addElement("version");
        actionSeqVersionElement.setText("1");
        Element actionSeqTitleElement = actionSeqElement.addElement("title");
        String reportTitle = AdhocWebService.getBaseFilename(reportName);
        actionSeqTitleElement.setText(reportTitle);
        Element loggingLevelElement = actionSeqElement.addElement("logging-level");
        loggingLevelElement.setText(loggingLevel);
        Element documentationElement = actionSeqElement.addElement("documentation");
        Element authorElement = documentationElement.addElement("author");
        if (userSession.getName() != null) {
            authorElement.setText(userSession.getName());
        } else {
            authorElement.setText("Web Query & Reporting");
        }
        Element descElement = documentationElement.addElement("description");
        descElement.setText(reportDescription);
        Element iconElement = documentationElement.addElement("icon");
        iconElement.setText("PentahoReporting.png");
        Element helpElement = documentationElement.addElement("help");
        helpElement.setText("Auto-generated action-sequence for WAQR.");
        Element resultTypeElement = documentationElement.addElement("result-type");
        resultTypeElement.setText("report");
        Element inputsElement = actionSeqElement.addElement("inputs");
        Element outputTypeElement = inputsElement.addElement("output-type");
        outputTypeElement.addAttribute("type", "string");
        Element defaultValueElement = outputTypeElement.addElement("default-value");
        defaultValueElement.setText(outputTypeList[0]);
        Element sourcesElement = outputTypeElement.addElement("sources");
        Element requestElement = sourcesElement.addElement("request");
        requestElement.setText("type");
        if (bIsMultipleOutputType) {
            Element mimeTypes = inputsElement.addElement("mimeTypes");
            mimeTypes.addAttribute("type", "string-list");
            Element sources = mimeTypes.addElement("sources");
            requestElement = sources.addElement("request");
            requestElement.setText("mimeTypes");
            Element defaultValue = mimeTypes.addElement("default-value");
            defaultValue.addAttribute("type", "string-list");
            Element listItem = null;
            for (String outputType : outputTypeList) {
                listItem = defaultValue.addElement("list-item");
                listItem.setText(outputType);
            }
        }
        Element outputsElement = actionSeqElement.addElement("outputs");
        Element reportTypeElement = outputsElement.addElement("report");
        reportTypeElement.addAttribute("type", "content");
        Element destinationsElement = reportTypeElement.addElement("destinations");
        Element responseElement = destinationsElement.addElement("response");
        responseElement.setText("content");
        Element resourcesElement = actionSeqElement.addElement("resources");
        Element reportDefinitionElement = resourcesElement.addElement("report-definition");
        Element solutionFileElement = null;
        if (null == jfreeReportFilename) {
            solutionFileElement = reportDefinitionElement.addElement("xml");
            locationElement = solutionFileElement.addElement("location");
            Document jfreeReportDoc = null;
            try {
                jfreeReportDoc = XmlDom4JHelper.getDocFromString((String)jfreeReportXML, (EntityResolver)new PentahoEntityResolver());
            }
            catch (XmlParseException e) {
                String msg = Messages.getErrorString("HttpWebService.ERROR_0001_ERROR_DURING_WEB_SERVICE");
                this.error(msg, e);
                throw new AdhocWebServiceException(msg, e);
            }
            Node reportNode = jfreeReportDoc.selectSingleNode("/report");
            locationElement.add(reportNode);
        } else {
            solutionFileElement = reportDefinitionElement.addElement("solution-file");
            locationElement = solutionFileElement.addElement("location");
            locationElement.setText(jfreeReportFilename);
        }
        Element mimeTypeElement = solutionFileElement.addElement("mime-type");
        mimeTypeElement.setText("text/xml");
        Element actionsElement = actionSeqElement.addElement("actions");
        Element actionDefinitionElement = null;
        if (bIsMultipleOutputType) {
            actionDefinitionElement = actionsElement.addElement("action-definition");
            Element componentName = actionDefinitionElement.addElement("component-name");
            componentName.setText("SecureFilterComponent");
            Element actionType = actionDefinitionElement.addElement("action-type");
            actionType.setText("Prompt/Secure Filter");
            Element actionInputs = actionDefinitionElement.addElement("action-inputs");
            Element outputType = actionInputs.addElement("output-type");
            outputType.addAttribute("type", "string");
            Element mimeTypes = actionInputs.addElement("mimeTypes");
            mimeTypes.addAttribute("type", "string-list");
            Element componentDefinition = actionDefinitionElement.addElement("component-definition");
            Element selections = componentDefinition.addElement("selections");
            outputType = selections.addElement("output-type");
            outputType.addAttribute("prompt-if-one-value", "true");
            Element title = outputType.addElement("title");
            String prompt = Messages.getString("AdhocWebService.SELECT_OUTPUT_TYPE");
            title.setText(prompt);
            Element filter = outputType.addElement("filter");
            filter.setText("mimeTypes");
        }
        actionDefinitionElement = actionsElement.addElement("action-definition");
        Element actionOutputsElement = actionDefinitionElement.addElement("action-outputs");
        Element ruleResultElement = actionOutputsElement.addElement("rule-result");
        ruleResultElement.addAttribute("type", "result-set");
        Element componentNameElement = actionDefinitionElement.addElement("component-name");
        componentNameElement.setText("MQLRelationalDataComponent");
        Element actionTypeElement = actionDefinitionElement.addElement("action-type");
        actionTypeElement.setText("rule");
        Element componentDefinitionElement = actionDefinitionElement.addElement("component-definition");
        componentDefinitionElement.add(mqlNode);
        componentDefinitionElement.addElement("live").setText("true");
        componentDefinitionElement.addElement("display-names").setText("false");
        if ("true".equals(PentahoSystem.getSystemSetting((String)"adhoc-preview-log-sql", (String)"false"))) {
            componentDefinitionElement.addElement("logSql").addCDATA("true");
        }
        actionDefinitionElement = actionsElement.addElement("action-definition");
        actionOutputsElement = actionDefinitionElement.addElement("action-outputs");
        Element actionInputsElement = actionDefinitionElement.addElement("action-inputs");
        outputTypeElement = actionInputsElement.addElement("output-type");
        outputTypeElement.addAttribute("type", "string");
        Element dataElement = actionInputsElement.addElement("data");
        Element actionResourcesElement = actionDefinitionElement.addElement("action-resources");
        Element reportDefinition = actionResourcesElement.addElement("report-definition");
        reportDefinition.addAttribute("type", "resource");
        dataElement.addAttribute("type", "result-set");
        dataElement.addAttribute("mapping", "rule-result");
        Element reportOutputElement = actionOutputsElement.addElement("report");
        reportOutputElement.addAttribute("type", "content");
        componentNameElement = actionDefinitionElement.addElement("component-name");
        componentNameElement.setText("JFreeReportComponent");
        actionTypeElement = actionDefinitionElement.addElement("action-type");
        actionTypeElement.setText("report");
        componentDefinitionElement = actionDefinitionElement.addElement("component-definition");
        componentDefinitionElement.addElement("output-type").setText(outputTypeList[0]);
        Document tmp = this.customizeActionSequenceDocument(document);
        if (tmp != null) {
            document = tmp;
        }
        return this.exportDocumentAsByteArrayOutputStream(document);
    }

    protected Document customizeActionSequenceDocument(Document document) {
        return null;
    }

    protected ByteArrayOutputStream exportDocumentAsByteArrayOutputStream(Document document) throws IOException {
        ByteArrayOutputStream xactionOutputStream = new ByteArrayOutputStream();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(LocaleHelper.getSystemEncoding());
        XMLWriter writer = new XMLWriter((OutputStream)xactionOutputStream, format);
        writer.write(document);
        writer.close();
        return xactionOutputStream;
    }

    public void lookupValues(IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession, boolean wrapWithSoap) throws IOException {
        String domainName = parameterProvider.getStringParameter("model", null);
        String viewId = parameterProvider.getStringParameter("view", null);
        String columnId = parameterProvider.getStringParameter("column", null);
        SimpleUrlFactory urlFactory = new SimpleUrlFactory("");
        PMDUIComponent component = new PMDUIComponent((IPentahoUrlFactory)urlFactory, new ArrayList());
        component.validate(userSession, null);
        component.setAction(5);
        component.setDomainName(domainName);
        component.setModelId(viewId);
        component.setColumnId(columnId);
        Document doc = component.getXmlContent();
        WebServiceUtil.writeDocument((OutputStream)outputStream, (Document)doc, (boolean)wrapWithSoap);
    }

    private void getWaqrRepositoryIndexDoc(IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession, boolean wrapWithSoap) throws IOException, AdhocWebServiceException {
        String templateFolderPath = parameterProvider.getStringParameter("templateFolderPath", null);
        if (StringUtil.doesPathContainParentPathSegment((String)templateFolderPath)) {
            String msg = Messages.getString("AdhocWebService.ERROR_0010_OPEN_INDEX_DOC_FAILED", templateFolderPath);
            throw new AdhocWebServiceException(msg);
        }
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)userSession);
        String templateFilename = "system/waqr" + templateFolderPath + "/" + "index.xml";
        try {
            InputStream inStrm = repository.getResourceInputStream(templateFilename, false, 1);
            Document indexDoc = XmlDom4JHelper.getDocFromStream((InputStream)inStrm, (EntityResolver)new PentahoEntityResolver());
            ISolutionFile templateFile = repository.getSolutionFile(templateFilename, 1);
            repository.localizeDoc((Node)indexDoc, templateFile);
            WebServiceUtil.writeDocument((OutputStream)outputStream, (Document)indexDoc, (boolean)wrapWithSoap);
        }
        catch (Exception e) {
            String msg = Messages.getString("AdhocWebService.ERROR_0010_OPEN_INDEX_DOC_FAILED");
            msg = msg + " " + e.getLocalizedMessage();
            throw new AdhocWebServiceException(msg);
        }
    }

    private void deleteWaqrReport(IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession, boolean wrapWithSoap) throws IOException, AdhocWebServiceException {
        if ("true".equals(PentahoSystem.getSystemSetting((String)"kiosk-mode", (String)"false"))) {
            String msg = WebServiceUtil.getErrorXml((String)Messages.getString("PentahoGeneral.USER_FEATURE_DISABLED"));
            WebServiceUtil.writeString((OutputStream)outputStream, (String)msg, (boolean)wrapWithSoap);
            return;
        }
        String solution = "/" + parameterProvider.getStringParameter("solution", null);
        String path = "/" + parameterProvider.getStringParameter("path", null);
        String filename = parameterProvider.getStringParameter("filename", null);
        String baseFilename = AdhocWebService.getBaseFilename(filename);
        if (StringUtil.doesPathContainParentPathSegment((String)path)) {
            String msg = Messages.getString("AdhocWebService.ERROR_0007_FAILED_TO_DELETE_FILES", filename);
            throw new AdhocWebServiceException(msg);
        }
        String msg = "";
        String xactionFile = "/" + baseFilename + "." + WAQR_EXTENSION + ".xaction";
        ISolutionRepositoryService solutionRepositoryService = (ISolutionRepositoryService)PentahoSystem.get(ISolutionRepositoryService.class, (IPentahoSession)userSession);
        boolean success = solutionRepositoryService.delete(userSession, solution, path, xactionFile);
        if (success) {
            String reportSpecFile;
            String jfreeFile = "/" + baseFilename + "." + WAQR_EXTENSION + ".xml";
            if (!solutionRepositoryService.delete(userSession, solution, path, jfreeFile)) {
                msg = jfreeFile + " ";
            }
            if (!solutionRepositoryService.delete(userSession, solution, path, reportSpecFile = "/" + baseFilename + "." + WAQR_EXTENSION + ".xreportspec")) {
                msg = msg + reportSpecFile + " ";
            }
        } else {
            msg = msg + xactionFile + " ";
        }
        if (msg.length() != 0) {
            msg = Messages.getString("AdhocWebService.ERROR_0007_FAILED_TO_DELETE_FILES", msg);
            throw new AdhocWebServiceException(msg);
        }
        msg = WebServiceUtil.getStatusXml((String)Messages.getString("AdhocWebService.USER_DELETE_SUCCESSFUL"));
        WebServiceUtil.writeString((OutputStream)outputStream, (String)msg, (boolean)wrapWithSoap);
    }

    private void saveFile(IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession, boolean wrapWithSoap) throws AdhocWebServiceException, IOException, PentahoMetadataException, PentahoAccessControlException {
        if ("true".equals(PentahoSystem.getSystemSetting((String)"kiosk-mode", (String)"false"))) {
            String msg = WebServiceUtil.getErrorXml((String)Messages.getString("PentahoGeneral.USER_FEATURE_DISABLED"));
            WebServiceUtil.writeString((OutputStream)outputStream, (String)msg, (boolean)wrapWithSoap);
            return;
        }
        String fileName = parameterProvider.getStringParameter("name", null);
        if (!AdhocWebService.isWaqrFilename(fileName)) {
            throw new RuntimeException("saveFile is only implemented for WAQR files, stay tuned.");
        }
        this.saveReportSpec(fileName, parameterProvider, outputStream, userSession, wrapWithSoap);
    }

    protected void preSaveActions(String fileName, IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession, boolean wrapWithSoap) throws AdhocWebServiceException, IOException, PentahoMetadataException, PentahoAccessControlException {
    }

    protected void postSaveActions(String fileName, IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession, boolean wrapWithSoap, int xActionSaveStatus) throws AdhocWebServiceException, IOException, PentahoMetadataException, PentahoAccessControlException {
    }

    protected void saveReportSpec(String fileName, IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession, boolean wrapWithSoap) throws AdhocWebServiceException, IOException, PentahoMetadataException, PentahoAccessControlException {
        int[] errorStatusAr;
        int errorStatus;
        this.preSaveActions(fileName, parameterProvider, outputStream, userSession, wrapWithSoap);
        String reportXML = parameterProvider.getStringParameter("content", null);
        String solutionName = parameterProvider.getStringParameter("solution", null);
        String solutionPath = parameterProvider.getStringParameter("path", null);
        String templatePath = parameterProvider.getStringParameter("templatePath", null);
        boolean overwrite = parameterProvider.getStringParameter("overwrite", "false").equalsIgnoreCase("true");
        String outputType = parameterProvider.getStringParameter("outputType", null);
        if (StringUtil.doesPathContainParentPathSegment((String)solutionPath) || StringUtil.doesPathContainParentPathSegment((String)templatePath)) {
            String msg = Messages.getString("AdhocWebService.ERROR_0008_MISSING_OR_INVALID_REPORT_NAME");
            throw new AdhocWebServiceException(msg);
        }
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)userSession);
        String baseUrl = PentahoSystem.getApplicationContext().getSolutionPath("");
        Document reportSpecDoc = null;
        try {
            reportSpecDoc = XmlDom4JHelper.getDocFromString((String)reportXML, (EntityResolver)new PentahoEntityResolver());
        }
        catch (XmlParseException e) {
            String msg = Messages.getErrorString("HttpWebService.ERROR_0001_ERROR_DURING_WEB_SERVICE");
            this.error(msg, e);
            throw new AdhocWebServiceException(msg, e);
        }
        if (null == reportSpecDoc) {
            String msg = Messages.getString("AdhocWebService.ERROR_0009_SAVE_FAILED") + " " + Messages.getString("AdhocWebService.INVALID_CLIENT_XML");
            throw new AdhocWebServiceException(msg);
        }
        Element mqlNode = (Element)reportSpecDoc.selectSingleNode("/report-spec/query/mql");
        mqlNode.detach();
        Node reportNameNd = reportSpecDoc.selectSingleNode("/report-spec/report-name");
        String reportName = reportNameNd.getText();
        Node reportDescNd = reportSpecDoc.selectSingleNode("/report-spec/report-desc");
        String reportDesc = reportDescNd.getText();
        String[] outputTypeList = outputType.split(",");
        String baseName = AdhocWebService.getBaseFilename(fileName);
        if (null == baseName) {
            String msg = Messages.getString("AdhocWebService.ERROR_0008_MISSING_OR_INVALID_REPORT_NAME");
            throw new AdhocWebServiceException(msg);
        }
        baseName = baseName + ".waqr";
        String xactionFilename = baseName + ".xaction";
        String jfreeFilename = baseName + ".xml";
        String xreportSpecFilename = baseName + ".xreportspec";
        ByteArrayOutputStream jfreeOutputStream = new ByteArrayOutputStream();
        this.createJFreeReportDefinitionAsStream(reportXML, templatePath, mqlNode, repository, userSession, jfreeOutputStream);
        String jfreeString = jfreeOutputStream.toString(LocaleHelper.getSystemEncoding());
        ByteArrayOutputStream xactionOutputStream = this.createMQLReportActionSequenceAsStream(reportName, reportDesc, mqlNode, outputTypeList, xactionFilename, jfreeString, jfreeFilename, "warn", userSession);
        solutionPath = StringUtils.isEmpty((String)solutionPath) ? "" : (solutionPath.equals("/") ? "" : "/" + solutionPath);
        String path = solutionName + solutionPath + "/";
        int jfreeSaveStatus = 2;
        int xreportSpecSaveStatus = 2;
        int xactionSaveStatus = repository.publish(baseUrl, path, xactionFilename, xactionOutputStream.toString(LocaleHelper.getSystemEncoding()).getBytes(), overwrite);
        if (xactionSaveStatus == 3) {
            jfreeSaveStatus = repository.publish(baseUrl, path, jfreeFilename, jfreeString.getBytes(LocaleHelper.getSystemEncoding()), overwrite);
            if (jfreeSaveStatus == 3) {
                xreportSpecSaveStatus = repository.publish(baseUrl, path, xreportSpecFilename, reportXML.getBytes(LocaleHelper.getSystemEncoding()), overwrite);
            }
            this.postSaveActions(fileName, parameterProvider, outputStream, userSession, wrapWithSoap, xactionSaveStatus);
        }
        if ((errorStatus = AdhocWebService.getSaveErrorStatus(errorStatusAr = new int[]{xactionSaveStatus, jfreeSaveStatus, xreportSpecSaveStatus})) != 3) {
            String[] FILE_STATUS_MSG = new String[]{"", "AdhocWebService.ERROR_0001_FILE_EXISTS", "AdhocWebService.ERROR_0002_FILE_ADD_FAILED", "AdhocWebService.STATUS_0003_FILE_ADD_SUCCESSFUL", "AdhocWebService.ERROR_0004_FILE_ADD_INVALID_PUBLISH_PASSWORD", "AdhocWebService.ERROR_0005_FILE_ADD_INVALID_USER_CREDENTIALS"};
            String msg = Messages.getString("AdhocWebService.ERROR_0009_SAVE_FAILED") + " " + Messages.getString(FILE_STATUS_MSG[errorStatus]);
            if (1 == errorStatus) {
                msg = msg + " (" + xreportSpecFilename + ")";
            }
            throw new AdhocWebServiceException(msg);
        }
        String msg = WebServiceUtil.getStatusXml((String)Messages.getString("AdhocWebService.USER_REPORT_SAVED"));
        WebServiceUtil.writeString((OutputStream)outputStream, (String)msg, (boolean)wrapWithSoap);
        this.invalidateSolutionRepositoryTree(userSession);
        repository.reloadSolutionRepository(userSession, repository.getLoggingLevel());
    }

    public void listBusinessModels(IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession, boolean wrapWithSoap) throws IOException {
        String domainName = parameterProvider.getStringParameter("domain", null);
        SimpleUrlFactory urlFactory = new SimpleUrlFactory("");
        PMDUIComponent component = new PMDUIComponent((IPentahoUrlFactory)urlFactory, new ArrayList());
        component.validate(userSession, null);
        component.setAction(2);
        component.setDomainName(domainName);
        Document doc = component.getXmlContent();
        WebServiceUtil.writeDocument((OutputStream)outputStream, (Document)doc, (boolean)wrapWithSoap);
    }

    public void getBusinessModel(IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession, boolean wrapWithSoap) throws IOException {
        String domainName = parameterProvider.getStringParameter("domain", null);
        String modelId = parameterProvider.getStringParameter("model", null);
        SimpleUrlFactory urlFactory = new SimpleUrlFactory("");
        PMDUIComponent component = new PMDUIComponent((IPentahoUrlFactory)urlFactory, new ArrayList());
        component.validate(userSession, null);
        component.setAction(4);
        component.setDomainName(domainName);
        component.setModelId(modelId);
        Document doc = component.getXmlContent();
        WebServiceUtil.writeDocument((OutputStream)outputStream, (Document)doc, (boolean)wrapWithSoap);
    }

    public void searchTable(IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession, boolean wrapWithSoap) throws IOException {
        String domainId = (String)parameterProvider.getParameter("modelId");
        String modelId = (String)parameterProvider.getParameter("viewId");
        String tableId = (String)parameterProvider.getParameter("tableId");
        String columnId = (String)parameterProvider.getParameter("columnId");
        String searchStr = (String)parameterProvider.getParameter("searchStr");
        ByteArrayOutputStream xactionOutputStream = new ByteArrayOutputStream();
        this.createMQLQueryActionSequence(domainId, modelId, tableId, columnId, searchStr, xactionOutputStream, userSession.getName());
        Document document = DocumentHelper.createDocument();
        document.setXMLEncoding(LocaleHelper.getSystemEncoding());
        Element resultsElement = document.addElement("results");
        IRuntimeContext runtimeContext = AdhocWebService.executeActionSequence(xactionOutputStream.toString(LocaleHelper.getSystemEncoding()), "mqlQuery.xaction", (IParameterProvider)new SimpleParameterProvider(), userSession, new ByteArrayOutputStream());
        if (runtimeContext.getStatus() == 6) {
            IActionParameter actionParameter = runtimeContext.getOutputParameter("query_result");
            IPentahoResultSet pentahoResultSet = actionParameter.getValueAsResultSet();
            TreeSet<Object> treeSet = new TreeSet<Object>();
            for (int i = 0; i < pentahoResultSet.getRowCount(); ++i) {
                Object[] rowValues = pentahoResultSet.getDataRow(i);
                if (rowValues[0] == null) continue;
                treeSet.add(rowValues[0]);
            }
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                resultsElement.addElement("row").setText(iterator.next().toString());
            }
            runtimeContext.dispose();
        }
        WebServiceUtil.writeString((OutputStream)outputStream, (String)document.asXML(), (boolean)wrapWithSoap);
    }

    public void getTemplateReportSpec(IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession, boolean wrapWithSoap) throws AdhocWebServiceException, IOException {
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)userSession);
        String reportSpecName = parameterProvider.getStringParameter("reportSpecPath", null);
        Document reportSpecDoc = null;
        if (!StringUtils.isEmpty((String)reportSpecName)) {
            try {
                reportSpecName = WAQR_REPOSITORY_PATH + reportSpecName;
                reportSpecDoc = repository.getResourceAsDocument(reportSpecName, 1);
            }
            catch (IOException ex) {
                String msg = Messages.getString("AdhocWebService.ERROR_0004_FAILED_TO_LOAD_REPORTSPEC", reportSpecName);
                throw new AdhocWebServiceException(msg, ex);
            }
        } else {
            String msg = Messages.getString("AdhocWebService.ERROR_0005_MISSING_REPORTSPEC_NAME");
            throw new AdhocWebServiceException(msg);
        }
        WebServiceUtil.writeDocument((OutputStream)outputStream, (Document)reportSpecDoc, (boolean)wrapWithSoap);
    }

    public void getWaqrReportSpecDoc(IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession, boolean wrapWithSoap) throws AdhocWebServiceException, IOException {
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)userSession);
        String solution = parameterProvider.getStringParameter("solution", null);
        String path = parameterProvider.getStringParameter("path", null);
        String filename = parameterProvider.getStringParameter("filename", null);
        Document reportSpecDoc = null;
        if (!StringUtils.isEmpty((String)solution) && null != path && !StringUtils.isEmpty((String)filename)) {
            try {
                String filePath = ActionInfo.buildSolutionPath((String)solution, (String)path, (String)filename);
                reportSpecDoc = repository.getResourceAsDocument(filePath, 1);
            }
            catch (IOException ex) {
                String msg = Messages.getString("AdhocWebService.ERROR_0004_FAILED_TO_LOAD_REPORTSPEC", filename);
                throw new AdhocWebServiceException(msg, ex);
            }
        } else {
            String msg = Messages.getString("AdhocWebService.ERROR_0005_MISSING_REPORTSPEC_NAME");
            throw new AdhocWebServiceException(msg);
        }
        Node domainIdNode = reportSpecDoc.selectSingleNode("//report-spec/query/mql/domain_id");
        String domainId = domainIdNode.getText();
        if (!domainId.endsWith(".xmi")) {
            domainId = domainId + "/metadata.xmi";
            domainIdNode.setText(domainId);
        }
        WebServiceUtil.writeDocument((OutputStream)outputStream, (Document)reportSpecDoc, (boolean)wrapWithSoap);
    }

    private static String getErrorHtml(HttpServletRequest request, Exception e, String errorMsg) {
        errorMsg = StringEscapeUtils.escapeXml((String)errorMsg);
        StringBuffer b = new StringBuffer();
        LinkedList<String> msgList = new LinkedList<String>();
        msgList.add(errorMsg);
        msgList.add(Messages.getString("AdhocWebService.REASON"));
        if (null != e.getMessage()) {
            msgList.add(e.getMessage());
        } else {
            msgList.add(e.getClass().getName());
        }
        ((IMessageFormatter)PentahoSystem.get(IMessageFormatter.class, (IPentahoSession)PentahoHttpSessionHelper.getPentahoSession((HttpServletRequest)request))).formatErrorMessage("text/html", Messages.getString("AdhocWebService.HEADER_ERROR_PAGE"), msgList, b);
        return b.toString();
    }

    private static int getSaveErrorStatus(int[] statusAr) {
        for (int status : statusAr) {
            if (status == 3) continue;
            return status;
        }
        return 3;
    }

    private static boolean isWaqrFilename(String filename) {
        return filename.matches(".*\\.waqr\\..*");
    }

    public Document getSolutionRepositoryDoc(String solutionName, String path, IPentahoSession userSession) {
        Document solutionRepositoryDoc = null;
        ICacheManager cacheManager = PentahoSystem.getCacheManager((IPentahoSession)userSession);
        if (null != cacheManager) {
            String cacheKey;
            HashMap<String, Document> solutionRepositoryFolderMap = (HashMap<String, Document>)cacheManager.getFromSessionCache(userSession, SOLUTION_NAVIGATION_DOCUMENT_MAP);
            if (solutionRepositoryFolderMap == null) {
                solutionRepositoryFolderMap = new HashMap<String, Document>();
                cacheManager.putInSessionCache(userSession, SOLUTION_NAVIGATION_DOCUMENT_MAP, solutionRepositoryFolderMap);
            }
            if ((solutionRepositoryDoc = (Document)solutionRepositoryFolderMap.get(cacheKey = solutionName + "/" + path)) == null) {
                solutionRepositoryDoc = this.createSolutionRepositoryDoc(solutionName, path, userSession);
                solutionRepositoryFolderMap.put(cacheKey, solutionRepositoryDoc);
            }
        } else {
            solutionRepositoryDoc = this.createSolutionRepositoryDoc(solutionName, path, userSession);
        }
        return solutionRepositoryDoc;
    }

    private static void removeChildElements(Element element) {
        if (element.getName().equals("leaf")) {
            List childElements = element.elements();
            for (Element childElement : childElements) {
                if (childElement.getName().equals("leafText") || childElement.getName().equals("path")) continue;
                childElement.detach();
            }
        } else {
            List childElements = element.elements();
            for (Element childElement : childElements) {
                List grandChildren;
                if (childElement.getName().equals("leaf")) {
                    grandChildren = childElement.elements();
                    for (Element grandChildElement : grandChildren) {
                        if (grandChildElement.getName().equals("leafText") || grandChildElement.getName().equals("path")) continue;
                        grandChildElement.detach();
                    }
                    continue;
                }
                if (childElement.getName().equals("branch")) {
                    grandChildren = childElement.elements();
                    for (Element grandChildElement : grandChildren) {
                        if (grandChildElement.getName().equals("branchText")) continue;
                        grandChildElement.detach();
                    }
                    continue;
                }
                if (childElement.getName().equals("branchText")) continue;
                childElement.detach();
            }
        }
    }

    private static Element getFolderElement(Document doc, String folderPath) {
        String folderXPath = "//branch[@id='" + folderPath + "' and @" + "isDir" + "='true']";
        Element folderElement = (Element)doc.selectSingleNode(folderXPath);
        return folderElement;
    }

    private Document getWaqrTemplates(IPentahoSession userSession, String path) {
        Document fullDoc = null;
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)userSession);
        ICacheManager cacheManager = PentahoSystem.getCacheManager((IPentahoSession)userSession);
        ISolutionFile startingFile = repository.getSolutionFile(path, 1);
        ISolutionFilter waqrTemplateFilter = new ISolutionFilter(){

            public boolean keepFile(ISolutionFile solutionFile, int actionOperation) {
                return solutionFile.isDirectory() || solutionFile.getFullPath().toLowerCase().contains(AdhocWebService.WAQR_REPOSITORY_PATH);
            }
        };
        if (cacheManager != null) {
            fullDoc = (Document)cacheManager.getFromSessionCache(userSession, FULL_SOLUTION_DOC);
            if (fullDoc == null) {
                fullDoc = repository.getFullSolutionTree(1, waqrTemplateFilter, startingFile);
                cacheManager.putInSessionCache(userSession, FULL_SOLUTION_DOC, (Object)fullDoc);
            }
        } else {
            fullDoc = repository.getFullSolutionTree(1, waqrTemplateFilter, startingFile);
        }
        return fullDoc;
    }

    private Document getWaqrRepositoryDoc(String folderPath, IPentahoSession userSession) throws AdhocWebServiceException {
        if (folderPath != null && StringUtil.doesPathContainParentPathSegment((String)folderPath)) {
            String msg = Messages.getString("AdhocWebService.ERROR_0011_FAILED_TO_LOCATE_PATH", folderPath);
            throw new AdhocWebServiceException(msg);
        }
        String solutionRepositoryName = AdhocWebService.getSolutionRepositoryName(userSession);
        String path = "/" + solutionRepositoryName + WAQR_REPOSITORY_PATH;
        if (folderPath != null && !folderPath.equals("/")) {
            path = path + folderPath;
        }
        Document fullDoc = this.getWaqrTemplates(userSession, path);
        Element folderElement = AdhocWebService.getFolderElement(fullDoc, path);
        Document systemDoc = null;
        if (folderElement == null) {
            String msg = Messages.getString("AdhocWebService.ERROR_0011_FAILED_TO_LOCATE_PATH", folderPath);
            throw new AdhocWebServiceException(msg);
        }
        Element clonedFolderElement = (Element)folderElement.clone();
        AdhocWebService.removeChildElements(clonedFolderElement);
        systemDoc = DocumentHelper.createDocument((Element)((Element)clonedFolderElement.detach()));
        systemDoc.setXMLEncoding(LocaleHelper.getSystemEncoding());
        return systemDoc;
    }

    protected Document createSolutionRepositoryDoc(String solutionName, String path, IPentahoSession userSession) {
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)userSession);
        Document document = repository.getNavigationUIDocument(solutionName, path, 1);
        return document;
    }

    private void invalidateSolutionRepositoryTree(IPentahoSession userSession) {
        ICacheManager cacheManager = PentahoSystem.getCacheManager((IPentahoSession)userSession);
        if (null != cacheManager) {
            cacheManager.removeFromSessionCache(userSession, SOLUTION_NAVIGATION_DOCUMENT_MAP);
        }
    }

    private static String getSolutionRepositoryName(IPentahoSession userSession) {
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)userSession);
        ISolutionFile rootFolder = repository.getRootFolder(1);
        return rootFolder.getSolution();
    }

    private static String getBaseFilename(String fullFilename) {
        Matcher m = BASE_WAQR_FILENAME_PATTERN.matcher(fullFilename);
        String baseName = fullFilename;
        if (m.matches()) {
            baseName = m.group(1);
        }
        return baseName;
    }

    public static void main(String[] args) {
        HashSet<Integer> invalid = new HashSet<Integer>();
        invalid.add(ColumnWidth.WidthType.PERCENT.ordinal());
        invalid.add(ColumnWidth.WidthType.CM.ordinal());
        invalid.add(ColumnWidth.WidthType.INCHES.ordinal());
        invalid.add(ColumnWidth.WidthType.POINTS.ordinal());
        assert (!AdhocWebService.isSetConsistent(invalid)) : "invalid set should fail";
        HashSet<Integer> invalid2 = new HashSet<Integer>();
        invalid2.add(ColumnWidth.WidthType.PERCENT.ordinal());
        invalid2.add(ColumnWidth.WidthType.CM.ordinal());
        invalid2.add(ColumnWidth.WidthType.POINTS.ordinal());
        assert (!AdhocWebService.isSetConsistent(invalid2)) : "invalid2 set should fail";
        HashSet<Integer> validPercent = new HashSet<Integer>();
        validPercent.add(ColumnWidth.WidthType.PERCENT.ordinal());
        assert (AdhocWebService.isSetConsistent(validPercent)) : "validPercent set should succeed";
        HashSet<Integer> validMeasures = new HashSet<Integer>();
        validMeasures.add(ColumnWidth.WidthType.CM.ordinal());
        validMeasures.add(ColumnWidth.WidthType.INCHES.ordinal());
        validMeasures.add(ColumnWidth.WidthType.POINTS.ordinal());
        assert (AdhocWebService.isSetConsistent(validMeasures)) : "validMeasures set should succeed";
        HashSet<Integer> validMeasures2 = new HashSet<Integer>();
        validMeasures2.add(ColumnWidth.WidthType.INCHES.ordinal());
        validMeasures2.add(ColumnWidth.WidthType.POINTS.ordinal());
        assert (AdhocWebService.isSetConsistent(validMeasures2)) : "validMeasures2 set should succeed";
        HashSet<Integer> validMeasures3 = new HashSet<Integer>();
        validMeasures3.add(ColumnWidth.WidthType.POINTS.ordinal());
        assert (AdhocWebService.isSetConsistent(validMeasures3)) : "validMeasures3 set should succeed";
        HashSet<Integer> validEmtpy = new HashSet<Integer>();
        assert (AdhocWebService.isSetConsistent(validEmtpy)) : "validEmtpy set should succeed";
        System.out.println("looks like it worked.");
    }

    static {
        METADATA_TYPE_TO_REPORT_SPEC_TYPE.put(DataType.NUMERIC, "number-field");
        METADATA_TYPE_TO_REPORT_SPEC_TYPE.put(DataType.DATE, "date-field");
        METADATA_TYPE_TO_REPORT_SPEC_TYPE.put(DataType.STRING, "string-field");
        HashSet<Integer> tmp = new HashSet<Integer>();
        tmp.add(ColumnWidth.WidthType.PERCENT.ordinal());
        PERCENT_SET = Collections.unmodifiableSet(tmp);
    }
}

