/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.ActionSequenceDocument;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.actions.PivotViewAction;
import org.pentaho.platform.api.data.IDatasourceService;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.engine.PentahoSystemException;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.api.util.XmlParseException;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.WebServiceUtil;
import org.pentaho.platform.engine.services.solution.PentahoEntityResolver;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCube;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianDataSource;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.pentaho.platform.web.http.request.HttpRequestParameterProvider;
import org.pentaho.platform.web.servlet.ServletBase;
import org.pentaho.platform.web.servlet.messages.Messages;
import org.xml.sax.EntityResolver;

public class AnalysisViewService
extends ServletBase {
    public static String ANALYSIS_VIEW_TEMPLATE = "analysis_view_template.xaction";
    private static final long serialVersionUID = 831738225052159697L;
    private static final Log logger = LogFactory.getLog(AnalysisViewService.class);
    private final IMondrianCatalogService mondrianCatalogService = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class);

    public Log getLogger() {
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String component = request.getParameter("component");
        if (component.equalsIgnoreCase("newView")) {
            this.newAnalysisView(request, response);
            return;
        }
        PentahoSystem.systemEntryPoint();
        try {
            boolean wrapWithSoap = "false".equals(request.getParameter("ajax"));
            String solutionName = request.getParameter("solution");
            String actionPath = request.getParameter("path");
            String actionName = request.getParameter("action");
            String content = null;
            try {
                content = this.getPayloadAsString(request);
            }
            catch (IOException ioEx) {
                String msg = Messages.getErrorString("AdhocWebService.ERROR_0006_FAILED_TO_GET_PAYLOAD_FROM_REQUEST");
                this.error(msg, ioEx);
                WebServiceUtil.writeString((OutputStream)response.getOutputStream(), (String)WebServiceUtil.getErrorXml((String)(msg + " " + ioEx.getLocalizedMessage())), (boolean)false);
            }
            HttpRequestParameterProvider parameterProvider = null;
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (!StringUtils.isEmpty((String)content)) {
                Document doc = null;
                try {
                    doc = XmlDom4JHelper.getDocFromString((String)content, (EntityResolver)new PentahoEntityResolver());
                }
                catch (XmlParseException e) {
                    String msg = Messages.getErrorString("HttpWebService.ERROR_0001_ERROR_DURING_WEB_SERVICE");
                    this.error(msg, e);
                    WebServiceUtil.writeString((OutputStream)response.getOutputStream(), (String)WebServiceUtil.getErrorXml((String)msg), (boolean)false);
                }
                List parameterNodes = doc.selectNodes("//SOAP-ENV:Body/*/*");
                for (int i = 0; i < parameterNodes.size(); ++i) {
                    Node parameterNode = (Node)parameterNodes.get(i);
                    String parameterName = parameterNode.getName();
                    String parameterValue = parameterNode.getText();
                    if ("action".equals(parameterName)) {
                        ActionInfo info = ActionInfo.parseActionString((String)parameterValue);
                        solutionName = info.getSolutionName();
                        actionPath = info.getPath();
                        actionName = info.getActionName();
                        parameters.put("solution", solutionName);
                        parameters.put("path", actionPath);
                        parameters.put("name", actionName);
                        continue;
                    }
                    if ("component".equals(parameterName)) {
                        component = parameterValue;
                        continue;
                    }
                    parameters.put(parameterName, parameterValue);
                }
                parameterProvider = new SimpleParameterProvider(parameters);
            } else {
                parameterProvider = new HttpRequestParameterProvider(request);
            }
            if (!"generatePreview".equals(component)) {
                response.setContentType("text/xml");
                response.setCharacterEncoding(LocaleHelper.getSystemEncoding());
            }
            IPentahoSession userSession = this.getPentahoSession(request);
            this.dispatch(request, response, component, (IParameterProvider)parameterProvider, userSession, wrapWithSoap);
        }
        catch (IOException ioEx) {
            String msg = Messages.getErrorString("HttpWebService.ERROR_0001_ERROR_DURING_WEB_SERVICE");
            this.error(msg, ioEx);
            WebServiceUtil.writeString((OutputStream)response.getOutputStream(), (String)WebServiceUtil.getErrorXml((String)msg), (boolean)false);
        }
        catch (PentahoSystemException ex) {
            String msg = ex.getLocalizedMessage();
            this.error(msg, ex);
            WebServiceUtil.writeString((OutputStream)response.getOutputStream(), (String)WebServiceUtil.getErrorXml((String)msg), (boolean)false);
        }
        catch (PentahoAccessControlException ex) {
            String msg = ex.getLocalizedMessage();
            this.error(msg, ex);
            WebServiceUtil.writeString((OutputStream)response.getOutputStream(), (String)WebServiceUtil.getErrorXml((String)msg), (boolean)false);
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
    }

    protected void dispatch(HttpServletRequest request, HttpServletResponse response, String component, IParameterProvider parameterProvider, IPentahoSession userSession, boolean wrapWithSoap) throws IOException, PentahoSystemException, PentahoAccessControlException {
        if ("createNewView".equals(component)) {
            this.saveXAction(userSession, parameterProvider, request, response, wrapWithSoap);
        } else if ("listCatalogs".equals(component)) {
            this.listCatalogs(userSession, (OutputStream)response.getOutputStream(), wrapWithSoap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newAnalysisView(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PentahoSystem.systemEntryPoint();
        try {
            List catalogs = this.mondrianCatalogService.listCatalogs(this.getPentahoSession(request), true);
            request.setAttribute("catalog", (Object)catalogs);
            try {
                RequestDispatcher dispatcher = request.getRequestDispatcher("NewAnalysisView");
                if (dispatcher != null) {
                    dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                }
            }
            catch (ServletException e) {
                WebServiceUtil.writeString((OutputStream)response.getOutputStream(), (String)WebServiceUtil.getErrorXml((String)e.getMessage()), (boolean)false);
            }
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
    }

    public void listCatalogs(IPentahoSession userSession, OutputStream outputStream, boolean wrapWithSoap) throws IOException {
        StringBuilder builder = new StringBuilder();
        List catalogs = this.mondrianCatalogService.listCatalogs(userSession, true);
        builder.append("<catalogs>");
        for (MondrianCatalog catalog : catalogs) {
            builder.append("<catalog name=\"" + catalog.getName() + "\">");
            builder.append("<schema name=\"" + catalog.getSchema().getName() + "\">");
            builder.append("<cubes>");
            for (MondrianCube cube : catalog.getSchema().getCubes()) {
                builder.append("<cube name=\"" + cube.getName() + "\" />");
            }
            builder.append("</cubes>");
            builder.append("</schema>");
            builder.append("</catalog>");
        }
        builder.append("</catalogs>");
        WebServiceUtil.writeString((OutputStream)outputStream, (String)builder.toString(), (boolean)wrapWithSoap);
    }

    public void saveXAction(IPentahoSession session, IParameterProvider parameterProvider, HttpServletRequest request, HttpServletResponse response, boolean wrapWithSoap) throws IOException, PentahoSystemException, PentahoAccessControlException {
        try {
            String baseUrl;
            String solutionName = parameterProvider.getStringParameter("solution", null);
            String solutionPath = parameterProvider.getStringParameter("actionPath", null);
            String model = parameterProvider.getStringParameter("schema", null);
            String cube = parameterProvider.getStringParameter("cube", null);
            String title = parameterProvider.getStringParameter("name", null);
            String description = parameterProvider.getStringParameter("descr", null);
            String jndi = null;
            String jdbc = null;
            String xactionFilename = parameterProvider.getStringParameter("actionName", null);
            MondrianCatalog selectedCatalog = this.mondrianCatalogService.getCatalog(model, session);
            if (selectedCatalog == null) {
                throw new PentahoSystemException(Messages.getString("AnalysisViewService.ERROR_0004_MODEL_NULL"));
            }
            MondrianDataSource datasource = selectedCatalog.getEffectiveDataSource();
            if (datasource.isJndi()) {
                try {
                    IDatasourceService datasourceService = (IDatasourceService)PentahoSystem.getObjectFactory().get(IDatasourceService.class, null);
                    jndi = datasourceService.getDSUnboundName(datasource.getJndi());
                }
                catch (ObjectFactoryException objface) {
                    Logger.error((String)"AnalysisViewService", (String)Messages.getErrorString("AnalysisViewService.ERROR_0001_UNABLE_TO_FACTORY_OBJECT", jndi), (Throwable)objface);
                }
            } else {
                jdbc = datasource.getJdbc();
            }
            model = selectedCatalog.getDefinition();
            if (solutionName == null || solutionName.equals("")) {
                throw new PentahoSystemException(Messages.getString("AnalysisViewService.ERROR_0001_SOLUTION_NAME_NULL"));
            }
            if (solutionPath == null || solutionPath.equals("")) {
                solutionPath = "/";
            }
            if (title == null || title.equals("")) {
                throw new PentahoSystemException(Messages.getString("AnalysisViewService.ERROR_0003_TITLE_NULL"));
            }
            if (model == null || model.equals("")) {
                throw new PentahoSystemException(Messages.getString("AnalysisViewService.ERROR_0004_MODEL_NULL"));
            }
            if (description == null || description.equals("")) {
                throw new PentahoSystemException(Messages.getString("AnalysisViewService.ERROR_0005_DESCRIPTION_NULL"));
            }
            if (jndi == null || jndi.equals("")) {
                throw new PentahoSystemException(Messages.getString("AnalysisViewService.ERROR_0006_JNDI_NULL"));
            }
            if (cube == null || cube.equals("")) {
                throw new PentahoSystemException(Messages.getString("AnalysisViewService.ERROR_0007_CUBE_NULL"));
            }
            if (xactionFilename == null || xactionFilename.equals("")) {
                throw new PentahoSystemException(Messages.getString("AnalysisViewService.ERROR_0008_XACTION_NULL"));
            }
            String path = solutionName;
            if (!solutionName.endsWith("/") && !solutionPath.startsWith("/")) {
                path = path + "/";
            }
            if (!xactionFilename.endsWith(".xaction")) {
                xactionFilename = xactionFilename + ".xaction";
            }
            path = path + solutionPath;
            boolean overwrite = parameterProvider.getStringParameter("overwrite", "false").equalsIgnoreCase("true");
            String xaction = this.generateXAction(session, title, description, model, jndi, jdbc, cube);
            ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)session);
            int xactionSaveStatus = repository.publish(baseUrl = PentahoSystem.getApplicationContext().getSolutionPath(""), path, xactionFilename, xaction.getBytes(), overwrite);
            if (xactionSaveStatus == 3) {
                response.sendRedirect("ViewAction?solution=" + solutionName + "&path=" + solutionPath + "&action=" + xactionFilename);
            }
        }
        catch (PentahoSystemException e) {
            this.sendXActionError(e.getMessage(), request, response);
        }
    }

    public String generateXAction(IPentahoSession session, String title, String description, String model, String jndi, String jdbc, String cube) throws PentahoSystemException {
        ActionSequenceDocument doc = this.loadAnalysisViewTemplate(session);
        doc.setTitle(title);
        if (session.getName() != null) {
            doc.setAuthor(session.getName());
        } else {
            doc.setAuthor("Analysis View");
        }
        doc.setDescription(description);
        PivotViewAction action = (PivotViewAction)doc.getElement("/action-sequence/actions/action-definition[component-name='PivotViewComponent']");
        action.setModel((IActionInputSource)new ActionInputConstant(model, null));
        if (jndi == null) {
            throw new PentahoSystemException(Messages.getErrorString("AnalysisViewService.ERROR_0006_JNDI_NULL"));
        }
        action.setJndi((IActionInputSource)new ActionInputConstant(jndi, null));
        action.setComponentDefinition("cube", cube);
        return doc.toString();
    }

    public ActionSequenceDocument loadAnalysisViewTemplate(IPentahoSession session) throws PentahoSystemException {
        String analysisViewTemplate = "system" + File.separator + "mondrian" + File.separator + ANALYSIS_VIEW_TEMPLATE;
        InputStream is = null;
        try {
            ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)session);
            if (repository.resourceExists(analysisViewTemplate, 1)) {
                is = repository.getResourceInputStream(analysisViewTemplate, false, 1);
                SAXReader reader = new SAXReader();
                Document doc = reader.read(is);
                ActionSequenceDocument actionSequenceDocument = new ActionSequenceDocument(doc);
                return actionSequenceDocument;
            }
            try {
                throw new PentahoSystemException(Messages.getString("AnalysisViewService.ERROR_0009_TEMPLATE_DOES_NOT_EXIST", analysisViewTemplate));
            }
            catch (DocumentException e) {
                throw new PentahoSystemException(Messages.getString("AnalysisViewService.ERROR_0010_TEMPLATE_DOES_NOT_PARSE", analysisViewTemplate), (Throwable)e);
            }
            catch (IOException ioe) {
                throw new PentahoSystemException((Throwable)ioe);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public String getPayloadAsString(HttpServletRequest request) throws IOException {
        ServletInputStream is = request.getInputStream();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        String content = null;
        byte[] buffer = new byte[2048];
        int b = is.read(buffer);
        while (b > 0) {
            os.write(buffer, 0, b);
            b = is.read(buffer);
        }
        content = os.toString(LocaleHelper.getSystemEncoding());
        return content;
    }

    private void sendXActionError(String errorString, HttpServletRequest request, HttpServletResponse response) throws IOException {
        request.setAttribute("errorMessage", (Object)errorString);
        this.newAnalysisView(request, response);
    }
}

