/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.cache.ICacheExpirationRegistry;
import org.pentaho.platform.api.cache.ILastModifiedCacheItem;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.SoapHelper;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.web.servlet.ServletBase;

public class CacheExpirationService
extends ServletBase {
    private static final Log logger = LogFactory.getLog(CacheExpirationService.class);
    private ICacheExpirationRegistry cacheExpirationRegistry;

    public Log getLogger() {
        return logger;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.cacheExpirationRegistry == null) {
            this.cacheExpirationRegistry = (ICacheExpirationRegistry)PentahoSystem.get(ICacheExpirationRegistry.class, null);
        }
        ServletOutputStream outputStream = response.getOutputStream();
        try {
            response.setContentType("text/xml");
            response.setStatus(200);
            outputStream.write(SoapHelper.getSoapHeader().getBytes(LocaleHelper.getSystemEncoding()));
            outputStream.write(SoapHelper.openSoapResponse().getBytes(LocaleHelper.getSystemEncoding()));
            outputStream.write(this.getXml().getBytes(LocaleHelper.getSystemEncoding()));
            outputStream.write(SoapHelper.closeSoapResponse().getBytes(LocaleHelper.getSystemEncoding()));
            outputStream.write(SoapHelper.getSoapFooter().getBytes(LocaleHelper.getSystemEncoding()));
        }
        finally {
            outputStream.close();
        }
    }

    public void setExpirationRegistry(ICacheExpirationRegistry registry) {
        this.cacheExpirationRegistry = registry;
    }

    public String getXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<cache-expiration-items>");
        if (this.cacheExpirationRegistry != null) {
            List cacheItems = this.cacheExpirationRegistry.getCachedItems();
            for (ILastModifiedCacheItem item : cacheItems) {
                sb.append("<cache-item>");
                sb.append("<key>");
                sb.append(item.getCacheKey());
                sb.append("</key>");
                sb.append("<last-modified>");
                sb.append(Long.toString(item.getLastModified()));
                sb.append("</last-modified>");
                sb.append("</cache-item>");
            }
        }
        sb.append("</cache-expiration-items>");
        return sb.toString();
    }
}

