/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.io.IOUtils;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository.IContentRepository;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.web.servlet.ServletBase;
import org.pentaho.platform.web.servlet.messages.Messages;

public class GetContent
extends ServletBase {
    private static final long serialVersionUID = 9019152264205996418L;
    private static final Log logger = LogFactory.getLog(GetContent.class);

    public Log getLogger() {
        return logger;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        IContentItem contentItem;
        block16: {
            IContentRepository contentRepos;
            String id;
            block15: {
                IPentahoSession userSession;
                block14: {
                    response.setCharacterEncoding(LocaleHelper.getSystemEncoding());
                    PentahoSystem.systemEntryPoint();
                    userSession = this.getPentahoSession(request);
                    id = request.getParameter("id");
                    if (id != null) break block14;
                    this.returnError(response, Messages.getErrorString("GetContent.ERROR_0001_ID_PARAMETER_EMPTY"));
                    PentahoSystem.systemExitPoint();
                    return;
                }
                contentRepos = (IContentRepository)PentahoSystem.get(IContentRepository.class, (IPentahoSession)userSession);
                if (contentRepos != null) break block15;
                this.returnError(response, Messages.getString("GetContent.ERROR_0002_CONTENT_REPOS_UNAVAILABLE"));
                PentahoSystem.systemExitPoint();
                return;
            }
            contentItem = contentRepos.getContentItemById(id);
            if (contentItem != null) break block16;
            this.returnError(response, Messages.getString("GetContent.ERROR_0005_CONTENT_NOT_FOUND", id));
            PentahoSystem.systemExitPoint();
            return;
        }
        try {
            try {
                String mimetype = contentItem.getMimeType();
                if (mimetype == null || mimetype.length() < 1) {
                    mimetype = request.getParameter("mimetype");
                }
                if (mimetype != null && mimetype.length() > 0) {
                    response.setContentType(mimetype);
                }
                if (!mimetype.equalsIgnoreCase("text/html")) {
                    response.setHeader("Content-Disposition", "inline; filename=\"" + contentItem.getTitle() + "\"");
                }
                InputStream inStr = contentItem.getInputStream();
                ServletOutputStream outStr = response.getOutputStream();
                try {
                    IOUtils.getInstance().copyStreams(inStr, (OutputStream)outStr);
                }
                finally {
                    inStr.close();
                }
            }
            catch (Exception ex) {
                this.error(Messages.getErrorString("GetContent.ERROR_0003_CONTENT_READ_ERROR"), ex);
            }
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
    }

    void returnError(HttpServletResponse response, String message) {
        this.error(message);
        response.setContentType("text/plain");
        try {
            response.getWriter().println(Messages.getString("GetContent.ERROR_0004_RETURN_MESSAGE") + message);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

