/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyLoader;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import com.google.gwt.user.server.rpc.impl.StandardSerializationPolicy;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.api.engine.IServiceManager;
import org.pentaho.platform.api.engine.ServiceException;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.pluginmgr.PluginUtil;
import org.pentaho.platform.web.servlet.messages.Messages;

public class GwtRpcPluginProxyServlet
extends RemoteServiceServlet {
    private static final long serialVersionUID = -7652708468110168124L;
    private static final Log logger = LogFactory.getLog(GwtRpcPluginProxyServlet.class);
    private static final ThreadLocal<Object> perThreadTargetBean = new ThreadLocal();

    protected void doUnexpectedFailure(Throwable e) {
        super.doUnexpectedFailure(e);
        logger.error((Object)e.getMessage(), e);
    }

    public String getDispatchKey() {
        HttpServletRequest request = this.getThreadLocalRequest();
        String requestPathInfo = request.getPathInfo();
        if (requestPathInfo.startsWith("/")) {
            requestPathInfo = requestPathInfo.substring(1);
        }
        return requestPathInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processCall(String payload) throws SerializationException {
        HashMap<Class<ServiceException>, Boolean> whitelist = new HashMap<Class<ServiceException>, Boolean>();
        whitelist.put(ServiceException.class, Boolean.TRUE);
        HashMap obfuscatedTypeIds = new HashMap();
        StandardSerializationPolicy policy = new StandardSerializationPolicy(whitelist, whitelist, obfuscatedTypeIds);
        IServiceManager serviceManager = (IServiceManager)PentahoSystem.get(IServiceManager.class, (IPentahoSession)PentahoSessionHolder.getSession());
        String serviceId = this.getDispatchKey();
        if (null == serviceManager.getServiceConfig("gwt", serviceId)) {
            String errMsg = Messages.getErrorString("GwtRpcPluginProxyServlet.ERROR_0001_SERVICE_NOT_FOUND", serviceId);
            logger.error((Object)errMsg);
            return RPC.encodeResponseForFailure(null, (Throwable)new ServiceException(errMsg), (SerializationPolicy)policy);
        }
        Object targetBean = null;
        try {
            targetBean = serviceManager.getServiceBean("gwt", serviceId);
        }
        catch (ServiceException e) {
            logger.error((Object)Messages.getErrorString("GwtRpcPluginProxyServlet.ERROR_0002_FAILED_TO_GET_BEAN_REFERENCE", serviceId), (Throwable)e);
            return RPC.encodeResponseForFailure(null, (Throwable)e, (SerializationPolicy)policy);
        }
        perThreadTargetBean.set(targetBean);
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(targetBean.getClass().getClassLoader());
            RPCRequest rpcRequest = RPC.decodeRequest((String)payload, null, (SerializationPolicyProvider)this);
            this.onAfterRequestDeserialized(rpcRequest);
            Method method = rpcRequest.getMethod();
            try {
                Method m = targetBean.getClass().getMethod(method.getName(), method.getParameterTypes());
                if (m != null) {
                    method = m;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String string = RPC.invokeAndEncodeResponse((Object)targetBean, (Method)method, (Object[])rpcRequest.getParameters(), (SerializationPolicy)rpcRequest.getSerializationPolicy());
            return string;
        }
        catch (IncompatibleRemoteServiceException ex) {
            logger.error((Object)Messages.getErrorString("GwtRpcPluginProxyServlet.ERROR_0003_RPC_INVOCATION_FAILED", targetBean.getClass().getName()), (Throwable)ex);
            String string = RPC.encodeResponseForFailure(null, (Throwable)ex);
            return string;
        }
        finally {
            if (origLoader != null) {
                Thread.currentThread().setContextClassLoader(origLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SerializationPolicy doGetSerializationPolicy(HttpServletRequest request, String moduleBaseURL, String strongName) {
        String servletContextPath;
        String pluginServiceContextPath;
        ClassLoader serviceClassloader;
        SerializationPolicy serializationPolicy = null;
        String appContextPath = request.getContextPath();
        String modulePath = null;
        if (moduleBaseURL != null) {
            try {
                modulePath = new URL(moduleBaseURL).getPath();
            }
            catch (MalformedURLException ex) {
                logger.error((Object)Messages.getErrorString("GwtRpcPluginProxyServlet.ERROR_0004_MALFORMED_URL", moduleBaseURL), (Throwable)ex);
                return null;
            }
        }
        if ((serviceClassloader = PluginUtil.getClassLoaderForService((String)(pluginServiceContextPath = (servletContextPath = modulePath.substring(appContextPath.length())).substring(servletContextPath.indexOf(47, 1))))) == null) {
            logger.error((Object)Messages.getErrorString("GwtRpcPluginProxyServlet.ERROR_0005_FAILED_TO_FIND_PLUGIN", appContextPath));
        }
        String serializationPolicyFile = SerializationPolicyLoader.getSerializationPolicyFileName((String)strongName);
        InputStream rpcFileInputStream = null;
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, (IPentahoSession)PentahoSessionHolder.getSession());
        List urls = resLoader.findResources(serviceClassloader, serializationPolicyFile);
        if (urls.size() < 1) {
            logger.error((Object)Messages.getErrorString("GwtRpcPluginProxyServlet.ERROR_0006_FAILED_TO_FIND_FILE", serializationPolicyFile));
        } else if (urls.size() > 1) {
            logger.warn((Object)Messages.getString("GwtRpcPluginProxyServlet.WARN_MULTIPLE_RESOURCES_FOUND", serializationPolicyFile));
        } else {
            try {
                rpcFileInputStream = ((URL)urls.get(0)).openStream();
                if (rpcFileInputStream != null) {
                    serializationPolicy = SerializationPolicyLoader.loadFromStream((InputStream)rpcFileInputStream, null);
                }
            }
            catch (IOException e) {
                logger.error((Object)Messages.getErrorString("GwtRpcPluginProxyServlet.ERROR_0007_FAILED_TO_OPEN_FILE", serializationPolicyFile), (Throwable)e);
            }
            catch (ParseException e) {
                logger.error((Object)Messages.getErrorString("GwtRpcPluginProxyServlet.ERROR_0008_FAILED_TO_PARSE_FILE", serializationPolicyFile), (Throwable)e);
            }
            finally {
                if (rpcFileInputStream != null) {
                    try {
                        rpcFileInputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return serializationPolicy;
    }
}

